/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDBooleanCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.BooleanValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class BooleanPatternDatatype
extends AbstractDatatype {
    private int lastValidBooleanID;

    public BooleanPatternDatatype(QName datatypeIdentifier) {
        super(BuiltInType.BOOLEAN_PATTERN, datatypeIdentifier);
        this.rcs = new XSDBooleanCharacterSet();
    }

    public boolean isValid(String value) {
        boolean retValue = true;
        if (value.equals("false")) {
            this.lastValidBooleanID = 0;
        } else if (value.equals("0")) {
            this.lastValidBooleanID = 1;
        } else if (value.equals("true")) {
            this.lastValidBooleanID = 2;
        } else if (value.equals("1")) {
            this.lastValidBooleanID = 3;
        } else {
            retValue = false;
        }
        return retValue;
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.lastValidBooleanID, 2);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        int booleanID = valueChannel.decodeNBitUnsignedInteger(2);
        return new BooleanValue(booleanID);
    }
}

