/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDBooleanCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.datatype.XSDBoolean;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class BooleanDatatype
extends AbstractDatatype {
    protected XSDBoolean lastValidBoolean = XSDBoolean.newInstance();

    public BooleanDatatype(QName datatypeIdentifier) {
        super(BuiltInType.BOOLEAN, datatypeIdentifier);
        this.rcs = new XSDBooleanCharacterSet();
    }

    public boolean isValid(String value) {
        return this.lastValidBoolean.parse(value);
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeBoolean(this.lastValidBoolean);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        return valueChannel.decodeBooleanValue();
    }
}

