/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.EXIEncoderInOrder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.exceptions.ErrorHandler;
import com.siemens.ct.exi.grammar.event.EventType;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;

public class EXIEncoderInOrderSC
extends EXIEncoderInOrder {
    protected EXIEncoderInOrderSC scEncoder;

    public EXIEncoderInOrderSC(EXIFactory exiFactory) {
        super(exiFactory);
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.scEncoder = null;
    }

    public void setOutput(OutputStream os, boolean exiBodyOnly) throws EXIException {
        if (this.scEncoder == null) {
            super.setOutput(os, exiBodyOnly);
        } else {
            this.scEncoder.setOutput(os, exiBodyOnly);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (this.scEncoder == null) {
            super.setErrorHandler(errorHandler);
        } else {
            this.scEncoder.setErrorHandler(errorHandler);
        }
    }

    public void encodeStartDocument() throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeStartDocument();
        } else {
            this.scEncoder.encodeStartDocument();
        }
    }

    public void encodeEndDocument() throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeEndDocument();
        } else {
            this.scEncoder.encodeEndDocument();
        }
    }

    public void encodeStartElement(String uri, String localName, String prefix) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeStartElement(uri, localName, prefix);
            QName qname = this.elementContext.qname;
            if (this.exiFactory.isSelfContainedElement(qname)) {
                int ec2 = this.currentRule.get2ndLevelEventCode(EventType.SELF_CONTAINED, this.fidelityOptions);
                this.encode2ndLevelEventCode(ec2);
                EXIFactory scEXIFactory = this.exiFactory.clone();
                scEXIFactory.setEXIBodyOnly(true);
                scEXIFactory.setFragment(true);
                this.scEncoder = (EXIEncoderInOrderSC)scEXIFactory.createEXIEncoder();
                this.scEncoder.os = this.os;
                this.scEncoder.channel = this.channel;
                this.scEncoder.setErrorHandler(this.errorHandler);
                this.channel.align();
                this.scEncoder.encodeStartDocument();
                this.scEncoder.encodeStartElementNoSC(uri, localName, prefix);
            }
        } else {
            this.scEncoder.encodeStartElement(uri, localName, prefix);
            QName qname = this.scEncoder.elementContext.qname;
        }
    }

    protected void encodeStartElementNoSC(String uri, String localName, String prefix) throws EXIException, IOException {
        super.encodeStartElement(uri, localName, prefix);
    }

    public void encodeEndElement() throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeEndElement();
        } else {
            QName qname = this.scEncoder.elementContext.qname;
            this.scEncoder.encodeEndElement();
            if (this.getElementContextQName().equals(qname)) {
                this.scEncoder.encodeEndDocument();
                this.channel.align();
                this.scEncoder = null;
                super.popElement();
            }
        }
    }

    public void encodeAttribute(String uri, String localName, String prefix, String value) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeAttribute(uri, localName, prefix, value);
        } else {
            this.scEncoder.encodeAttribute(uri, localName, prefix, value);
        }
    }

    public void encodeNamespaceDeclaration(String uri, String prefix) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeNamespaceDeclaration(uri, prefix);
        } else {
            this.scEncoder.encodeNamespaceDeclaration(uri, prefix);
        }
    }

    public void encodeXsiNil(String value, String pfx) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeXsiNil(value, pfx);
        } else {
            this.scEncoder.encodeXsiNil(value, pfx);
        }
    }

    public void encodeXsiType(String xsiTypeRaw) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeXsiType(xsiTypeRaw);
        } else {
            this.scEncoder.encodeXsiType(xsiTypeRaw);
        }
    }

    public void encodeCharacters(String chars) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeCharacters(chars);
        } else {
            this.scEncoder.encodeCharacters(chars);
        }
    }

    public void encodeDocType(String name, String publicID, String systemID, String text) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeDocType(name, publicID, systemID, text);
        } else {
            this.scEncoder.encodeDocType(name, publicID, systemID, text);
        }
    }

    public void encodeEntityReference(String name) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeEntityReference(name);
        } else {
            this.scEncoder.encodeEntityReference(name);
        }
    }

    public void encodeComment(char[] ch, int start, int length) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeComment(ch, start, length);
        } else {
            this.scEncoder.encodeComment(ch, start, length);
        }
    }

    public void encodeProcessingInstruction(String target, String data) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeProcessingInstruction(target, data);
        } else {
            this.scEncoder.encodeProcessingInstruction(target, data);
        }
    }
}

