/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.attributes;

import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.attributes.AttributeList;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public abstract class AbstractAttributeList
implements AttributeList {
    public static final int XMLNS_PFX_START = "xmlns".length() + 1;
    protected FidelityOptions fidelityOptions;
    protected boolean preserveSchemaLocation;
    protected boolean preservePrefixes;
    protected boolean hasXsiType;
    protected String xsiTypeRaw;
    protected boolean hasXsiNil;
    protected String xsiNil;
    protected String xsiNilPrefix;
    protected List<String> attributeURI;
    protected List<String> attributeLocalName;
    protected List<String> attributeValue;
    protected List<String> attributePrefix;

    public AbstractAttributeList(FidelityOptions fidelityOptions) {
        this.fidelityOptions = fidelityOptions;
        this.preserveSchemaLocation = fidelityOptions.isFidelityEnabled("PRESERVE_XSI_SCHEMALOCATION");
        this.preservePrefixes = fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES");
        this.attributeURI = new ArrayList<String>();
        this.attributeLocalName = new ArrayList<String>();
        this.attributeValue = new ArrayList<String>();
        this.attributePrefix = new ArrayList<String>();
    }

    protected void init() {
        this.hasXsiType = false;
        this.hasXsiNil = false;
        this.attributeURI.clear();
        this.attributeLocalName.clear();
        this.attributeValue.clear();
        this.attributePrefix.clear();
    }

    public boolean hasXsiType() {
        return this.hasXsiType;
    }

    public String getXsiTypeRaw() {
        return this.xsiTypeRaw;
    }

    public boolean hasXsiNil() {
        return this.hasXsiNil;
    }

    public String getXsiNil() {
        return this.xsiNil;
    }

    public String getXsiNilPrefix() {
        return this.xsiNilPrefix;
    }

    public int getNumberOfAttributes() {
        return this.attributeURI.size();
    }

    public String getAttributeURI(int index) {
        return this.attributeURI.get(index);
    }

    public String getAttributeLocalName(int index) {
        return this.attributeLocalName.get(index);
    }

    public String getAttributeValue(int index) {
        return this.attributeValue.get(index);
    }

    public String getAttributePrefix(int index) {
        return this.attributePrefix.get(index);
    }

    private void setXsiNil(String rawNil, String xsiPrefix) {
        this.hasXsiNil = true;
        this.xsiNil = rawNil;
        this.xsiNilPrefix = xsiPrefix;
    }

    public void parse(Attributes atts) {
        this.init();
        this.xsiTypeRaw = null;
        int i = 0;
        while (i < atts.getLength()) {
            String localName = atts.getLocalName(i);
            String uri = atts.getURI(i);
            if (uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                if (localName.equals("type")) {
                    this.hasXsiType = true;
                    this.xsiTypeRaw = atts.getValue(i);
                } else if (localName.equals("nil")) {
                    this.setXsiNil(atts.getValue(i), this.getPrefixOf(atts, i));
                } else if (!localName.equals("schemaLocation") && !localName.equals("noNamespaceSchemaLocation") || this.preserveSchemaLocation) {
                    this.insertAttribute(atts.getURI(i), atts.getLocalName(i), this.getPrefixOf(atts, i), atts.getValue(i));
                }
            } else {
                this.insertAttribute(atts.getURI(i), atts.getLocalName(i), this.getPrefixOf(atts, i), atts.getValue(i));
            }
            ++i;
        }
    }

    public void parse(NamedNodeMap attributes) {
        this.init();
        this.xsiTypeRaw = null;
        int i = 0;
        while (i < attributes.getLength()) {
            Node at = attributes.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(at.getNamespaceURI())) {
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(at.getNamespaceURI())) {
                    if (at.getLocalName().equals("type")) {
                        this.hasXsiType = true;
                        this.xsiTypeRaw = at.getNodeValue();
                    } else if (at.getLocalName().equals("nil")) {
                        this.setXsiNil(at.getNodeValue(), at.getPrefix());
                    } else if (!at.getLocalName().equals("schemaLocation") && !at.getLocalName().equals("noNamespaceSchemaLocation") || this.preserveSchemaLocation) {
                        this.insertAttribute(at.getNamespaceURI() == null ? "" : at.getNamespaceURI(), at.getLocalName(), at.getPrefix() == null ? "" : at.getPrefix(), at.getNodeValue());
                    }
                } else {
                    this.insertAttribute(at.getNamespaceURI() == null ? "" : at.getNamespaceURI(), at.getLocalName(), at.getPrefix() == null ? "" : at.getPrefix(), at.getNodeValue());
                }
            }
            ++i;
        }
    }

    private String getPrefixOf(Attributes atts, int index) {
        String qname = atts.getQName(index);
        String localName = atts.getLocalName(index);
        int lengthDifference = qname.length() - localName.length();
        return lengthDifference == 0 ? "" : qname.substring(0, lengthDifference - 1);
    }

    protected abstract void insertAttribute(String var1, String var2, String var3, String var4);
}

