/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.sax;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.api.sax.EXIWriter;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.helpers.DefaultEXIFactory;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.sax.SAXResult;

public class EXIResult
extends SAXResult {
    protected OutputStream os;
    protected EXIFactory exiFactory;

    public EXIResult(OutputStream os) throws IOException {
        this(os, DefaultEXIFactory.newInstance());
    }

    public EXIResult(OutputStream os, EXIFactory exiFactory) throws IOException {
        this.os = os;
        this.exiFactory = exiFactory;
        this.init();
    }

    protected void init() throws IOException {
        EXIWriter saxEncoder = this.exiFactory.createEXIWriter();
        try {
            saxEncoder.setOutput(this.os, this.exiFactory.isEXIBodyOnly());
        }
        catch (EXIException e) {
            throw new IOException(e.getMessage());
        }
        this.setHandler(saxEncoder);
        this.setLexicalHandler(saxEncoder);
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void setOutputStream(OutputStream os) throws IOException {
        this.os = os;
        this.init();
    }
}

