/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.dom;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.api.dom.SaxToDomHandler;
import com.siemens.ct.exi.exceptions.EXIException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DOMBuilder {
    protected EXIFactory factory;
    protected DOMImplementation domImplementation;

    public DOMBuilder(EXIFactory factory) throws ParserConfigurationException {
        this.factory = factory;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        this.domImplementation = builder.getDOMImplementation();
    }

    public DocumentFragment parseFragment(InputStream is) throws EXIException {
        try {
            Document document = this.domImplementation.createDocument(null, null, null);
            DocumentFragment docFragment = document.createDocumentFragment();
            SaxToDomHandler s2dHandler = new SaxToDomHandler(document, docFragment);
            XMLReader reader = this.factory.createEXIReader();
            reader.setContentHandler(s2dHandler);
            reader.parse(new InputSource(is));
            return docFragment;
        }
        catch (Exception e) {
            throw new EXIException(e);
        }
    }

    public Document parse(InputStream is) throws EXIException {
        try {
            Document document = this.domImplementation.createDocument(null, null, null);
            SaxToDomHandler s2dHandler = new SaxToDomHandler(document);
            XMLReader reader = this.factory.createEXIReader();
            reader.setContentHandler(s2dHandler);
            reader.setDTDHandler(s2dHandler);
            reader.parse(new InputSource(is));
            return document;
        }
        catch (Exception e) {
            throw new EXIException(e);
        }
    }
}

