package org.bbreak.excella.reports.exporter;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.reports.model.ConvertConfiguration;

/**
 * Streamo̓GNX|[^[
 *
 * @since 1.1
 */
public class OutputStreamExporter extends ReportBookExporter {

    /**
     * O
     */
    private static Log log = LogFactory.getLog( OoPdfExporter.class);

    /**
     * o͐
     */
    private OutputStream outputStream;

    /**
     * RXgN^
     * @param outputStream o͐
     */
    public OutputStreamExporter( OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public String getExtention() {
        return null;
    }

    @Override
    public String getFormatType() {
        return ExcelExporter.FORMAT_TYPE;
    }

    @Override
    public void output( Workbook book, BookData bookdata, ConvertConfiguration configuration) throws ExportException {

        if ( log.isInfoEnabled()) {
            log.info( "ʂ" + getFilePath() + "ɏo͂܂");
        }
        try {
            book.write( outputStream);
        } catch ( IOException e) {
            throw new ExportException( e);
        }
    }
}
