/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: SingleParamParserTest.java 5 2009-06-22 07:55:44Z tomo-shibata $
 * $Revision: 5 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.fail;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.reports.ReportsTestUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.processor.ReportsCheckException;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.processor.ReportsWorkbookTest;
import org.junit.Test;

/**
 * {@link org.bbreak.excella.reports.tag.SingleParamParser} ̂߂̃eXgENXB
 * 
 * @since 1.0
 *
 */
public class SingleParamParserTest extends ReportsWorkbookTest {

    /**
     * RXgN^
     * 
     * @param version o[W
     */
    public SingleParamParserTest( String version) {
        super( version);
    }

    /**
     * {@link org.bbreak.excella.reports.tag.SingleParamParser#parse(org.apache.poi.ss.usermodel.Sheet, org.apache.poi.ss.usermodel.Cell, java.lang.Object)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testParseSheetCellObject() {

        // -----------------------
        // [n]ʏ
        // -----------------------

        Workbook workbook = getWorkbook();

        Sheet sheet1 = workbook.getSheetAt( 0);

        // eXgf[^
        ParamInfo info = new ParamInfo();
        //
        info.addParam( SingleParamParser.DEFAULT_TAG, "test", "test!");
        //2oCg
        info.addParam( SingleParamParser.DEFAULT_TAG, "eXg", "eXgł!");
        //byte
        info.addParam( SingleParamParser.DEFAULT_TAG, "test01", ( byte) 1);
        //Byte
        info.addParam( SingleParamParser.DEFAULT_TAG, "test02", new Byte( "1"));
        //short
        info.addParam( SingleParamParser.DEFAULT_TAG, "test03", ( short) 2);
        //Short
        info.addParam( SingleParamParser.DEFAULT_TAG, "test04", new Short( "2"));
        //int
        info.addParam( SingleParamParser.DEFAULT_TAG, "test05", 3);
        //Integer
        info.addParam( SingleParamParser.DEFAULT_TAG, "test06", new Integer( "3"));
        //long
        info.addParam( SingleParamParser.DEFAULT_TAG, "test07", 4L);
        //Long
        info.addParam( SingleParamParser.DEFAULT_TAG, "test08", new Long( "4"));
        //float
        info.addParam( SingleParamParser.DEFAULT_TAG, "test09", 5.1f);
        //Float
        info.addParam( SingleParamParser.DEFAULT_TAG, "test10", new Float( "5.1"));
        //double
        info.addParam( SingleParamParser.DEFAULT_TAG, "test11", 6.1);
        //Double
        info.addParam( SingleParamParser.DEFAULT_TAG, "test12", new Double( 6.1));
        //BigInteger
        info.addParam( SingleParamParser.DEFAULT_TAG, "test13", new BigInteger( "7"));
        //BigDecimal
        info.addParam( SingleParamParser.DEFAULT_TAG, "test14", new BigDecimal( "8.5"));
        //Date
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set( 2009, 4, 22);
        info.addParam( SingleParamParser.DEFAULT_TAG, "test15", cal.getTime());

        SingleParamParser parser = new SingleParamParser();

        ReportsParserInfo reportsParserInfo = new ReportsParserInfo();

        reportsParserInfo.setParamInfo( info);

        // ͏
        try {
            parseSheet( parser, sheet1, reportsParserInfo);
        } catch ( ParseException e) {
            fail(e.toString());
        }
        

        // ҒlubN̓ǂݍ
        Workbook expectedWorkbook = getExpectedWorkbook();
        Sheet expectedSheet = expectedWorkbook.getSheet( "Sheet1");

        try {
            // `FbN
            ReportsTestUtil.checkSheet( expectedSheet, sheet1);
        } catch ( ReportsCheckException e) {
            fail( e.getCheckMessagesToString());
        }

        // -----------------------
        // [n]^O̕ύX
        // -----------------------

        workbook = getWorkbook();

        // eXgf[^
        ParamInfo infoP = new ParamInfo();
        infoP.addParam( "$P", "test", "test!");
        infoP.addParam( "$P", "eXg", "eXgł!");
        infoP.addParam( "$P", "test01", ( byte) 1);
        infoP.addParam( "$P", "test02", new Byte( "1"));
        infoP.addParam( "$P", "test03", ( short) 2);
        infoP.addParam( "$P", "test04", new Short( "2"));
        infoP.addParam( "$P", "test05", 3);
        infoP.addParam( "$P", "test06", new Integer( "3"));
        infoP.addParam( "$P", "test07", 4L);
        infoP.addParam( "$P", "test08", new Long( "4"));
        infoP.addParam( "$P", "test09", 5.1f);
        infoP.addParam( "$P", "test10", new Float( "5.1"));
        infoP.addParam( "$P", "test11", 6.1);
        infoP.addParam( "$P", "test12", new Double( 6.1));
        infoP.addParam( "$P", "test13", new BigInteger( "7"));
        infoP.addParam( "$P", "test14", new BigDecimal( "8.5"));
        cal.clear();
        cal.set( 2009, 4, 22);
        infoP.addParam( "$P", "test15", cal.getTime());

        // RXgN^ɂ^OZbg
        parser = new SingleParamParser( "$P");

        reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.setParamInfo( infoP);

        Sheet sheet2 = workbook.getSheetAt( 1);

        // ͏
        try {
            parseSheet( parser, sheet2, reportsParserInfo);
        } catch ( ParseException e) {
            fail(e.toString());
        }

        // ҒlubN̓ǂݍ
        expectedWorkbook = getExpectedWorkbook();
        expectedSheet = expectedWorkbook.getSheet( "Sheet2");

        try {
            // `FbN
            ReportsTestUtil.checkSheet( expectedSheet, sheet2);
        } catch ( ReportsCheckException e) {
            fail( e.getCheckMessagesToString());
        }

        // Zb^[ɂ^OZbg
        parser = new SingleParamParser();
        parser.setTag( "$P");

        sheet2 = workbook.getSheetAt( 1);

        // ͏
        try {
            parseSheet( parser, sheet1, reportsParserInfo);
        } catch ( ParseException e) {
            fail(e.toString());
        }
        
        // ҒlubN̓ǂݍ
        expectedWorkbook = getExpectedWorkbook();
        expectedSheet = expectedWorkbook.getSheet( "Sheet2");

        try {
            // `FbN
            ReportsTestUtil.checkSheet( expectedSheet, sheet2);
        } catch ( ReportsCheckException e) {
            fail( e.getCheckMessagesToString());
        }

        // -----------------------
        // [n]K{p[^Ȃꍇ
        // -----------------------
        parser = new SingleParamParser();

        Sheet sheet3 = workbook.getSheetAt( 2);

        // ͏
        try {
            parseSheet( parser, sheet3, reportsParserInfo);
        } catch ( ParseException e) {
            
        }
        // ҒlubN̓ǂݍ
        expectedWorkbook = getExpectedWorkbook();
        expectedSheet = expectedWorkbook.getSheet( "Sheet3");

        try {
            // `FbN
            ReportsTestUtil.checkSheet( expectedSheet, sheet3);
        } catch ( ReportsCheckException e) {
            fail( e.getCheckMessagesToString());
        }


    }

    /**
     * {@link org.bbreak.excella.reports.tag.SingleParamParser#useControlRow()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testUseControlRow() {
        // -----------------------
        // sgpLF
        // -----------------------
        SingleParamParser parser = new SingleParamParser();
        assertFalse( parser.useControlRow());
    }

}
