/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ImageParamParserTest.java 27 2009-06-25 02:04:07Z tomo-shibata $
 * $Revision: 27 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.fail;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.reports.ReportsTestUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.processor.ReportsCheckException;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.processor.ReportsWorkbookTest;
import org.junit.Assert;
import org.junit.Test;

/**
 * {@link org.bbreak.excella.reports.tag.ImageParamParser} ̂߂̃eXgENXB
 * 
 * @since 1.0
 */
public class ImageParamParserTest extends ReportsWorkbookTest {

    /**
     * O
     */
    private static Log log = LogFactory.getLog( ImageParamParser.class);

    /**
     * RXgN^
     * 
     * @param version o[W
     */
    public ImageParamParserTest( String version) {
        super( version);
    }

    /**
     * {@link org.bbreak.excella.reports.tag.ImageParamParser#parse(org.apache.poi.ss.usermodel.Sheet, org.apache.poi.ss.usermodel.Cell, java.lang.Object)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testParseSheetCellObject() {
        // -----------------------
        // [n]ʏ
        // -----------------------
        Workbook workbook = getWorkbook();

        Sheet sheet1 = workbook.getSheetAt( 0);

        ImageParamParser parser = new ImageParamParser();

        ReportsParserInfo reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.setParamInfo( createTestData(ImageParamParser.DEFAULT_TAG));

        try {
            parseSheet( parser, sheet1, reportsParserInfo);
        } catch ( ParseException e) {
            fail( e.toString());
        }
        
        //svV[g̍폜
        Set<Integer> delSheetIndexs = new TreeSet<Integer>(Collections.reverseOrder());
        for(int i = 0; i < workbook.getNumberOfSheets(); i++){
            if(i != 0){
                delSheetIndexs.add( i);
            }
        }
        for(Integer i : delSheetIndexs){
            workbook.removeSheetAt( i);
        }


        // ҒlubN̓ǂݍ
        Workbook expectedWorkbook = getExpectedWorkbook();
        Sheet expectedSheet = expectedWorkbook.getSheet( "Sheet1");

        try {
            // `FbN
            ReportsTestUtil.checkSheet( expectedSheet, sheet1);
        } catch ( ReportsCheckException e) {
            fail( e.getCheckMessagesToString());
            
            
            
        } finally {
            // IuWFNg̓`FbNłȂ̂ŁAo͂ĊmF
            String tmpDirPath = System.getProperty("user.dir") + "/work/test/"; //System.getProperty( "java.io.tmpdir");
            File file = new File(tmpDirPath);
            if(!file.exists()){
                file.mkdirs();
            }

            try {
                String filepath = null;
                if ( version.equals( "2007")) {
                    filepath = tmpDirPath + "ImageParamParserTest1.xlsx";
                } else {
                    filepath = tmpDirPath + "ImageParamParserTest1.xls";
                }
                PoiUtil.writeBook( workbook, filepath);
                log.info( "o̓t@CmFĂF" + filepath);

            } catch ( IOException e) {
                fail( e.toString());
            }
        }

        // -----------------------
        // [n]^OύX
        // -----------------------
        workbook = getWorkbook();

        Sheet sheet2 = workbook.getSheetAt( 1);

        parser = new ImageParamParser( "$Image");

        reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.setParamInfo( createTestData("$Image"));
        

        try {
            parseSheet( parser, sheet2, reportsParserInfo);
        } catch ( ParseException e) {
            fail( e.toString());
        }
        
        
        //svV[g̍폜
        delSheetIndexs.clear();
        for(int i = 0; i < workbook.getNumberOfSheets(); i++){
            if(i != 1){
                delSheetIndexs.add( i);
            }
        }
        for(Integer i : delSheetIndexs){
            workbook.removeSheetAt( i);
        }
        

        // ҒlubN̓ǂݍ
        expectedWorkbook = getExpectedWorkbook();
        expectedSheet = expectedWorkbook.getSheet( "Sheet2");

        try {
            // `FbN
            ReportsTestUtil.checkSheet( expectedSheet, sheet2);
        } catch ( ReportsCheckException e) {
            fail( e.getCheckMessagesToString());
        } finally {
            // IuWFNg̓`FbNłȂ̂ŁAo͂ĊmF
            String tmpDirPath = System.getProperty("user.dir") + "/work/test/"; //System.getProperty( "java.io.tmpdir");;
            File file = new File(tmpDirPath);
            if(!file.exists()){
                file.mkdir();
            }
            try {
                String filepath = null;
                if ( version.equals( "2007")) {
                    filepath = tmpDirPath + "ImageParamParserTest2.xlsx";
                } else {
                    filepath = tmpDirPath + "ImageParamParserTest2.xls";
                }
                PoiUtil.writeBook( workbook, filepath);
                log.info( "o̓t@CmFĂF" + filepath);

            } catch ( IOException e) {
                fail( e.toString());
            }
        }

        String filename = this.getClass().getSimpleName();
        if ( version.equals( "2007")) {
            filename = filename + "_err.xlsx";
        } else if ( version.equals( "2003")) {
            filename = filename + "_err.xls";
        }

        URL url = this.getClass().getResource( filename);
        String path = null;
        try {
            path = URLDecoder.decode( url.getFile(), "UTF-8");
            
        } catch ( UnsupportedEncodingException e) {
            Assert.fail();
        }


        // -----------------------
        // [ُn]`FbN
        // -----------------------
        workbook = getWorkbook(path);

        Sheet sheet3 = workbook.getSheetAt( 2);

        parser = new ImageParamParser();

        reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.setParamInfo( createTestData(ImageParamParser.DEFAULT_TAG));

        try {
            parseSheet( parser, sheet3, reportsParserInfo);
            fail( "`FbNɂĂȂ");
        } catch ( ParseException e) {
        }

        // -----------------------
        // [n]K{p[^Ȃꍇ
        // -----------------------
        workbook = getWorkbook();

        Sheet sheet4 = workbook.getSheetAt( 2);

        parser = new ImageParamParser();

        reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.setParamInfo( createTestData(ImageParamParser.DEFAULT_TAG));

        try {
            parseSheet( parser, sheet4, reportsParserInfo);
        } catch ( ParseException e) {
            fail( e.toString());
        }

        // ҒlubN̓ǂݍ
        expectedWorkbook = getExpectedWorkbook();
        expectedSheet = expectedWorkbook.getSheet( "Sheet4");

        try {
            // `FbN
            ReportsTestUtil.checkSheet( expectedSheet, sheet4);
        } catch ( ReportsCheckException e) {
            fail( e.getCheckMessagesToString());
        }

    }

    private ParamInfo createTestData(String tag) {

        ParamInfo info = new ParamInfo();
        info.addParam( tag, "png", getImagePath("bbreak.png"));
        info.addParam( tag, "jpeg", getImagePath( "bbreak.jpg"));

        return info;

    }

    private String getImagePath( String fileName) {
        String path = null;

        try {
            URL url = this.getClass().getResource( fileName);
            path = URLDecoder.decode( url.getFile(), "UTF-8");


        } catch ( Exception e) {
            fail( e.toString());
        }

        return path;

    }

    /**
     * {@link org.bbreak.excella.reports.tag.ImageParamParser#useControlRow()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testUseControlRow() {
        // -----------------------
        // sgpLF
        // -----------------------
        ImageParamParser parser = new ImageParamParser();
        assertFalse( parser.useControlRow());
    }

}
