/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: SingleParamParser.java 5 2009-06-22 07:55:44Z tomo-shibata $
 * $Revision: 5 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.tag;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;

/**
 * V[g̒uϊp[T
 * 
 * @since 1.0
 */
public class SingleParamParser extends ReportsTagParser<Object> {

    /**
     * O
     */
    private static Log log = LogFactory.getLog( SingleParamParser.class);

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "$";

    /**
     * uϐ̃p[^
     */
    public static final String PARAM_VALUE = "";

    /**
     * RXgN^
     */
    public SingleParamParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public SingleParamParser( String tag) {
        super( tag);
    }

    @Override
    public ParsedReportInfo parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        Map<String, String> paramDef = TagUtil.getParams( tagCell.getStringCellValue());

        // p[^`FbN
        checkParam( paramDef, tagCell);

        ReportsParserInfo reportsParserInfo = ( ReportsParserInfo) data;

        ParamInfo paramInfo = reportsParserInfo.getParamInfo();

        Object paramValue = null;

        if ( paramInfo != null) {
            // uϐ̎擾
            String replaceParam = paramDef.get( PARAM_VALUE);

            // ul擾
            paramValue = getParamData( paramInfo, replaceParam);

            if ( log.isDebugEnabled()) {
                Workbook workbook = sheet.getWorkbook();
                String sheetName = workbook.getSheetName( workbook.getSheetIndex( sheet));

                log.debug( "[V[g=" + sheetName + ",Z=(" + tagCell.getRowIndex() + "," + tagCell.getColumnIndex() + ")]  " + tagCell.getStringCellValue() + "  " + paramValue);
            }

            // u
            PoiUtil.setCellValue( tagCell, paramValue);
        }

        // ͌ʂ̐
        ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
        parsedReportInfo.setParsedObject( paramValue);
        parsedReportInfo.setDefaultRowIndex( tagCell.getRowIndex());
        parsedReportInfo.setDefaultColumnIndex( tagCell.getColumnIndex());
        parsedReportInfo.setRowIndex( tagCell.getRowIndex());
        parsedReportInfo.setColumnIndex( tagCell.getColumnIndex());

        return parsedReportInfo;
    }

    /**
     * sȃp[^ꍇAParseExceptionthrowB
     * 
     * @param paramDef p[^`
     * @param tagCell ^OZ
     * @throws ParseException sȃp[^ꍇ
     */
    private void checkParam( Map<String, String> paramDef, Cell tagCell) throws ParseException {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.bbreak.excella.reports.tag.ReportsTagParser#useControlRow()
     */
    @Override
    public boolean useControlRow() {
        return false;
    }

}
