/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ReportsParserInfo.java 5 2009-06-22 07:55:44Z tomo-shibata $
 * $Revision: 5 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.processor;

import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.tag.ReportsTagParser;

/**
 * [͏ێNX
 * 
 * @since 1.0
 */
public class ReportsParserInfo {
    
    /**
     * [NubN̒u
     */
    private ReportBook reportBook = null;

    /**
     * p[^
     */
    private ParamInfo paramInfo = null;

    /**
     * gpp[T[
     */
    private List<ReportsTagParser<?>> reportParsers = null;

    /**
     * p[^擾܂B
     * @return p[^
     */
    public ParamInfo getParamInfo() {
        return paramInfo;
    }

    /**
     * p[^ݒ肵܂B
     * @param paramInfo p[^
     */
    public void setParamInfo( ParamInfo paramInfo) {
        this.paramInfo = paramInfo;
    }

    /**
     * gpp[T[擾܂B
     * @return gpp[T[
     */
    public List<ReportsTagParser<?>> getReportParsers() {
        return reportParsers;
    }

    /**
     * gpp[T[ݒ肵܂B
     * @param reportParsers gpp[T[
     */
    public void setReportParsers( List<ReportsTagParser<?>> reportParsers) {
        this.reportParsers = reportParsers;
    }

    /**
     * VXeƒ[p[T[́A[͏쐬B
     * 
     * @param paramInfo up[^
     * @return [͏
     */
    public ReportsParserInfo createChildParserInfo( ParamInfo paramInfo) {
        ReportsParserInfo reportsParserInfo = new ReportsParserInfo();
        reportsParserInfo.reportParsers = reportParsers;
        reportsParserInfo.reportBook = reportBook;
        reportsParserInfo.paramInfo = paramInfo;

        return reportsParserInfo;

    }

    /**
     * ͏sp[T[擾B
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ΏۃZ
     * @return ͏sp[T[
     * @throws ParseException
     */
    public TagParser<?> getMatchTagParser( Sheet sheet, Cell tagCell) throws ParseException {
        if ( reportParsers != null) {
            for ( TagParser<?> tagParser : reportParsers) {
                if ( tagParser.isParse( sheet, tagCell)) {
                    
//                    TagParser<?> newParser;
//                    try {
//                        Constructor<? extends TagParser> cunstructor = tagParser.getClass().getConstructor( new Class[] {String.class});
//                        newParser = ( TagParser<?>) cunstructor.newInstance( tagParser.getTag());
//                    } catch ( Exception e) {
//                        throw new ParseException( tagCell, e);
//                    }
//
//                    return newParser;
                    return tagParser;
                }
            }
        }
        return null;
    }

    /**
     * [NubN̒u擾܂B
     * @return [NubN̒u
     */
    public ReportBook getReportBook() {
        return reportBook;
    }

    /**
     * [NubN̒uݒ肵܂B
     * @param reportBook [NubN̒u
     */
    public void setReportBook( ReportBook reportBook) {
        this.reportBook = reportBook;
    }

}
