/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;

public final class PercentEval
implements OperationEval {
    public static final OperationEval instance = new PercentEval();

    private PercentEval() {
    }

    public Eval evaluate(Eval[] args, int srcRow, short srcCol) {
        double d0;
        if (args.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue(args[0], srcRow, srcCol);
            d0 = OperandResolver.coerceValueToDouble(ve);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(d0 / 100.0);
    }

    public int getNumberOfOperands() {
        return 1;
    }
}

