package com.yuji.ef.dao;

import java.util.List;

import android.database.sqlite.SQLiteDatabase;

public interface NodeDao {

	public static final String DELM = "\t";

	public abstract void onCreate(SQLiteDatabase db);

	public abstract void init(SQLiteDatabase db);

	public abstract void start(SQLiteDatabase db);

	public abstract List<Node> search();

	public abstract Node searchRoot();

	public abstract Node searchRoot(SQLiteDatabase db);

	public abstract List<Node> searchBook();

	public abstract List<Node> searchBook(SQLiteDatabase db);

	public abstract List<Node> searchSelectedBook();

	public abstract List<Node> searchSelectedBook(SQLiteDatabase db);

	public abstract List<Node> searchNote();

	public abstract List<Node> searchNote(SQLiteDatabase db);

	public abstract List<Node> searchNoteByFlag(int flag);

	public abstract List<Node> searchNoteByFlag(SQLiteDatabase db, int flag);

	public abstract Node searchById(long id);

	public abstract Node searchById(SQLiteDatabase db, long id);

	public abstract Node searchByGuid(SQLiteDatabase db, String guid);

	public abstract boolean isEmpty();

	public abstract long add(Node node);

	public abstract long addNT(Node node);

	public abstract long addChildrenId(Node node, long id);

	public abstract long addChildrenIdNT(Node node, long id);

	public abstract long updateChildrenNT(Node node, String children);

	public abstract long removeChildrenId(Node node, long id);

	public abstract long removeChildrenIdNT(Node node, long id);

	public abstract long updateStatus(Node node, Node.Status status);

	public abstract long updateStatus(SQLiteDatabase db, Node node,
			Node.Status status);

	public abstract long updateStatusNT(Node node, Node.Status status);

	public abstract long updateName(Node node, String name);

	public abstract long updateName(SQLiteDatabase db, Node node, String name);

	public abstract long updateNameNT(Node node, String name);

	public abstract long updateGuid(Node node, String guid);

	public abstract long updateGuid(SQLiteDatabase db, Node node, String guid);

	public abstract long updateGuidNT(Node node, String guid);

	public abstract long updateSelected(Node node, boolean isSelected);

	public abstract long updateSelected(SQLiteDatabase db, Node node, boolean isSelected);

	public abstract long updateSelectedNT(Node node, boolean isSelected);

	public abstract long updateParent(Node node, long parent);

	public abstract long updateParent(SQLiteDatabase db, Node node, long parent);

	public abstract long updateParentNT(Node node, long parent);

	public abstract long updateChildren(Node node, String children);
	
	public abstract long updateNoteFlag(int flag);

	public abstract long updateNoteFlag(SQLiteDatabase db, int flag);

	public abstract long updateNoteFlagNT(int flag);
	
	public abstract long updateFlag(Node node, int flag);

	public abstract long updateFlag(SQLiteDatabase db, Node node, int flag);

	public abstract long updateFlagNT(Node node, int flag);
	
	public abstract long delete(long id);

	public abstract long delete(SQLiteDatabase db, long did);

	public abstract long deleteNT(long did);

	public abstract long delete();

	public abstract long delete(SQLiteDatabase db);

	public abstract void deleteNT();

}