package com.yuji.ef.dao;

import java.util.ArrayList;
import java.util.List;

import com.yuji.ef.LabelIconView;
import com.yuji.ef.R;
import com.yuji.ef.common.CommonUtil;

public class DirNode extends Node {
	public enum Category {
		NOTEBOOK, NOTEBOOK_TAG, NONE
	};

	private Status status = Status.CLOSE;
	private Category category = Category.NONE;

	// private String notebookGuid = null;

	public DirNode(String name, LabelIconView view) {
		super(name, view);

		children = new ArrayList<Long>();
	}

	public DirNode(String name, LabelIconView view, String childrenStr,
			int stCode) {
		super(name, view);

		children = new ArrayList<Long>();

		List<String> l = CommonUtil.split(childrenStr, NodeDao.DELM);
		for (String s : l) {
			children.add(Long.parseLong(s));
		}
		status = Node.getStatus(stCode);
	}

	public Category getCategory() {
		return category;
	}

	public void setCategory(Category category) {
		this.category = category;
	}

	// public String getNotebookGuid() {
	// return notebookGuid;
	// }
	//
	// public void setNotebookGuid(String notebookGuid) {
	// this.notebookGuid = notebookGuid;
	// }

	@Override
	public int getType() {
		return CommonUtil.isNull(getGuid()) ? TYPE_DIR : TYPE_BOOK;
	}

	@Override
	public int getIconId() {
		return CommonUtil.isNull(this.getGuid()) ? R.drawable.dirnode
				: R.drawable.notebook;
	}

	@Override
	public Status getStatus() {
		return status;
	}

	@Override
	public void setStatus(Status status) {
		this.status = status;
	}

	@Override
	public void toggleStatus() {
		if (status == Status.NONE) {
			return;
		}
		status = (status == Status.CLOSE) ? Status.OPEN : Status.CLOSE;
	}

	@Override
	public int getStatusIconId() {
		if (status == Status.CLOSE) {
			return R.drawable.close;
		} else {
			return R.drawable.open;
		}
	}
}
