package com.yuji.ef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.yuji.ef.common.CommonUtil;
import com.yuji.ef.common.Constant;
import com.yuji.ef.dao.DatabaseHelper;
import com.yuji.ef.dao.DirNode;
import com.yuji.ef.dao.FileNode;
import com.yuji.ef.dao.LockDao;
import com.yuji.ef.dao.Node;
import com.yuji.ef.dao.Node.Status;
import com.yuji.ef.dao.NodeCacheDao;
import com.yuji.ef.dao.NodeComparator;
import com.yuji.ef.dao.NodeDao;
import com.yuji.ef.dao.NodeDaoImpl;
import com.yuji.ef.dao.RootNode;
import com.yuji.ef.utility.BaseActivity;
import com.yuji.ef.utility.BitmapCacheFactory;
import com.yuji.ef.utility.EvernoteIntentUtil;
import com.yuji.ef.utility.FolderUtil;
import com.yuji.ef.utility.ScaleUtil;

public class EverFolderActivity extends BaseActivity {
	private enum ScreenStatus {
		Normal, AddNode, DeleteNode, RenameNode
	};

	private LinearLayout msgLayout;
	private LinearLayout msgButtonLayout;
	private Button msgOkButton;
	private Button msgCancelButton;
	private EditText msgEditText;

	private IconFrameLayout layout;
	private TextView confirmMsg;
	private IconScrollView scrollView;
	private LinearLayout buttonLayout;
	private Button leftButton;
	private Button rightButton;
	// private Button addButton;
	// private Button deleteButton;

	private ScreenStatus status;
	private NodeComparator nodeComparator = new NodeComparator();
	private BitmapCacheFactory bitmapFactory = BitmapCacheFactory.getInstance();
	private Node top = null;
	private int indent = 0;
	private int bmpPaddingLeft;
	private int bmpWidth;
	private int viewY;
	private boolean lock = false;
	private boolean isInit = true;

	private BroadcastReceiver receiver = new BroadcastReceiver() {
		@Override
		public void onReceive(Context context, Intent intent) {
			String action = intent.getAction();

			if (action.compareTo(Constant.ACTION_UPDATE) == 0) {
				LockDao lockDao = (LockDao) LockDao.getInstance();
				lock = lockDao.lock(EverFolderActivity.this,
						Constant.LOCK_UPDATE_NOTE);
				if (lock) {
					updateList();
				}
				setStatus();
			}
		}
	};

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		try {
			IntentFilter intentFilter = new IntentFilter();
			intentFilter.addAction(Constant.ACTION_UPDATE);
			registerReceiver(receiver, intentFilter);

			scrollView = (IconScrollView) findViewById(R.id.scrollView);
			layout = (IconFrameLayout) findViewById(R.id.frameLayout);
			layout.setActivity(this);
			layout.setScrollView(scrollView);

			buttonLayout = (LinearLayout) findViewById(R.id.mainButtonLayout);
			leftButton = (Button) findViewById(R.id.leftButton);
			rightButton = (Button) findViewById(R.id.rightButton);
			// addButton = (Button) findViewById(R.id.addButton);
			// deleteButton = (Button) findViewById(R.id.deleteButton);

			msgLayout = (LinearLayout) findViewById(R.id.mainMsgLayout);
			confirmMsg = (TextView) findViewById(R.id.mainConfirmMsg);
			msgEditText = (EditText) findViewById(R.id.mainMsgEditText);
			msgButtonLayout = (LinearLayout) findViewById(R.id.mainMsgButtonLayout);
			msgOkButton = (Button) findViewById(R.id.mainMsgOkButton);
			msgCancelButton = (Button) findViewById(R.id.mainMsgCancelButton);

			leftButton.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					leftButtonOnClick();
				}
			});
			rightButton.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					rightButtonOnClick();
				}
			});
			// addButton.setOnClickListener(new OnClickListener() {
			// @Override
			// public void onClick(View v) {
			// addButtonOnClick();
			// }
			// });
			// deleteButton.setOnClickListener(new OnClickListener() {
			// @Override
			// public void onClick(View v) {
			// deleteButtonOnClick();
			// }
			// });

			msgEditText.addTextChangedListener(new TextWatcher() {
				public void afterTextChanged(Editable s) {
					if (status != ScreenStatus.DeleteNode) {
						String text = s.toString();
						msgOkButton.setEnabled(text.length() > 0);
					} else {
						msgOkButton.setEnabled(true);
					}
				}

				public void beforeTextChanged(CharSequence s, int start,
						int count, int after) {

				}

				public void onTextChanged(CharSequence s, int start,
						int before, int count) {

				}
			});

			msgOkButton.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					msgOkButtonOnClick();
				}
			});
			msgCancelButton.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					msgCancelOnClick();
				}
			});

			ScaleUtil scaleUtil = ScaleUtil.getInstance();
			scaleUtil.init(this);

			bitmapFactory.init(this);
			Node node = new DirNode(null, null);
			Bitmap bmp = null;
			bmp = bitmapFactory.get(node.getStatusIconId());
			bmpPaddingLeft = bmp.getWidth();
			bmp = bitmapFactory.get(node.getIconId());
			bmpWidth = bmp.getWidth();

			float fSize = 48 * (1 / 2.0f);
			leftButton.setTextSize(fSize);
			rightButton.setTextSize(fSize);
		} catch (Exception e) {
			// TODO
			e.printStackTrace();
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		boolean ret = super.onCreateOptionsMenu(menu);
		int index = 0;

		menu.add(Menu.NONE, Menu.FIRST + index++, Menu.NONE, "カット");
		menu.add(Menu.NONE, Menu.FIRST + index++, Menu.NONE, "ペースト");
		menu.add(Menu.NONE, Menu.FIRST + index++, Menu.NONE, "追加");
		menu.add(Menu.NONE, Menu.FIRST + index++, Menu.NONE, "削除");
		menu.add(Menu.NONE, Menu.FIRST + index++, Menu.NONE, "リネーム");
		menu.add(Menu.NONE, Menu.FIRST + index++, Menu.NONE, "設定");
		return ret;
	}

	@Override
	public boolean onMenuOpened(int featureId, Menu menu) {
		boolean ret = super.onMenuOpened(featureId, menu);

		MenuItem item;

		boolean cutButtonFlag = false;
		boolean pastButtonFlag = false;
		boolean addButtonFlag = false;
		boolean deleteButtonFlag = false;
		boolean renameButtonFlag = false;
		boolean confButtonFlag = true;

		if (status == ScreenStatus.Normal) {
			LabelIconView target = layout.getSelectedTarget();
			NodeDao dao = (NodeDao) NodeCacheDao.getInstance();
			long id = -1;
			Node node = null;
			if (target != null) {
				id = target.getNodeId();
				node = dao.searchById(id);
			}

			if (isDirNode(target, node, false) || isFileNode(node)) {
				cutButtonFlag = true;
			}
			if (isDirNode(target, node, true) && isCut()) {
				pastButtonFlag = true;
			}
			if (isDirNode(target, node, true)) {
				addButtonFlag = true;
			}
			if (isDirNode(target, node, false) && !isNoteBook(node)
					&& CommonUtil.isNull(node.getChildrenString())) {
				deleteButtonFlag = true;
			}
			if (isDirNode(target, node, false) && !isNoteBook(node)) {
				renameButtonFlag = true;
			}
		}

		int index = 0;
		item = menu.getItem(index++);
		item.setVisible(cutButtonFlag);
		item = menu.getItem(index++);
		item.setVisible(pastButtonFlag);
		item = menu.getItem(index++);
		item.setVisible(addButtonFlag);
		item = menu.getItem(index++);
		item.setVisible(deleteButtonFlag);
		item = menu.getItem(index++);
		item.setVisible(renameButtonFlag);
		item = menu.getItem(index++);
		item.setVisible(confButtonFlag);

		return ret;
	}

	private boolean isFileNode(Node node) {
		if (node == null || !(node instanceof FileNode)) {
			return false;
		}
		return true;
	}

	private boolean isDirNode(LabelIconView target, Node node,
			boolean containRoot) {
		if (target == null) {
			return false;
		}
		if (node == null) {
			return false;
		}
		if (!containRoot && (node instanceof RootNode)) {
			return false;
		}
		if (!(node instanceof DirNode)) {
			return false;
		}
		return true;
	}

	private boolean isNoteBook(Node node) {
		if (node == null) {
			return false;
		}
		if (CommonUtil.isNull(node.getGuid())) {
			return false;
		}
		return true;
	}

	private boolean isCut() {
		LabelIconView srcTarget = layout.getCutTarget();
		if (srcTarget == null) {
			return false;
		}
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		Intent intent;
		try {
			switch (item.getItemId()) {
			case Menu.FIRST + 0:
				selectMenuCut();
				break;
			case Menu.FIRST + 1:
				selectMenuPast();
				break;
			case Menu.FIRST + 2:
				selectMenuAdd();
				break;
			case Menu.FIRST + 3:
				selectMenuDelete();
				break;
			case Menu.FIRST + 4:
				selectMenuRename();
				break;
			case Menu.FIRST + 5:
				// dummy();
				// dummy2();
				intent = new Intent(this, (Class<?>) SettingActivity.class);
				startActivityForResult(intent, 0);
				break;
			default:
				break;
			}
		} catch (Exception e) {
			terminate(e);
		}
		return super.onOptionsItemSelected(item);
	}

	private void dummy() {
		NodeDaoImpl dao = (NodeDaoImpl) NodeCacheDao.getInstance();
		List<Node> list = dao.search();
		for (Node node : list) {
			System.out.println(node.toString());
		}
	}

	private void dummy2() {
		LockDao dao = (LockDao) LockDao.getInstance();
		boolean b;

		try {
			b = dao.lock(this, "key");
			b = dao.lock(this, "key");
			dao.unlock(new Object(), "key");
			b = dao.lock(this, "key");
			dao.unlock(this, "key");
			b = dao.lock(this, "key");
			b = dao.lock(this, "key");
			b = dao.lock(this, "key");

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	private void selectMenuAdd() {
		setStatus(ScreenStatus.AddNode);
	}

	private void selectMenuDelete() {
		setStatus(ScreenStatus.DeleteNode);
	}

	private void selectMenuRename() {
		LabelIconView target = layout.getSelectedTarget();
		if (target == null) {
			return;
		}

		long id = target.getNodeId();
		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();
		Node node = dao.searchById(id);
		if (node != null) {
			String text = node.getName();
			msgEditText.setText(text);
			setStatus(ScreenStatus.RenameNode);
		}
	}

	private void selectMenuCut() {
		LabelIconView target = layout.getSelectedTarget();
		if (target == null) {
			return;
		}

		layout.setCutTarget(target);
		layout.refresh();
	}

	private void selectMenuPast() {
		LabelIconView srcTarget = layout.getCutTarget();
		if (srcTarget == null) {
			return;
		}

		LabelIconView dstTarget = layout.getSelectedTarget();
		if (dstTarget == null) {
			return;
		}

		layout.setCutTarget(null);

		long srcId = srcTarget.getNodeId();
		long dstId = dstTarget.getNodeId();
		execute(srcId, dstId);
	}

	private void updateList() {
		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();
		top = dao.searchRoot();
		if (top == null) {
			// TODO
		}
		layout.removeAllViews();
		updateList(top);
		layout.refresh();
	}

	private void updateList(Node parent) {
		viewY = 10;

		// List<Node> list = parent.getChildren();
		// for (Node node : list){
		// updateList(node, x);
		// }
		updateList(parent, 0);
		layout.setMinimumHeight(viewY);
		
		scrollView.invalidate();
		
//		layout.invalidate();

//		this.runOnUiThread(new Runnable() {
//			@Override
//			public void run() {
//				// ビューを再描画し，UI上で画像変更を反映
//				scrollView.invalidate();
//			}
//		});
	}
	
	private void updateList(Node node, int depth) {
		int N = (int) (bmpWidth * 0.6);
		int M = (int) (bmpWidth * 1.2);
		int x = N * (depth - indent);

		if (depth - indent >= 0
				&& !(depth - indent == 0 && node instanceof FileNode)) {
			LabelIconView view = new LabelIconView(this);
			node.setView(view);

			Bitmap bmp1 = null;
			int id = node.getStatusIconId();
			if (id >= 0) {
				// DirNode
				bmp1 = bitmapFactory.get(node.getStatusIconId());
			} else {
				// FileNode
				x += bmpPaddingLeft;
			}
			Bitmap bmp2 = bitmapFactory.get(node.getIconId());
			createIconImageView(view, bmp1, bmp2, node.getName(), x, viewY);
			// LabelIconView s = view.getStatusImageView();
			// if (s != null) {
			// s.setNodeId(node.getId());
			// }
			view.setNodeId(node.getId());
		}
		viewY += M;

		if (node.getStatus() != Node.Status.OPEN) {
			return;
		}
		List<Long> idList = node.getChildren();
		if (idList == null) {
			return;
		}

		List<Node> list = new ArrayList<Node>();
		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();
		for (Long id : idList) {
			Node n = dao.searchById(id);
			if (n == null){
				// TODO
				continue;
			}
			if (n instanceof DirNode){
				DirNode d = (DirNode)n;
				if (!d.isSelected()){
					continue;
				}
			}
			list.add(n);
		}
		Collections.sort(list, nodeComparator);
		for (Node n : list) {
			updateList(n, depth + 1);
		}
	}

	private void createIconImageView(LabelIconView v, Bitmap bmp1, Bitmap bmp2,
			String text, int x, int y) {
		v.init(x, y, bmp1, bmp2, text);

		android.view.WindowManager.LayoutParams params = new WindowManager.LayoutParams();
		params.gravity = Gravity.TOP | Gravity.LEFT;
		params.height = WindowManager.LayoutParams.WRAP_CONTENT;
		params.width = WindowManager.LayoutParams.WRAP_CONTENT;
		params.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
				| WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE
				| WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON
				| WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS;
		params.format = PixelFormat.TRANSLUCENT;
		params.windowAnimations = 0;
		params.x = x;
		params.y = y;
		v.setLayoutParams(params);

		// LabelIconView siv = v.getStatusImageView();
		// if (siv != null) {
		// layout.addView(siv, false);
		// }

		layout.addView(v);
		v.layout(x, y, x + v.getWidth(), y + v.getHeight());
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		// updateList();
		// setStatus();
		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();
		if (dao.isEmpty()) {
			finish();
		}
		isInit = true;
	}

	@Override
	protected void onStart() {
		super.onStart();
	}

	@Override
	protected void onResume() {
		super.onResume();

		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();
		if (dao.isEmpty()) {
			if (isInit) {
				Intent intent = new Intent(this,
						(Class<?>) SettingActivity.class);
				startActivityForResult(intent, 0);

				isInit = false;
			} else {
				finish();
				isInit = true;
			}
		}

		LockDao lockDao = (LockDao) LockDao.getInstance();
		lock = lockDao.lock(this, Constant.LOCK_UPDATE_NOTE);

		if (isInit) {
			status = ScreenStatus.Normal;

			if (lock) {
				updateList();
			} else {
				layout.removeAllViews();
			}
			setStatus();
			isInit = false;
		} else {
			setStatus();
		}
	}

	@Override
	protected void onPause() {
		// ロック未取得でも解除する(ゴミ掃除)
		LockDao lockDao = (LockDao) LockDao.getInstance();
		lockDao.unlock(this, Constant.LOCK_UPDATE_NOTE);
		lock = false;

		super.onPause();
	}

	private void leftButtonOnClick() {
		moveButtonOnClick(-1);
		setStatus();
	}

	private void rightButtonOnClick() {
		moveButtonOnClick(1);
		setStatus();
	}

	private void moveButtonOnClick(int dx) {
		int mx = 0;

		if (dx < 0) {
			if (indent > 0) {
				mx = -1;
			}
		} else {
			mx = 1;
		}
		if (mx != 0) {
			indent += mx;
			removeAllNodeView();
			updateList();
		}
	}

	// private void addButtonOnClick() {
	// setStatus(ScreenStatus.AddNode);
	// }
	//
	// private void deleteButtonOnClick() {
	// FolderUtil util = FolderUtil.getInstance();
	// LabelIconView target = layout.getSelectedTarget();
	// long id = target.getNodeId();
	// NodeDao dao = (NodeDao) NodeDao.getInstance();
	// Node node = dao.searchById(id);
	// if (node != null) {
	// util.deleteNode(node);
	// // TODO 三角マークも消さないといけないのでは
	// layout.removeView(target);
	// updateList();
	// setStatus();
	// }
	// }

	private void msgOkButtonOnClick() {
		FolderUtil util = FolderUtil.getInstance();
		LabelIconView target = layout.getSelectedTarget();
		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();

		if (status == ScreenStatus.AddNode) {
			long id = target.getNodeId();
			Node parent = dao.searchById(id);
			if (parent != null) {
				String text = msgEditText.getText().toString();
				DirNode node = new DirNode(text, null);
				util.addDirNode(parent, node);
			}
			layout.setCutTarget(null, false);
		} else if (status == ScreenStatus.DeleteNode) {
			long id = target.getNodeId();
			Node node = dao.searchById(id);
			if (node != null) {
				util.deleteNode(node);
				layout.removeView(target);
			}
			layout.setCutTarget(null, false);
		} else if (status == ScreenStatus.RenameNode) {
			long id = target.getNodeId();
			Node node = dao.searchById(id);
			if (node != null) {
				String text = msgEditText.getText().toString();

				dao.updateName(node, text);
			}
			layout.setCutTarget(null, false);
		}
		layout.clearTarget();
		updateList();
		setStatus(ScreenStatus.Normal);
	}

	private void msgCancelOnClick() {
		setStatus(ScreenStatus.Normal);
	}

	public void execute(long srcId, long dstId) {
		try {
			removeAllNodeView();

			NodeDao dao = (NodeDao) NodeCacheDao.getInstance();

			if (srcId < 0) {
				// TODO
			}
			if (dstId < 0) {
				// TODO
			}

			Node src = dao.searchById(srcId);
			Node dst = null;
			if (srcId == dstId) {
				dst = src;
			} else {
				dst = dao.searchById(dstId);
			}

			if (dstId == src.getParent()) {
				// 同じ場所に移動
				return;
			}
			if (!isFileNode(src) && !isMovable(srcId, dstId)) {
				// 再帰的な移動
				return;
			}

			Node sp = dao.searchById(src.getParent());
			if (sp == null) {
				// TODO
			}
			Node dp = null;
			if (src.getParent() == dst.getParent()) {
				dp = sp;
			} else {
				dp = dao.searchById(dst.getParent());
			}
			if (dp == null) {
				// TODO
			}

			// TODO DBへのアクセス
			// sp.remove(src.getId());
			SQLiteDatabase db = DatabaseHelper.getInstance()
					.getSQLiteDatabase();
			db.beginTransaction();
			try {
				dao.removeChildrenIdNT(sp, src.getId());
				if (dst instanceof DirNode) {
					// dst.add(src.getId());
					dao.updateParentNT(src, dst.getId());
					dao.addChildrenIdNT(dst, src.getId());
				} else if (dst instanceof FileNode) {
					// dp.add(src.getId());
					dao.updateParentNT(src, dp.getId());
					dao.addChildrenIdNT(dp, src.getId());
				}

				db.setTransactionSuccessful();
			} finally {
				db.endTransaction();
			}
		} finally {
			updateList();
		}
	}

	private boolean isMovable(long srcId, long dstId) {
		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();

		while (dstId >= 0) {
			if (srcId == dstId) {
				return false;
			}
			Node node = dao.searchById(dstId);
			if (node == null) {
				// TODO エラー
				return false;
			}
			if (!(node instanceof DirNode)) {
				return true;
			}
			dstId = node.getParent();
		}
		return true;
	}

	public void execute(long id) {
		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();

		Node node = dao.searchById(id);
		if (node == null) {
			// TODO
		}
		node.toggleStatus();
		Status status = node.getStatus();

		dao.updateStatus(node, status);

		// removeAllNodeView();
		updateList();
	}

	public void executeView(long id) {
		NodeDao dao = (NodeDao) NodeCacheDao.getInstance();

		Node node = dao.searchById(id);
		if (!isFileNode(node)) {
			return;
		}
		String guid = node.getGuid();

		EvernoteIntentUtil util = EvernoteIntentUtil.getInstance();
		util.viewNote(this, guid);
	}

	public void targetSelectedChanged(boolean status) {
		setStatus();
	}

	public void removeAllNodeView() {
		layout.removeAllViews();
	}

	private void setStatus() {
		setStatus(status);
	}

	private void setStatus(ScreenStatus status) {
		try {
			if (this.status != status) {
				this.status = status;
			}

			if (!lock) {
				msgLayout.setVisibility(View.VISIBLE);
				confirmMsg.setText(getString(R.string.mainUpdateMsg));
				msgEditText.setVisibility(View.GONE);
				msgButtonLayout.setVisibility(View.GONE);
				status = ScreenStatus.Normal;
				return;
			}

			if (status == ScreenStatus.Normal) {
				msgLayout.setVisibility(View.GONE);
				// mainMsgEditText.setText("");

				boolean leftButtonFlag = true;
				boolean rightButtonFlag = true;
				// boolean addButtonFlag = true;
				// boolean deleteButtonFlag = true;

				if (indent <= 0) {
					leftButtonFlag = false;
				}

				// LabelIconView target = layout.getSelectedTarget();
				// NodeDao dao = (NodeDao) NodeDao.getInstance();
				// long id = -1;
				// Node node = null;
				// if (target != null) {
				// id = target.getNodeId();
				// node = dao.searchById(id);
				// }
				// if (target == null || node == null || !(node instanceof
				// DirNode))
				// {
				// addButtonFlag = false;
				// }
				// if (target == null || (node != null && node instanceof
				// RootNode))
				// {
				// deleteButtonFlag = false;
				// }
				layout.setElabledTouchEvent(true);

				leftButton.setEnabled(leftButtonFlag);
				rightButton.setEnabled(rightButtonFlag);
				// addButton.setEnabled(addButtonFlag);
				// deleteButton.setEnabled(deleteButtonFlag);
			} else if (status == ScreenStatus.AddNode) {
				msgLayout.setVisibility(View.VISIBLE);
				msgEditText.setVisibility(View.VISIBLE);
				msgButtonLayout.setVisibility(View.VISIBLE);
				confirmMsg.setText(getString(R.string.mainAddMsg));
				msgEditText.setText("");

				layout.setElabledTouchEvent(false);

				leftButton.setEnabled(false);
				rightButton.setEnabled(false);
			} else if (status == ScreenStatus.DeleteNode) {
				msgLayout.setVisibility(View.VISIBLE);
				msgEditText.setVisibility(View.GONE);
				msgButtonLayout.setVisibility(View.VISIBLE);
				confirmMsg.setText(getString(R.string.mainDeleteMsg));

				layout.setElabledTouchEvent(false);

				leftButton.setEnabled(false);
				rightButton.setEnabled(false);
			} else if (status == ScreenStatus.RenameNode) {
				msgLayout.setVisibility(View.VISIBLE);
				msgEditText.setVisibility(View.VISIBLE);
				msgButtonLayout.setVisibility(View.VISIBLE);
				confirmMsg.setText(getString(R.string.mainRenameMsg));

				layout.setElabledTouchEvent(false);

				leftButton.setEnabled(false);
				rightButton.setEnabled(false);
			}
		} catch (Throwable e) {
			// TODO
			e.printStackTrace();
		}
	}
}