/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.edam.notestore;

import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.AdParameters;
import com.evernote.edam.notestore.ClientUsageMetrics;
import com.evernote.edam.notestore.NoteCollectionCounts;
import com.evernote.edam.notestore.NoteEmailParameters;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.notestore.NoteVersionId;
import com.evernote.edam.notestore.NotesMetadataList;
import com.evernote.edam.notestore.NotesMetadataResultSpec;
import com.evernote.edam.notestore.SyncChunk;
import com.evernote.edam.notestore.SyncChunkFilter;
import com.evernote.edam.notestore.SyncState;
import com.evernote.edam.type.Ad;
import com.evernote.edam.type.LazyMap;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.type.Tag;
import com.evernote.edam.userstore.AuthenticationResult;
import java.util.List;
import org.apache.thrift.TException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface NoteStoreIface {
    public SyncState getSyncState(String var1) throws EDAMUserException, EDAMSystemException, TException;

    public SyncState getSyncStateWithMetrics(String var1, ClientUsageMetrics var2) throws EDAMUserException, EDAMSystemException, TException;

    public SyncChunk getSyncChunk(String var1, int var2, int var3, boolean var4) throws EDAMUserException, EDAMSystemException, TException;

    public SyncChunk getFilteredSyncChunk(String var1, int var2, int var3, SyncChunkFilter var4) throws EDAMUserException, EDAMSystemException, TException;

    public SyncState getLinkedNotebookSyncState(String var1, LinkedNotebook var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public SyncChunk getLinkedNotebookSyncChunk(String var1, LinkedNotebook var2, int var3, int var4, boolean var5) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public List<Notebook> listNotebooks(String var1) throws EDAMUserException, EDAMSystemException, TException;

    public Notebook getNotebook(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Notebook getDefaultNotebook(String var1) throws EDAMUserException, EDAMSystemException, TException;

    public Notebook createNotebook(String var1, Notebook var2) throws EDAMUserException, EDAMSystemException, TException;

    public int updateNotebook(String var1, Notebook var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int expungeNotebook(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public List<Tag> listTags(String var1) throws EDAMUserException, EDAMSystemException, TException;

    public List<Tag> listTagsByNotebook(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Tag getTag(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Tag createTag(String var1, Tag var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int updateTag(String var1, Tag var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public void untagAll(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int expungeTag(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public List<SavedSearch> listSearches(String var1) throws EDAMUserException, EDAMSystemException, TException;

    public SavedSearch getSearch(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public SavedSearch createSearch(String var1, SavedSearch var2) throws EDAMUserException, EDAMSystemException, TException;

    public int updateSearch(String var1, SavedSearch var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int expungeSearch(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public NoteList findNotes(String var1, NoteFilter var2, int var3, int var4) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int findNoteOffset(String var1, NoteFilter var2, String var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public NotesMetadataList findNotesMetadata(String var1, NoteFilter var2, int var3, int var4, NotesMetadataResultSpec var5) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public NoteCollectionCounts findNoteCounts(String var1, NoteFilter var2, boolean var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Note getNote(String var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public LazyMap getNoteApplicationData(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public String getNoteApplicationDataEntry(String var1, String var2, String var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int setNoteApplicationDataEntry(String var1, String var2, String var3, String var4) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int unsetNoteApplicationDataEntry(String var1, String var2, String var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public String getNoteContent(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public String getNoteSearchText(String var1, String var2, boolean var3, boolean var4) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public String getResourceSearchText(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public List<String> getNoteTagNames(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Note createNote(String var1, Note var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Note updateNote(String var1, Note var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int deleteNote(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int expungeNote(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int expungeNotes(String var1, List<String> var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int expungeInactiveNotes(String var1) throws EDAMUserException, EDAMSystemException, TException;

    public Note copyNote(String var1, String var2, String var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public List<NoteVersionId> listNoteVersions(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Note getNoteVersion(String var1, String var2, int var3, boolean var4, boolean var5, boolean var6) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Resource getResource(String var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public LazyMap getResourceApplicationData(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public String getResourceApplicationDataEntry(String var1, String var2, String var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int setResourceApplicationDataEntry(String var1, String var2, String var3, String var4) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int unsetResourceApplicationDataEntry(String var1, String var2, String var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public int updateResource(String var1, Resource var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public byte[] getResourceData(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Resource getResourceByHash(String var1, String var2, byte[] var3, boolean var4, boolean var5, boolean var6) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public byte[] getResourceRecognition(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public byte[] getResourceAlternateData(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public ResourceAttributes getResourceAttributes(String var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public long getAccountSize(String var1) throws EDAMUserException, EDAMSystemException, TException;

    public List<Ad> getAds(String var1, AdParameters var2) throws EDAMUserException, EDAMSystemException, TException;

    public Ad getRandomAd(String var1, AdParameters var2) throws EDAMUserException, EDAMSystemException, TException;

    public Notebook getPublicNotebook(int var1, String var2) throws EDAMSystemException, EDAMNotFoundException, TException;

    public SharedNotebook createSharedNotebook(String var1, SharedNotebook var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public int sendMessageToSharedNotebookMembers(String var1, String var2, String var3, List<String> var4) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public List<SharedNotebook> listSharedNotebooks(String var1) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public int expungeSharedNotebooks(String var1, List<Long> var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public LinkedNotebook createLinkedNotebook(String var1, LinkedNotebook var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public int updateLinkedNotebook(String var1, LinkedNotebook var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public List<LinkedNotebook> listLinkedNotebooks(String var1) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public int expungeLinkedNotebook(String var1, String var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public AuthenticationResult authenticateToSharedNotebook(String var1, String var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public SharedNotebook getSharedNotebookByAuth(String var1) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public void emailNote(String var1, NoteEmailParameters var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public String shareNote(String var1, String var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public void stopSharingNote(String var1, String var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;

    public AuthenticationResult authenticateToSharedNote(String var1, String var2) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException;
}

