/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.conn.mobile;

import com.evernote.edam.type.Data;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TStruct;

public class FileData
extends Data {
    private static final TStruct STRUCT_DESC = new TStruct("Data");
    private static final TField BODY_HASH_FIELD_DESC = new TField("bodyHash", 11, 1);
    private static final TField SIZE_FIELD_DESC = new TField("size", 8, 2);
    private static final TField BODY_FIELD_DESC = new TField("body", 11, 3);
    private static final long serialVersionUID = 1L;
    private File mBodyFile;

    public FileData(byte[] bodyHash, File file) {
        this.mBodyFile = file;
        this.setBodyHash(bodyHash);
        this.setSize((int)file.length());
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.getBodyHash() != null && this.isSetBodyHash()) {
            oprot.writeFieldBegin(BODY_HASH_FIELD_DESC);
            oprot.writeBinary(ByteBuffer.wrap(this.getBodyHash()));
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SIZE_FIELD_DESC);
        oprot.writeI32(this.getSize());
        oprot.writeFieldEnd();
        if (this.mBodyFile != null && this.mBodyFile.isFile()) {
            oprot.writeFieldBegin(BODY_FIELD_DESC);
            FileInputStream s = null;
            try {
                try {
                    s = new FileInputStream(this.mBodyFile);
                    oprot.writeStream((InputStream)s, this.mBodyFile.length());
                }
                catch (FileNotFoundException e) {
                    throw new TException("Failed to write binary body:" + this.mBodyFile, (Throwable)e);
                }
            }
            finally {
                try {
                    if (s != null) {
                        ((InputStream)s).close();
                    }
                }
                catch (Exception exception) {}
            }
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }
}

