<?php

// DBRecordベースクラス

abstract class DBRecordBase {
	
	protected $__table;					// テーブル名
	protected $__id;					// ID（プライマリキー）
	
	protected $__record_data;			// このレコードのデータ
	protected $__f_dirty;				// 書込みフラグ
	
	protected static $__dbh = false;	// 接続リソース
	protected static $__connect_param;	// 接続パラメータ
	
	public function __construct( $connect_param, $table, $property = null, $value = null ) {
		// ダミー
	}
	
	// テーブルを作成する
	abstract public function __createTable( $tblstring );
	
	// クエリの実行
	abstract protected function __query( $sqlstr );
	
	// トランザクション
	abstract public function __start_transaction();
	abstract public function __end_transaction();
	
	// テーブルに対しselectを結果を実行して配列で返す
	abstract public function __fetch_array( $options = null );
	
	// レコードに対する値のセット、ゲット
	abstract public function __set( $property, $value );
	abstract public function __get( $property );
	
	// レコードの削除
	abstract public function __delete();
	
	// レコードの書込み
	abstract public function __update();
	
	// レーブルに対してcountを実行する
	abstract public function __count( $options = "" );
	
	
	// DBRecordオブジェクト配列を返すstaticなメソッド
	static function __createRecords( $connect_param, $table, $options = "" ) {
		$retval = array();
		$arr = array();
		try{
			$record = new self( $connect_param, $table );
			$arr = $record->__fetch_array( $options );
			foreach( $arr as $value ) {
				array_push( $retval, new self( $connect_param, $table,  'id', $value['id'] ) );
			}
		}
		catch( Exception $e ) {
			throw $e;
		}
		return $retval;
	}
	
	// デストラクタ
	function __destruct() {
		if( $this->__id != 0 ) {
			$this->__update();
		}
		$this->__id = 0;
		$this->__record_data = false;
	}
}
?>
