var Eos = require('../../server/class/Eos');
var expect = require('chai').expect;

var test1 = `
/**
* Eosコマンドをエミュレートするクラス 
*
* @param {string} Eosコマンドの名前
* @param {Array<Object>} コマンドに渡すオプション
* @returns 
* function execute(command, params) {
*/

`;

describe(/*execute()*/test1, function() {
    describe('#1: check whether command is valid or not', function() {
        var eos;
        before(function() {
            eos = new Eos();
        });

        it('should return false when the command is typeof number.', function() {
            var  result = eos.execute(2);
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when command name is invalid', function() {
            var result = eos.execute('hoge');
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when options is not Array', function() {
            var result = eos.execute('mrcImageInfo', {});
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when options is Array whose length is 0.', function() {
            var result = eos.execute('mrcImageInfo', []);
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when options is invalid Object which have not "name" and "argumetns"', function() {
            var result = eos.execute('mrcImageInfo', [{hoge: 'hoge'}]);
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when "argumetns" properties are not Array', function() {
            var result = eos.execute('mrcImageInfo', [{name: 'hoge', arguments: 'hoge'}]);
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when "argumetns" properties are not Array', function() {
            var result = eos.execute('mrcImageInfo', [{name: 'hoge', arguments: 'hoge'}]);
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when required options do not exist', function() {
            var result = eos.execute('mrcImageInfo', [{name: 'hoge', arguments: []}]);
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when required options do not exist', function() {
            var result = eos.execute('dcdFilePrint', [{name: '-r', arguments: [1,2]}, { name: '-i', arguments: []}, { name: '-o', arguments: []} ]);
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when input file does not exist', function() {
            var result = eos.execute('dcdFilePrint', [{name: '-r', arguments: [1,2,3]}, { name: '-i', arguments: ['hoge.txt']}, { name: '-o', arguments: ['hoge.txt']} ]);
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when output file is not string', function() {
            var result = eos.execute('dcdFilePrint', [{name: '-r', arguments: [1,2,3]}, { name: '-i', arguments: ['file1.txt']}, { name: '-o', arguments: [3]} ]);
            expect(result.hasDone).to.equal(false);
        });

        it('should return false when output file has already existed', function() {
            var result = eos.execute('dcdFilePrint', [{name: '-r', arguments: [1,2,3]}, { name: '-i', arguments: ['file1.txt']}, { name: '-o', arguments: ['file1.txt']} ]);
            console.log(result.comment);
            expect(result.hasDone).to.equal(false);
        });

        it('should return true when all options is proper.', function() {
            var result = eos.execute('dcdFilePrint', [{name: '-r', arguments: [1,2,3]}, { name: '-i', arguments: ['file1.txt']}, { name: '-o', arguments: ['file3.txt']} ]);
            //console.log(result.comment);
            expect(result.hasDone).to.equal(true);
        });

    });
});
