# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{sys-uname}
  s.version = "0.9.2"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Daniel J. Berger"]
  s.date = %q{2013-05-01}
  s.description = %q{    The sys-uname library provides an interface for gathering information
 \   about your current platform. The library is named after the Unix 'uname'
    command but also works on MS Windows. Available information includes
    OS name, OS version, system name and so on. Additional information is
    available for certain platforms.
}
  s.email = %q{djberg96@gmail.com}
  s.extra_rdoc_files = ["CHANGES", "README", "MANIFEST", "doc/uname.txt"]
  s.files = ["CHANGES", "doc/uname.txt", "examples/uname_test.rb", "lib/unix/sys/uname.rb", "lib/windows/sys/uname.rb", "MANIFEST", "Rakefile", "README", "sys-uname.gemspec", "test/test_sys_uname.rb"]
  s.homepage = %q{http://www.rubyforge.org/projects/sysutils}
  s.licenses = ["Artistic 2.0"]
  s.require_paths = ["lib", "lib/unix"]
  s.rubyforge_project = %q{sysutils}
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{An interface for returning uname (platform) information}
  s.test_files = ["test/test_sys_uname.rb"]

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<ffi>, [">= 1.0.0"])
    else
      s.add_dependency(%q<ffi>, [">= 1.0.0"])
    end
  else
    s.add_dependency(%q<ffi>, [">= 1.0.0"])
  end
end
