# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{dropbox-sdk}
  s.version = "1.6.5"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Dropbox, Inc."]
  s.date = %q{2015-07-29}
  s.description = %q{    A library that provides a plain function-call interface to the
    Dropbox API web endpoints.
}
  s.email = ["support-api@dropbox.com"]
  s.files = ["CHANGELOG", "LICENSE", "README", "examples/chunked_upload.rb", "examples/cli_example.rb", "examples/copy_between_accounts.rb", "examples/dropbox_controller.rb", "examples/oauth1_upgrade.rb", "examples/search_cache.rb", "examples/web_file_browser.rb", "lib/dropbox_sdk.rb", "lib/trusted-certs.crt"]
  s.homepage = %q{http://www.dropbox.com/developers/}
  s.licenses = ["MIT"]
  s.require_paths = ["lib"]
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{Dropbox REST API Client.}

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 4

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<json>, [">= 0"])
      s.add_development_dependency(%q<minitest>, ["~> 4.3.2"])
      s.add_development_dependency(%q<test-unit>, [">= 0"])
    else
      s.add_dependency(%q<json>, [">= 0"])
      s.add_dependency(%q<minitest>, ["~> 4.3.2"])
      s.add_dependency(%q<test-unit>, [">= 0"])
    end
  else
    s.add_dependency(%q<json>, [">= 0"])
    s.add_dependency(%q<minitest>, ["~> 4.3.2"])
    s.add_dependency(%q<test-unit>, [">= 0"])
  end
end
