# Temppath

Temppath is a Ruby library for generating temporary file path. The differences
from standard tempfile.rb are that this library generates Pathname objects with
no files and filenames are based on UUID. Files in paths generated by this are
deleted when Ruby exits.

[![Gem Version](https://badge.fury.io/rb/temppath.png)](http://badge.fury.io/rb/temppath) [![Build Status](https://travis-ci.org/keita/temppath.png?branch=master)](https://travis-ci.org/keita/temppath) [![Coverage Status](https://coveralls.io/repos/keita/temppath/badge.png?branch=master)](https://coveralls.io/r/keita/temppath) [![Code Climate](https://codeclimate.com/github/keita/temppath.png)](https://codeclimate.com/github/keita/temppath)

## Features

* You can generate a path without file.
* Temppath can generate files and directories as well. Therefore you are free
  from confusion which is correct tmpfile/tempfile or tmpdir/tempdir.
* Generated paths are `Pathname` objects.

## Installation

    $ gem install temppath

## Usage

#### Create a path

```ruby
path = Temppath.create
#=> #<Pathname:/tmp/ruby-temppath-20130407-5775-w5k77l/f41bd6c5-fc99-4b7a-8f68-95b7ae4a6b22>
path.exist? #=> false
path.open("w")
"%o" % path.stat.mode #=> "100600" (default permission 0600)
```

#### Create a directory

```ruby
path = Temppath.mkdir
path.exist?     #=> true
path.directory? #=> true
"%o" % path.stat.mode #=> "40700"
```

#### Create an empty file

```ruby
path = Temppath.touch
path.exist? #=> true
path.file?  #=> true
"%o" % path.stat.mode #=> "100600"
```

#### Use temporary path generator

You can use `Temppath::Generator` when you want to use multiple base
directory. Generated paths have same natures as paths from `Tempath.create`,
`mkdir`, and `touch`.

```ruby
# make a generator
temppath = Temppath::Generator.new("/tmp/other-dir")
 
path = temppath.create
path.exist? #=> false
path.open("w")
"%o" % path.stat.mode #=> "100600"
 
path = temppath.mkdir
path.exist?     #=> true
path.directory? #=> true
"%o" % path.stat.mode #=> "40700"
 
path = temppath.touch
path.exist? #=> true
path.file?  #=> true
"%o" % path.stat.mode #=> "100600"
```

## Documentation

- [API Documentation](http://www.rubydoc.info/gems/temppath/)

## License

Temppath is free software distributed under MIT license.

## Contributing

1. Fork it
2. Create your feature branch (`git checkout -b my-new-feature`)
3. Commit your changes (`git commit -am 'Add some feature'`)
4. Push to the branch (`git push origin my-new-feature`)
5. Create new Pull Request
