/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class InspectPDF
extends AbstractTool {
    public InspectPDF() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
        this.arguments.add(new StringArgument(this, "ownerpassword", "The owner password if the file is encrypt"));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Pdf Information", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Pdf Information OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            PdfReader pdfReader = this.getValue("ownerpassword") == null ? new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath()) : new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath(), ((String)this.getValue("ownerpassword")).getBytes());
            System.out.println("=== Document Information ===");
            System.out.println("PDF Version: " + pdfReader.getPdfVersion());
            System.out.println("Number of pages: " + pdfReader.getNumberOfPages());
            System.out.println("Number of PDF objects: " + pdfReader.getXrefSize());
            System.out.println("File length: " + pdfReader.getFileLength());
            System.out.println("Encrypted? " + pdfReader.isEncrypted());
            if (pdfReader.isEncrypted()) {
                System.out.println("Permissions: " + PdfEncryptor.getPermissionsVerbose(pdfReader.getPermissions()));
                System.out.println("128 bit? " + pdfReader.is128Key());
            }
            System.out.println("Rebuilt? " + pdfReader.isRebuilt());
            System.out.println("=== Metadata ===");
            HashMap hashMap = pdfReader.getInfo();
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                System.out.println(string + ": " + string2);
            }
            if (pdfReader.getMetadata() == null) {
                System.out.println("There is no XML Metadata in the file");
            } else {
                System.out.println("XML Metadata: " + new String(pdfReader.getMetadata()));
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        InspectPDF inspectPDF = new InspectPDF();
        if (stringArray.length < 1) {
            System.err.println(inspectPDF.getUsage());
        }
        inspectPDF.setMainArguments(stringArray);
        inspectPDF.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    static {
        InspectPDF.addVersion("$Id: InspectPDF.java 3826 2009-03-31 17:46:18Z blowagie $");
    }
}

