/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;

public class RangeSelection
implements ISelection {
    private Object[] minKey;
    private Object[] maxKey;
    private boolean containsMinKey;
    private boolean containsMaxKey;
    private static Logger logger = Logger.getLogger(RangeSelection.class.getName());

    public RangeSelection(Object[] minKey, Object[] maxKey, boolean containsMinKey, boolean containsMaxKey) {
        Object[] params = new Object[]{minKey, maxKey, containsMinKey, containsMaxKey};
        logger.entering(RangeSelection.class.getName(), "RangeSelection", params);
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.containsMinKey = containsMinKey;
        this.containsMaxKey = containsMaxKey;
        logger.exiting(RangeSelection.class.getName(), "RangeSelection");
    }

    public boolean isSelected(Object[] key) {
        if (this.minKey != null && (this.containsMinKey ? CompareUtil.compare(key, this.minKey) < 0 : CompareUtil.compare(key, this.minKey) <= 0)) {
            return false;
        }
        return this.maxKey == null || !(this.containsMaxKey ? CompareUtil.compare(key, this.maxKey) > 0 : CompareUtil.compare(key, this.maxKey) >= 0);
    }

    public Object[] getMax() {
        return this.maxKey;
    }

    public Object[] getMin() {
        return this.minKey;
    }

    public boolean isContainsMinKey() {
        return this.containsMinKey;
    }

    public boolean isContainsMaxKey() {
        return this.containsMaxKey;
    }
}

