/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.impl.StringTable;
import org.eclipse.birt.data.engine.impl.document.DataSetIndexFactory;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.index.IAuxiliaryIndexCreator;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.odi.IResultClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamWrapper {
    private OutputStream streamForResultClass;
    private DataOutputStream streamForDataSet;
    private OutputStream streamForGroupInfo;
    private OutputStream streamForRowIndexInfo;
    private OutputStream streamForParentIndex;
    private DataOutputStream streamForDataSetLens;
    private StreamManager manager;
    private boolean enableIndexStream;
    private Map<IResultClass, Map<String, IIndexSerializer>> cachedIndex = new HashMap<IResultClass, Map<String, IIndexSerializer>>();
    private Map<IResultClass, Map<String, StringTable>> cachedStringTable = new HashMap<IResultClass, Map<String, StringTable>>();
    private List<IAuxiliaryIndexCreator> auxiliaryIndexCreators = new ArrayList<IAuxiliaryIndexCreator>();

    public StreamWrapper(StreamManager manager, OutputStream streamForResultClass, OutputStream streamForGroupInfo, OutputStream streamForRowIndexInfo, OutputStream streamForParentIndex) {
        this.streamForResultClass = streamForResultClass;
        this.streamForGroupInfo = streamForGroupInfo;
        this.streamForRowIndexInfo = streamForRowIndexInfo;
        this.streamForParentIndex = streamForParentIndex;
        this.manager = manager;
    }

    public StreamWrapper(StreamManager manager, OutputStream streamForResultClass, OutputStream streamForGroupInfo, OutputStream streamForRowIndexInfo, OutputStream streamForParentIndex, boolean enableIndex) {
        this(manager, streamForResultClass, streamForGroupInfo, streamForRowIndexInfo, streamForParentIndex);
        this.enableIndexStream = enableIndex;
    }

    public StreamManager getStreamManager() {
        return this.manager;
    }

    public OutputStream getStreamForResultClass() {
        return this.streamForResultClass;
    }

    public DataOutputStream getStreamForDataSet() throws DataException {
        if (this.streamForResultClass != null && this.streamForDataSet == null) {
            this.streamForDataSet = new DataOutputStream(this.manager.getOutStream(21, 0, 2));
        }
        return this.streamForDataSet;
    }

    public Map<String, StringTable> getOutputStringTable(IResultClass resultClass) throws DataException {
        if (!this.enableIndexStream) {
            return new HashMap<String, StringTable>();
        }
        if (this.cachedStringTable.containsKey(resultClass)) {
            return this.cachedStringTable.get(resultClass);
        }
        HashMap<String, StringTable> result = new HashMap<String, StringTable>();
        int i = 1;
        while (i <= resultClass.getFieldCount()) {
            Class dataType;
            if (resultClass.isCompressedColumn(i) && (dataType = resultClass.getFieldValueClass(i)) == String.class) {
                String fieldName = resultClass.getFieldName(i);
                StringTable stringTable = new StringTable();
                stringTable.setStreamManager(this.manager, fieldName);
                result.put(fieldName, stringTable);
            }
            ++i;
        }
        this.cachedStringTable.put(resultClass, result);
        return result;
    }

    public Map<String, IIndexSerializer> getStreamForIndex(IResultClass resultClass, Map appContext) throws DataException {
        if (!this.enableIndexStream) {
            return new HashMap<String, IIndexSerializer>();
        }
        if (this.cachedIndex.containsKey(resultClass)) {
            return this.cachedIndex.get(resultClass);
        }
        HashMap<String, IIndexSerializer> result = new HashMap<String, IIndexSerializer>();
        int indexColumnCount = 0;
        int i = 1;
        while (i <= resultClass.getFieldCount()) {
            if (resultClass.isIndexColumn(i)) {
                ++indexColumnCount;
            }
            ++i;
        }
        i = 1;
        while (i <= resultClass.getFieldCount()) {
            if (resultClass.isIndexColumn(i)) {
                Class dataType = resultClass.getFieldValueClass(i);
                String fieldName = resultClass.getFieldName(i);
                long memoryBufferSize = CacheUtil.computeMemoryBufferSize(appContext);
                IIndexSerializer index = DataSetIndexFactory.createIndex(memoryBufferSize / (long)indexColumnCount, "Index/" + fieldName + "/btreeIndex", this.manager, dataType);
                if (index != null) {
                    result.put(fieldName, index);
                }
            }
            ++i;
        }
        this.cachedIndex.put(resultClass, result);
        return result;
    }

    public DataOutputStream getStreamForDataSetRowLens() throws DataException {
        if (this.streamForResultClass != null && this.streamForDataSetLens == null) {
            this.streamForDataSetLens = new DataOutputStream(this.manager.getOutStream(23, 0, 2));
        }
        return this.streamForDataSetLens;
    }

    public OutputStream getStreamForGroupInfo() {
        return this.streamForGroupInfo;
    }

    public OutputStream getStreamForRowIndexInfo() {
        return this.streamForRowIndexInfo;
    }

    public OutputStream getStreamForParentIndex() {
        return this.streamForParentIndex;
    }

    public List<IAuxiliaryIndexCreator> getAuxiliaryIndexCreators() {
        return this.auxiliaryIndexCreators;
    }

    public void addAuxiliaryIndexCreator(IAuxiliaryIndexCreator auxIndexCreator) {
        this.auxiliaryIndexCreators.add(auxIndexCreator);
    }
}

