/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.connection;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.BasicCache;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.remote.connection.CudaToolkitWorkingCopy;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteShell;
import com.nvidia.cuda.ide.remote.internal.connection.Activator;
import com.nvidia.cuda.ide.remote.internal.connection.CudaToolkitsStore;
import com.nvidia.cuda.ide.remote.internal.connection.RSERemoteShell;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;

public final class RSERemoteConnection
implements IRemoteConnection {
    private final IHost host;
    private final BasicCache<Tuple<Realm, IRemoteConnection.Service, ?>, IsConnectedObservable> isConnectedObservables = new BasicCache<Tuple<Realm, IRemoteConnection.Service, ?>, IsConnectedObservable>(){

        protected IsConnectedObservable createNew(Tuple<Realm, IRemoteConnection.Service, ?> key) {
            return new IsConnectedObservable((Realm)key.getObject1(), (IRemoteConnection.Service)((Object)key.getObject2()));
        }
    };
    private final BasicCache<Realm, ConnectionNameObservable> nameObservables = new BasicCache<Realm, ConnectionNameObservable>(){

        protected ConnectionNameObservable createNew(Realm key) {
            return new ConnectionNameObservable(key);
        }
    };
    private IRemoteShell shell;
    private final CudaToolkitsStore store;
    private ToolkitObserveable toolkitObserveable;

    private static void assertRemoteFile(IRemoteFile remoteFile) throws CoreException {
        if (!remoteFile.exists()) {
            throw CoreUtil.coreException((String)"%s does not exist", (Object[])new Object[]{remoteFile.getAbsolutePath()});
        }
        if (!remoteFile.isFile()) {
            throw CoreUtil.coreException((String)"%s is not a file", (Object[])new Object[]{remoteFile.getAbsolutePath()});
        }
    }

    private static String createToolkitStoreName(String label) {
        return "remote." + label;
    }

    public RSERemoteConnection(IHost host) {
        this.host = host;
        String label = host.getAliasName();
        this.store = new CudaToolkitsStore(RSERemoteConnection.createToolkitStoreName(label));
    }

    @Override
    public String browse(Shell shell, String prompt, String path) throws CoreException {
        Object[] selectedObjects;
        if (!this.isConnected(IRemoteConnection.Service.Files)) {
            this.connect(IRemoteConnection.Service.Files, (IProgressMonitor)new NullProgressMonitor());
        }
        SystemRemoteFileDialog dialog = new SystemRemoteFileDialog(shell, prompt, this.host);
        dialog.setDefaultSystemConnection(this.host, true);
        if (path != null) {
            IRemoteFileSubSystem system = RemoteFileUtility.getFileSubSystem((IHost)this.host);
            try {
                IRemoteFile file = system.getRemoteFileObject(path, (IProgressMonitor)new NullProgressMonitor());
                if (file != null && file.exists()) {
                    dialog.setPreSelection((Object)file);
                }
            }
            catch (SystemMessageException e) {
                Activator.log((Exception)((Object)e));
            }
        }
        if (dialog.open() == 0 && (selectedObjects = dialog.getSelectedObjects()) != null && selectedObjects.length == 1 && selectedObjects[0] instanceof IAdaptable) {
            return this.decodeRSEBrowseDialogSelection(selectedObjects[0]);
        }
        return null;
    }

    private void checkLocalFileForReading(String localPath) throws CoreException {
        File localFile = new File(localPath);
        if (!localFile.exists()) {
            throw CoreUtil.coreException((String)"File %s does not exist", (Object[])new Object[]{localPath});
        }
        if (localFile.isDirectory()) {
            throw CoreUtil.coreException((String)"Path %s denotes a directory", (Object[])new Object[]{localPath});
        }
    }

    private IRemoteFile checkRemoteFileForWriting(String remotePath, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        IRemoteFile remoteFile = this.getRemoteFileObject(remotePath, true, monitor);
        if (remoteFile.exists()) {
            if (!overwrite) {
                throw CoreUtil.coreException((String)"File %s on system %s already exists", (Object[])new Object[]{remoteFile, this.getHost().getHostName()});
            }
            if (remoteFile.isDirectory()) {
                throw CoreUtil.coreException((String)"Path %s on system %s denotes a directory", (Object[])new Object[]{remoteFile, this.getHost().getHostName()});
            }
            if (!remoteFile.canWrite()) {
                throw CoreUtil.coreException((String)"File %s on system %s is not writable", (Object[])new Object[]{remoteFile, this.getHost().getHostName()});
            }
        }
        return remoteFile;
    }

    public void clearFilesCache() throws CoreException {
        Object subsystem;
        if (this.isConnected(IRemoteConnection.Service.Files) && (subsystem = this.getSubsystem(IRemoteConnection.Service.Files)) instanceof RemoteFileSubSystem) {
            try {
                Method method = RemoteFileSubSystem.class.getDeclaredMethod("clearRemoteFileCache", new Class[0]);
                method.setAccessible(true);
                method.invoke(subsystem, new Object[0]);
                return;
            }
            catch (NoSuchMethodException e) {
                Activator.log(e);
            }
            catch (SecurityException e) {
                Activator.log(e);
            }
            catch (IllegalArgumentException e) {
                Activator.log(e);
            }
            catch (IllegalAccessException e) {
                Activator.log(e);
            }
            catch (InvocationTargetException e) {
                Activator.log(e);
            }
        }
    }

    @Override
    public void connect(IRemoteConnection.Service service, IProgressMonitor monitor) throws CoreException {
        block7: {
            if (this.isConnected(service)) {
                return;
            }
            if (monitor != null) {
                monitor.beginTask(String.format("Establishing connection to %s", this.getName()), -1);
            }
            try {
                Object subsystem = this.getSubsystem(service);
                if (subsystem == null || subsystem.isConnected()) break block7;
                IConnectorService connectorService = subsystem.getConnectorService();
                try {
                    subsystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (Exception e) {
                    connectorService.clearPassword(false, true);
                    throw CoreUtil.coreException((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private String decodeRSEBrowseDialogSelection(Object selection) {
        IRemoteFile f = (IRemoteFile)((IAdaptable)selection).getAdapter(IRemoteFile.class);
        if (selection instanceof IRemoteFile) {
            return f.getAbsolutePath();
        }
        if (selection instanceof ISystemFilterReference) {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)selection).getAdapter(IWorkbenchAdapter.class);
            Object[] children = adapter.getChildren(selection);
            if (children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IRemoteFile) {
                        String parentPath = ((IRemoteFile)object).getParentPath();
                        return parentPath == null ? "/" : parentPath;
                    }
                    ++n2;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void deleteEmptyFolder(IPath remoteFolder, IProgressMonitor monitor) throws CoreException {
        IFileServiceSubSystem subsystem = (IFileServiceSubSystem)this.getSubsystem(IRemoteConnection.Service.Files);
        String remoteFolderStr = remoteFolder.toString();
        String hostName = this.getHostName();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format("Removing folder %s from %s", remoteFolderStr, hostName), (int)30);
        try {
            try {
                IRemoteFile fileObject = subsystem.getRemoteFileObject(remoteFolderStr, (IProgressMonitor)mon.newChild(10));
                if (!fileObject.exists()) {
                    throw CoreUtil.coreException((String)"Folder %s does not exist on a remote system %s", (Object[])new Object[]{remoteFolderStr, hostName});
                }
                if (!fileObject.isDirectory()) {
                    throw CoreUtil.coreException((String)"Path %s does not point to a folder on a remote system %s", (Object[])new Object[]{remoteFolderStr, hostName});
                }
                if (subsystem.list(fileObject, (IProgressMonitor)mon.newChild(10)).length > 0) {
                    throw CoreUtil.coreException((String)"Folder %s does on a remote system %s is not empty", (Object[])new Object[]{remoteFolderStr, hostName});
                }
                subsystem.delete(fileObject, (IProgressMonitor)mon.newChild(10));
            }
            catch (SystemMessageException e) {
                throw CoreUtil.coreException((Throwable)e, (String)"Unable to delete folder %s from system %s", (Object[])new Object[]{remoteFolderStr, hostName});
            }
        }
        finally {
            mon.done();
        }
    }

    @Override
    public void deleteFile(String path, IProgressMonitor monitor) throws CoreException {
        if (CoreUtil.isNullOrEmpty((String)path)) {
            throw CoreUtil.coreException((String)"File name is missing", (Object[])new Object[0]);
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format("Removing %s on %s remote system", path, this.getHostName()), (int)40);
        try {
            IRemoteFile fileObject = this.getRemoteFileObject(path, true, (IProgressMonitor)mon.newChild(10));
            RSERemoteConnection.assertRemoteFile(fileObject);
            IFileServiceSubSystem system = (IFileServiceSubSystem)this.getSubsystem(IRemoteConnection.Service.Files);
            try {
                system.delete(fileObject, (IProgressMonitor)mon.newChild(30));
            }
            catch (SystemMessageException e) {
                throw CoreUtil.coreException((Throwable)e, (String)"Unable to delete file %s on system %s", (Object[])new Object[]{path, this.getHost()});
            }
        }
        finally {
            mon.done();
        }
    }

    @Override
    public void download(IPath remotePath, IPath localPath, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        if (!overwrite && localPath.toFile().exists()) {
            throw CoreUtil.coreException((String)"Local file %s already exists", (Object[])new Object[]{localPath});
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format("Downloading %s to %s", remotePath, localPath), (int)50);
        try {
            try {
                IFileServiceSubSystem fileSubSystem = (IFileServiceSubSystem)this.getSubsystem(IRemoteConnection.Service.Files);
                IRemoteFile remote = fileSubSystem.getRemoteFileObject(remotePath.toString(), (IProgressMonitor)mon.newChild(10));
                RSERemoteConnection.assertRemoteFile(remote);
                fileSubSystem.download(remote, localPath.toString(), null, (IProgressMonitor)mon.newChild(40));
            }
            catch (SystemMessageException e) {
                throw CoreUtil.coreException((Throwable)e, (String)"Download file %s from %s failed", (Object[])new Object[]{remotePath, this.getHostName()});
            }
        }
        finally {
            mon.done();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RSERemoteConnection other = (RSERemoteConnection)obj;
        return !(this.host == null ? other.host != null : !this.host.equals(other.host));
    }

    @Override
    public IFile getFile(String path, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        try {
            IRemoteFileSubSystem system = RemoteFileUtility.getFileSubSystem((IHost)this.host);
            IRemoteFile file = system.getRemoteFileObject(path, (IProgressMonitor)subMonitor.newChild(5));
            if (file != null && file.exists() && file.isFile()) {
                SystemEditableRemoteFile remoteFile = new SystemEditableRemoteFile(file);
                remoteFile.download((IProgressMonitor)subMonitor.newChild(15));
                remoteFile.setLocalResourceProperties();
                IFile iFile = remoteFile.getLocalResource();
                return iFile;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw CoreUtil.coreException((Throwable)e, (String)"Unable to download %s: %s", (Object[])new Object[]{path, e.getMessage()});
        }
        finally {
            subMonitor.done();
        }
    }

    public IHost getHost() {
        return this.host;
    }

    @Override
    public String getUserName() {
        return this.host.getDefaultUserId();
    }

    @Override
    public String getHostName() {
        return this.host.getHostName();
    }

    @Override
    public String getName() {
        Realm realm = Realm.getDefault();
        if (realm != null) {
            return (String)((ConnectionNameObservable)((Object)this.nameObservables.get((Object)realm))).getValue();
        }
        return this.internalGetName();
    }

    @Override
    public String getPathListSeparator() {
        return ":";
    }

    private String getPreferenceName(String name) {
        return String.format("connection.%s.%s", this.getName(), name);
    }

    @Override
    public boolean getProperty(String name, boolean defaultValue) {
        String pref;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        return preferenceStore.isDefault(pref = this.getPreferenceName(name)) ? defaultValue : preferenceStore.getBoolean(pref);
    }

    @Override
    public int getProperty(String name, int defaultValue) {
        String pref;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        return preferenceStore.isDefault(pref = this.getPreferenceName(name)) ? defaultValue : preferenceStore.getInt(pref);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        String pref;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        return preferenceStore.isDefault(pref = this.getPreferenceName(name)) ? defaultValue : preferenceStore.getString(pref);
    }

    private IRemoteFile getRemoteFileObject(String remotePath, boolean connect, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        Object subsystem = this.getSubsystem(IRemoteConnection.Service.Files);
        boolean connected = false;
        if (subsystem == null) {
            return null;
        }
        if (!subsystem.isConnected()) {
            if (connect) {
                connected = true;
                this.connect(IRemoteConnection.Service.Files, (IProgressMonitor)subMonitor.newChild(10));
            } else {
                return null;
            }
        }
        try {
            return ((IFileServiceSubSystem)subsystem).getRemoteFileObject(remotePath, (IProgressMonitor)(connected ? subMonitor.newChild(5) : subMonitor));
        }
        catch (SystemMessageException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }

    private <T extends ISubSystem> T getSubsystem(IRemoteConnection.Service service) throws CoreException {
        Class<IFileServiceSubSystem> subsystemType = null;
        switch (service) {
            case Files: {
                subsystemType = IFileServiceSubSystem.class;
                break;
            }
            case Shell: {
                subsystemType = IShellServiceSubSystem.class;
            }
        }
        ISubSystem[] iSubSystemArray = this.host.getSubSystems();
        int n = iSubSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem system = iSubSystemArray[n2];
            if (subsystemType.isInstance(system)) {
                return (T)system;
            }
            ++n2;
        }
        throw CoreUtil.coreException((String)"%s subsytem is not configured for connection %s", (Object[])new Object[]{service.name(), this.getName()});
    }

    @Override
    public ICudaToolkit getToolkit() {
        if (this.isLocalSystem()) {
            try {
                return (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                    public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                        return service.getDefaultToolkit();
                    }
                });
            }
            catch (CoreException e) {
                throw new IllegalStateException(e);
            }
        }
        Object[] toolkits = this.store.getToolkits();
        return CoreUtil.isNullOrEmpty((Object[])toolkits) ? null : toolkits[0];
    }

    public void handle(ISystemResourceChangeEvent event) {
        block5: {
            block4: {
                if (event.getType() != 81) break block4;
                for (IsConnectedObservable observable : this.isConnectedObservables) {
                    observable.stateChanged();
                }
                break block5;
            }
            if (event.getType() != 86) break block5;
            for (ConnectionNameObservable observable : this.nameObservables) {
                observable.update();
            }
            try {
                this.store.rename(RSERemoteConnection.createToolkitStoreName(this.getName()));
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        return result;
    }

    private String internalGetName() {
        return this.host.getAliasName();
    }

    private boolean internalIsConnected(IRemoteConnection.Service service) {
        try {
            Object subSystem = this.getSubsystem(service);
            return subSystem != null && subSystem.isConnected();
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return false;
        }
    }

    @Override
    public boolean isConnected(IRemoteConnection.Service service) {
        Realm realm = Realm.getDefault();
        if (realm != null) {
            return (Boolean)((IsConnectedObservable)((Object)this.isConnectedObservables.get((Object)Tuple.pair((Object)realm, (Object)((Object)service))))).getValue();
        }
        return this.internalIsConnected(service);
    }

    @Override
    public boolean isDirectory(String path, IProgressMonitor monitor) {
        try {
            this.clearFilesCache();
            IRemoteFile file = this.getRemoteFileObject(path, false, monitor);
            return file != null && file.exists() && file.isDirectory();
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return false;
        }
    }

    @Override
    public boolean isFile(String remotePath, boolean isExecutable, IProgressMonitor monitor) {
        try {
            this.clearFilesCache();
            IRemoteFile file = this.getRemoteFileObject(remotePath, false, monitor);
            return file != null && file.exists() && file.isFile() && (!isExecutable || file.isExecutable());
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return false;
        }
    }

    @Override
    public boolean isLocalSystem() {
        return this.host.getSystemType().isLocal();
    }

    @Override
    public boolean isSameFile(String localPath, String remotePath, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)25);
        IFileStore localFile = EFS.getLocalFileSystem().getStore((IPath)new Path(localPath));
        IFileInfo info = localFile.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(5));
        IRemoteFile file = this.getRemoteFileObject(remotePath, true, (IProgressMonitor)subMonitor.newChild(20));
        if (info.exists() && file.exists() && info.isDirectory() == file.isDirectory() && info.getLength() == file.getLength()) {
            long l = Math.abs(info.getLastModified() - file.getLastModified());
            return l < 1500L;
        }
        subMonitor.done();
        return false;
    }

    @Override
    public void mkdir(String path, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        IFileServiceSubSystem fileSubsystem = (IFileServiceSubSystem)this.getSubsystem(IRemoteConnection.Service.Files);
        try {
            try {
                IRemoteFile file = fileSubsystem.getRemoteFileObject(path, (IProgressMonitor)m.newChild(100));
                if (file.exists()) {
                    if (file.isFile()) {
                        throw CoreUtil.coreException((String)"%s is a file", (Object[])new Object[]{path});
                    }
                } else {
                    fileSubsystem.createFolders(file, (IProgressMonitor)m.newChild(100));
                }
            }
            catch (SystemMessageException e) {
                throw CoreUtil.coreException((Throwable)e, (String)"Unable to make remote folder %s", (Object[])new Object[]{path});
            }
        }
        finally {
            m.done();
        }
    }

    @Override
    public IObservableValue observeToolkit() {
        if (this.toolkitObserveable == null) {
            this.toolkitObserveable = new ToolkitObserveable();
        }
        return this.toolkitObserveable;
    }

    @Override
    public IRemoteShell openShell(IProgressMonitor monitor) throws CoreException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Establishing shell connection", (int)-1);
        try {
            IShellServiceSubSystem system = (IShellServiceSubSystem)this.getSubsystem(IRemoteConnection.Service.Shell);
            if (system == null) {
                throw CoreUtil.coreException((String)"Shell access is not available for \"%s\" connection", (Object[])new Object[]{this.getName()});
            }
            if (!system.isConnected()) {
                try {
                    system.uninitializeSubSystem((IProgressMonitor)new NullProgressMonitor());
                    system.disconnect();
                    system.connect((IProgressMonitor)mon, false);
                    this.shell = null;
                }
                catch (Exception e) {
                    throw CoreUtil.coreException((Throwable)e, (String)"Connection to \"%s\" failed", (Object[])new Object[]{this.getName()});
                }
            } else if (this.shell != null) {
                IRemoteShell iRemoteShell = this.shell;
                return iRemoteShell;
            }
            IRemoteShell iRemoteShell = this.shell = new RSERemoteShell(this, system.getShellService());
            return iRemoteShell;
        }
        finally {
            mon.done();
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String pref = this.getPreferenceName(name);
        if (value == null) {
            preferenceStore.setToDefault(pref);
        } else if (value instanceof String) {
            preferenceStore.setValue(pref, (String)value);
        } else if (value instanceof Integer) {
            preferenceStore.setValue(pref, ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            preferenceStore.setValue(pref, ((Boolean)value).booleanValue());
        } else {
            throw new ClassCastException(value.getClass().getName());
        }
    }

    public String toString() {
        return String.format("[RSE host: %s]", this.host.getAliasName());
    }

    @Override
    public ICudaToolkit updateToolkit(CudaToolkitWorkingCopy toolkit) {
        ICudaToolkit tk = this.store.save(toolkit);
        if (this.toolkitObserveable != null) {
            this.toolkitObserveable.invalidate();
        }
        return tk;
    }

    @Override
    public void upload(String localPath, String remotePath, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        this.clearFilesCache();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)85);
        IRemoteFile remoteFile = this.checkRemoteFileForWriting(remotePath, overwrite, (IProgressMonitor)subMonitor.newChild(15));
        IFileServiceSubSystem subsystem = (IFileServiceSubSystem)this.getSubsystem(IRemoteConnection.Service.Files);
        try {
            try {
                this.checkLocalFileForReading(localPath);
                IFileServiceSubSystem fileSubSytem = subsystem;
                IRemoteFile dir = remoteFile.getParentRemoteFile();
                if (!dir.exists()) {
                    fileSubSytem.createFolders(dir, (IProgressMonitor)subMonitor.newChild(15));
                }
                fileSubSytem.upload(localPath, remoteFile, null, (IProgressMonitor)subMonitor.newChild(45));
            }
            catch (SystemMessageException e) {
                throw CoreUtil.coreException((Throwable)e, (String)"Unable to upload file to remote system %s: %s", (Object[])new Object[]{this.getHostName(), e.getMessage()});
            }
        }
        finally {
            monitor.done();
        }
    }

    private IFilePermissionsService getPermissionsService() throws CoreException {
        IFileServiceSubSystem subsystem = (IFileServiceSubSystem)this.getSubsystem(IRemoteConnection.Service.Files);
        IFileService service = subsystem.getFileService();
        if (!(service instanceof IFilePermissionsService)) {
            throw CoreUtil.coreException((String)"Host \"%s\" is not capable of changing file permissions", (Object[])new Object[]{this.getHostName()});
        }
        return (IFilePermissionsService)service;
    }

    @Override
    public void setPermissions(String remotePath, int bitmask, boolean value, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        IFilePermissionsService permsService = this.getPermissionsService();
        IRemoteFile remoteFile = this.getRemoteFileObject(remotePath, true, (IProgressMonitor)subMonitor.newChild(5));
        IHostFile hostFile = remoteFile.getHostFile();
        if (!remoteFile.exists()) {
            throw CoreUtil.coreException((String)"Can not set permissions to non-existing file %s", (Object[])new Object[]{remotePath});
        }
        try {
            IHostFilePermissions permissions = permsService.getFilePermissions(hostFile, (IProgressMonitor)subMonitor.newChild(5));
            permissions.setPermission(bitmask, value);
            permsService.setFilePermissions(hostFile, permissions, (IProgressMonitor)subMonitor.newChild(5));
        }
        catch (SystemMessageException e) {
            throw CoreUtil.coreException((Throwable)e, (String)"Failed to set permissions to file %s", (Object[])new Object[]{remotePath});
        }
        monitor.done();
    }

    private final class ConnectionNameObservable
    extends AbstractObservableValue {
        private String value;

        public ConnectionNameObservable(Realm realm) {
            super(realm);
        }

        protected Object doGetValue() {
            this.value = RSERemoteConnection.this.internalGetName();
            return this.value;
        }

        public Object getValueType() {
            return String.class;
        }

        public void update() {
            final String newValue = RSERemoteConnection.this.internalGetName();
            if (this.value != null && !this.value.equals(newValue)) {
                final String oldValue = this.value;
                this.fireValueChange(new ValueDiff(){

                    public Object getNewValue() {
                        return newValue;
                    }

                    public Object getOldValue() {
                        return oldValue;
                    }
                });
            }
        }
    }

    private final class IsConnectedObservable
    extends AbstractObservableValue {
        private boolean connected;
        private final ISubSystem subsystem;

        public IsConnectedObservable(Realm realm, IRemoteConnection.Service service) {
            super(realm);
            try {
                this.subsystem = RSERemoteConnection.this.getSubsystem(service);
                this.connected = this.subsystem.isConnected();
            }
            catch (CoreException e) {
                throw new IllegalStateException(e);
            }
        }

        protected Object doGetValue() {
            this.connected = this.subsystem.isConnected();
            return this.connected;
        }

        public Object getValueType() {
            return Boolean.TYPE;
        }

        public void stateChanged() {
            final boolean newState = this.subsystem.isConnected();
            if (newState != this.connected) {
                this.connected = newState;
                this.fireValueChange(new ValueDiff(){

                    public Object getNewValue() {
                        return newState;
                    }

                    public Object getOldValue() {
                        return !newState;
                    }
                });
            }
        }
    }

    private final class ToolkitObserveable
    extends ComputedValue {
        private ToolkitObserveable() {
            super(ICudaToolkit.class);
        }

        protected Object calculate() {
            return RSERemoteConnection.this.getToolkit();
        }

        public void invalidate() {
            this.makeDirty();
        }
    }
}

