/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.connection;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.XmlUtil;
import com.nvidia.cuda.ide.remote.connection.CudaToolkitWorkingCopy;
import com.nvidia.cuda.ide.remote.internal.connection.Activator;
import com.nvidia.cuda.ide.remote.internal.connection.CudaToolkitImpl;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class CudaToolkitsStore {
    private static final String ATTR_BIN = "bin";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String ELEMENT_LIBRARY_PATH = "library-path";
    private static final String ELEMENT_TOOL = "tool";
    private static final String ELEMENT_TOOLKIT = "toolkit";
    private String id;
    private ICudaToolkit[] toolkits = null;

    private static File getFile(String id) {
        try {
            String string = URLEncoder.encode(id, "UTF-8");
            IPath path = Activator.getDefault().getStateLocation().append(string).addFileExtension("xml");
            return path.toFile();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public CudaToolkitsStore(String id) {
        this.id = id;
    }

    private ICudaToolkit fillId(CudaToolkitWorkingCopy toolkit, Map<String, ICudaToolkit> toolkits) {
        if (toolkit.getId() == null) {
            return new CudaToolkitImpl(this.generateUniqueId(toolkits), toolkit.getBinDirectory(), toolkit.getCustomizedToolPaths(), toolkit.getLibraryPath());
        }
        return null;
    }

    private String generateUniqueId(Map<String, ICudaToolkit> toolkits) {
        int i = toolkits.size() + 1;
        String toolkitId;
        while (toolkits.containsKey(toolkitId = String.valueOf(this.id) + i)) {
            ++i;
        }
        return toolkitId;
    }

    private synchronized Map<String, ICudaToolkit> getAllToolkits() {
        HashMap<String, ICudaToolkit> result = new HashMap<String, ICudaToolkit>();
        Document document = this.getPersistentDocument();
        if (document != null) {
            for (Element element : XmlUtil.iter((Element)document.getDocumentElement(), (String)ELEMENT_TOOLKIT)) {
                ICudaToolkit toolkit = this.readToolkit(element);
                result.put(toolkit.getId(), toolkit);
            }
        }
        return result;
    }

    private Document getPersistentDocument() {
        File file = CudaToolkitsStore.getFile(this.id);
        if (file.isFile()) {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            }
            catch (SAXException e) {
                new RuntimeException(e);
            }
            catch (IOException e) {
                new RuntimeException(e);
            }
            catch (ParserConfigurationException e) {
                new RuntimeException(e);
            }
        }
        return null;
    }

    public ICudaToolkit getToolkit(String toolkitId) {
        return this.getAllToolkits().get(toolkitId);
    }

    public ICudaToolkit[] getToolkits() {
        if (this.toolkits == null) {
            this.toolkits = this.getAllToolkits().values().toArray(new ICudaToolkit[0]);
        }
        return this.toolkits;
    }

    private ICudaToolkit readToolkit(Element toolkitXml) {
        String id = toolkitXml.getAttribute(ATTR_ID).trim();
        String binDirectory = toolkitXml.getAttribute(ATTR_BIN).trim();
        HashMap<ICudaToolkit.Tool, String> tools = new HashMap<ICudaToolkit.Tool, String>();
        for (Element element : XmlUtil.iter((Element)toolkitXml, (String)ELEMENT_TOOL)) {
            tools.put(ICudaToolkit.Tool.valueOf((String)element.getAttribute(ATTR_NAME).trim()), element.getAttribute(ATTR_PATH.trim()));
        }
        String[] libraryPaths = XmlUtil.getStringList((Element)toolkitXml, (String)ELEMENT_LIBRARY_PATH, (String)ATTR_PATH);
        return new CudaToolkitImpl(id, binDirectory, tools, libraryPaths);
    }

    public void rename(String newId) throws CoreException {
        if (!CoreUtil.equals((Object)this.id, (Object)newId)) {
            File newFile = CudaToolkitsStore.getFile(newId);
            if (newFile.isDirectory()) {
                throw CoreUtil.coreException((String)"%s exists and is a folder", (Object[])new Object[]{newFile.getAbsolutePath()});
            }
            File original = CudaToolkitsStore.getFile(this.id);
            if (original.exists()) {
                if (!original.renameTo(newFile)) {
                    throw CoreUtil.coreException((String)"Unable to rename toolkit store from %s to %s", (Object[])new Object[]{original.getAbsolutePath(), newFile.getAbsolutePath()});
                }
            } else if (newFile.exists() && !newFile.delete()) {
                throw CoreUtil.coreException((String)"Unable to delete %s", (Object[])new Object[]{newFile.getAbsoluteFile()});
            }
            this.id = newId;
        }
    }

    public synchronized ICudaToolkit save(CudaToolkitWorkingCopy toolkit) {
        this.toolkits = null;
        Map<String, ICudaToolkit> toolkits = this.getAllToolkits();
        CudaToolkitWorkingCopy toPersist = toolkit.getId() == null ? this.fillId(toolkit, toolkits) : toolkit;
        toolkits.put(toolkit.getId(), toPersist);
        this.save(toolkits);
        return toolkit;
    }

    private void save(Map<String, ICudaToolkit> toolkits) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = document.createElement("toolkits");
            for (ICudaToolkit toolkit : toolkits.values()) {
                element.appendChild(this.toXml(toolkit, document));
            }
            document.appendChild(element);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(CudaToolkitsStore.getFile(this.id)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Element toXml(ICudaToolkit toolkit, Document document) {
        Element element = document.createElement(ELEMENT_TOOLKIT);
        element.setAttribute(ATTR_ID, toolkit.getId());
        element.setAttribute(ATTR_BIN, toolkit.getBinDirectory());
        Object[] objectArray = ICudaToolkit.Tool.values();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICudaToolkit.Tool tool = objectArray[n2];
            String path = toolkit.getToolPath(tool);
            if (!CoreUtil.equals((Object)path, (Object)toolkit.getDefaultToolPath(tool))) {
                Element toolElement = document.createElement(ELEMENT_TOOL);
                toolElement.setAttribute(ATTR_NAME, tool.name());
                toolElement.setAttribute(ATTR_PATH, path);
                element.appendChild(toolElement);
            }
            ++n2;
        }
        objectArray = toolkit.getLibraryPath();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            ICudaToolkit.Tool path = objectArray[n2];
            Element libraryPath = document.createElement(ELEMENT_LIBRARY_PATH);
            libraryPath.setAttribute(ATTR_PATH, (String)path);
            element.appendChild(libraryPath);
            ++n2;
        }
        return element;
    }
}

