/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.AbstractGDBCDIDebugger;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MICoreUtils;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CLITargetAttach;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetNewConsole;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBCDIDebugger2
extends AbstractGDBCDIDebugger {
    @Override
    protected String[] getExtraArguments(ILaunchConfiguration config) throws CoreException {
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if ("run".equals(debugMode)) {
            return this.getRunArguments(config);
        }
        if ("attach".equals(debugMode)) {
            return this.getAttachArguments(config);
        }
        if ("core".equals(debugMode)) {
            return this.getCoreArguments(config);
        }
        return new String[0];
    }

    protected String[] getRunArguments(ILaunchConfiguration config) throws CoreException {
        return new String[]{this.getWorkingDirectory(config), this.getCommandFile(config)};
    }

    protected String[] getAttachArguments(ILaunchConfiguration config) throws CoreException {
        return new String[]{this.getWorkingDirectory(config), this.getCommandFile(config)};
    }

    protected String[] getCoreArguments(ILaunchConfiguration config) throws CoreException {
        Path coreFile = new Path(config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null));
        return new String[]{this.getWorkingDirectory(config), this.getCommandFile(config), "-c", coreFile.toFile().getAbsolutePath()};
    }

    @Override
    protected CommandFactory getCommandFactory(ILaunchConfiguration config) throws CoreException {
        String factoryID = MIPlugin.getCommandFactory(config);
        CommandFactory factory = MIPlugin.getDefault().getCommandFactoryManager().getCommandFactory(factoryID);
        String miVersion = this.getMIVersion(config);
        if (factory != null) {
            factory.setMIVersion(miVersion);
        }
        return factory != null ? factory : new CommandFactory(miVersion);
    }

    public static IPath getProjectPath(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IPath p;
        String projectName = GDBCDIDebugger2.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (p = (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).getLocation()) != null) {
            return p;
        }
        return Path.EMPTY;
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    protected String getMIVersion(ILaunchConfiguration config) {
        return MIPlugin.getMIVersion(config);
    }

    @Override
    protected void doStartSession(ILaunch launch, Session session, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        this.setAsyncMode(config, session);
        this.initializeLibraries(config, session);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if ("run".equals(debugMode)) {
            this.startLocalGDBSession(config, session, monitor);
        }
        if ("attach".equals(debugMode)) {
            this.startAttachGDBSession(config, session, monitor);
        }
        if ("core".equals(debugMode)) {
            this.startCoreGDBSession(config, session, monitor);
        }
    }

    protected void startLocalGDBSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        MISession miSession = this.getMISession(session);
        try {
            CommandFactory factory = miSession.getCommandFactory();
            MIGDBSetNewConsole newConsole = factory.createMIGDBSetNewConsole();
            miSession.postCommand(newConsole);
            MIInfo info = newConsole.getMIInfo();
            if (info == null) {
                throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
            }
        }
        catch (MIException mIException) {}
    }

    protected void startAttachGDBSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        MISession miSession = this.getMISession(session);
        CommandFactory factory = miSession.getCommandFactory();
        int pid = -1;
        try {
            pid = config.getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
        }
        catch (CoreException e) {
            throw this.newCoreException(MIPlugin.getResourceString("src.GDBCDIDebugger2.0"), e);
        }
        if (pid <= 0) {
            throw this.newCoreException(MIPlugin.getResourceString("src.GDBCDIDebugger2.1"), null);
        }
        try {
            CLITargetAttach attach = factory.createCLITargetAttach(pid);
            miSession.postCommand(attach);
            MIInfo info = attach.getMIInfo();
            if (info == null) {
                throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
            }
            miSession.getMIInferior().setInferiorPID(pid);
            miSession.getMIInferior().setConnected();
        }
        catch (MIException e) {
            throw this.newCoreException(MessageFormat.format((String)MIPlugin.getResourceString("src.GDBCDIDebugger2.2"), (Object[])new Integer[]{new Integer(pid)}), e);
        }
        miSession.getMIInferior().setSuspended();
        miSession.getMIInferior().update();
    }

    protected void startCoreGDBSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        this.getMISession(session).getMIInferior().setSuspended();
        try {
            session.getSharedLibraryManager().update();
        }
        catch (CDIException e) {
            throw this.newCoreException(e);
        }
    }

    protected MISession getMISession(Session session) {
        ICDITarget[] targets = session.getTargets();
        if (targets.length == 0 || !(targets[0] instanceof Target)) {
            return null;
        }
        return ((Target)targets[0]).getMISession();
    }

    protected void initializeLibraries(ILaunchConfiguration config, Session session) throws CoreException {
        try {
            SharedLibraryManager sharedMgr = session.getSharedLibraryManager();
            boolean autolib = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
            boolean stopOnSolibEvents = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
            List p = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST);
            ICDITarget[] dtargets = session.getTargets();
            int i = 0;
            while (i < dtargets.length) {
                Target target = (Target)dtargets[i];
                try {
                    sharedMgr.setAutoLoadSymbols(target, autolib);
                    sharedMgr.setStopOnSolibEvents(target, stopOnSolibEvents);
                    sharedMgr.setDeferredBreakpoint(target, false);
                    if (autolib && !stopOnSolibEvents) {
                        sharedMgr.setStopOnSolibEvents(target, true);
                        sharedMgr.setDeferredBreakpoint(target, true);
                    }
                }
                catch (CDIException cDIException) {}
                if (p.size() > 0) {
                    String[] oldPaths = sharedMgr.getSharedLibraryPaths(target);
                    String[] paths = new String[oldPaths.length + p.size()];
                    System.arraycopy(p.toArray(new String[p.size()]), 0, paths, 0, p.size());
                    System.arraycopy(oldPaths, 0, paths, p.size(), oldPaths.length);
                    sharedMgr.setSharedLibraryPaths(target, paths);
                }
                File[] autoSolibs = MICoreUtils.getAutoSolibs(config);
                ArrayList<File> libs = new ArrayList<File>(autoSolibs.length);
                int j = 0;
                while (j < autoSolibs.length) {
                    libs.add(new File(autoSolibs[j].getName()));
                    ++j;
                }
                sharedMgr.autoLoadSymbols(libs.toArray(new File[libs.size()]));
                if (!autolib && !stopOnSolibEvents) {
                    sharedMgr.setDeferredBreakpoint(target, libs.size() > 0);
                }
                ++i;
            }
        }
        catch (CDIException e) {
            throw this.newCoreException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_initializing_shared_lib_options")) + e.getMessage(), e);
        }
    }

    protected String getWorkingDirectory(ILaunchConfiguration config) throws CoreException {
        String expandedLocation;
        IPath path = null;
        String location = config.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            path = new Path(expandedLocation);
        }
        if (path == null) {
            path = GDBCDIDebugger2.getProjectPath(config);
        }
        CommandFactory factory = this.getCommandFactory(config);
        return factory.getWorkingDirectory(path.toFile());
    }

    protected String getCommandFile(ILaunchConfiguration config) throws CoreException {
        String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
        return gdbinit != null && gdbinit.length() > 0 ? "--command=" + gdbinit : "--nx";
    }

    private void setAsyncMode(ILaunchConfiguration config, Session session) throws CoreException {
        ICDITarget[] dtargets = session.getTargets();
        int i = 0;
        while (i < dtargets.length) {
            MISession miSession = ((Target)dtargets[i]).getMISession();
            try {
                MIGDBSet setAsyncMode = miSession.getCommandFactory().createMIGDBSet(new String[]{"target-async", "0"});
                miSession.postCommand(setAsyncMode);
                MIInfo info = setAsyncMode.getMIInfo();
                if (info == null) {
                    throw this.newCoreException(new CDIException(CdiResources.getString("cdi.Common.No_answer")));
                }
            }
            catch (MIException mIException) {}
            ++i;
        }
    }
}

