/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.chart;

import com.nvidia.viper.chart.IColorDefinitionsManager;
import com.nvidia.viper.chart.ui.AxesConfiguration;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.ViperChartSeries;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.ExtendedProperty;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.AxisOriginImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Grid;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.component.impl.MarkerLineImpl;
import org.eclipse.birt.chart.model.component.impl.MarkerRangeImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.StockDataSet;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.StockDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.swt.widgets.Display;

public class BirtChartFactory {
    public static final int FONT_HLABELS = -2;
    protected static BirtChartFactory instance;

    public static Chart createBirtChart(IViperChart chart, IColorDefinitionsManager manager) {
        BirtChartFactory birtChartFactoryInstance = BirtChartFactory.instance();
        return birtChartFactoryInstance.createBirtChartHelper(chart, manager);
    }

    protected static synchronized BirtChartFactory instance() {
        if (instance == null) {
            instance = new BirtChartFactory();
        }
        return instance;
    }

    protected BirtChartFactory() {
    }

    protected void addProperty(Chart birtChart, String propertyName, String propertyValue) {
        ExtendedProperty property = AttributeFactory.eINSTANCE.createExtendedProperty();
        property.setName(propertyName);
        property.setValue(propertyValue);
        birtChart.getExtendedProperties().add((Object)property);
    }

    protected void configureAxisStyle(Axis axis, Integer max, Integer step, IColorDefinitionsManager manager) {
        axis.setLineAttributes(LineAttributesImpl.create((ColorDefinition)manager.getColor(IColorDefinitionsManager.ChartColor.AXIS), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        Label label = axis.getLabel();
        Text caption = label.getCaption();
        caption.getFont().setSize((float)(this.getSystemFontHeight() + -2));
        caption.setColor(manager.getColor(IColorDefinitionsManager.ChartColor.AXIS));
        axis.setOrigin(AxisOriginImpl.create((IntersectionType)IntersectionType.VALUE_LITERAL, (DataElement)NumberDataElementImpl.create((double)0.0)));
        Scale scale = axis.getScale();
        scale.setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        if (max != null) {
            scale.setMax((DataElement)NumberDataElementImpl.create((double)max.intValue()));
        }
        if (step != null) {
            scale.setStep((double)step.intValue());
        }
        scale.setShowOutside(false);
    }

    protected Chart createBirtChartHelper(IViperChart chart, IColorDefinitionsManager manager) {
        String[] labels;
        Chart birtChart = this.createChartObject(chart, manager);
        birtChart.getBlock().setInsets(InsetsImpl.create((double)0.0, (double)0.0, (double)0.0, (double)10.0));
        ColorDefinition definition = manager.getColor(chart.isHighlighted() ? IColorDefinitionsManager.ChartColor.HIGHLIGHTED_BACKGROUND : IColorDefinitionsManager.ChartColor.BACKGROUND);
        birtChart.getBlock().setBackground((Fill)definition);
        birtChart.getPlot().getClientArea().setBackground((Fill)manager.getColor(IColorDefinitionsManager.ChartColor.BACKGROUND));
        Legend legend = birtChart.getLegend();
        legend.getText().getFont().setSize((float)(this.getSystemFontHeight() - 2));
        legend.setVisible(chart.showLegend());
        this.setChartCaption(birtChart, chart);
        this.addProperty(birtChart, "viper.color.by.series", String.valueOf(chart.colorBySeries()));
        AxesConfiguration axesConfiguration = chart.getAxesConfiguration();
        if (axesConfiguration != null && (labels = axesConfiguration.yLabels) != null) {
            this.addProperty(birtChart, "viper.yaxis.labels", this.packStringArray(labels));
        }
        this.addProperty(birtChart, "viper.font.height", String.valueOf(this.getSystemFontHeight()));
        return birtChart;
    }

    protected Chart createChartObject(IViperChart chart, IColorDefinitionsManager manager) {
        AxesConfiguration axesConfiguration = chart.getAxesConfiguration();
        if (axesConfiguration != null) {
            ChartWithAxes birtChart = ChartWithAxesImpl.create();
            this.setupAxes(birtChart, chart, axesConfiguration, manager);
            return birtChart;
        }
        ChartWithoutAxes birtChart = ChartWithoutAxesImpl.create();
        this.setupNoAxesChart((ChartWithoutAxesImpl)birtChart, chart, manager);
        return birtChart;
    }

    protected Series createLabelSeriesWithData(DataSet ds) {
        Series series = SeriesImpl.create();
        series.setDataSet(ds);
        return series;
    }

    protected LineSeries createLineSeries(ViperChartSeries series) {
        LineSeries ls1 = (LineSeries)LineSeriesImpl.create();
        Double[] values = series.getValues();
        NumberDataSet orthoValues1 = NumberDataSetImpl.create((Object)values);
        ls1.setDataSet((DataSet)orthoValues1);
        ls1.getMarkers().clear();
        ls1.getLabel().setVisible(false);
        return ls1;
    }

    protected void createMarkerLine(Axis axis, int postion, String label, IColorDefinitionsManager manager) {
        MarkerLine line = MarkerLineImpl.create((Axis)axis, (DataElement)NumberDataElementImpl.create((double)postion));
        line.setLabelAnchor(Anchor.SOUTH_LITERAL);
        ColorDefinition color = manager.getColor(IColorDefinitionsManager.ChartColor.MINOR_GRID_TICKS);
        color.setTransparency(150);
        line.setLineAttributes(LineAttributesImpl.create((ColorDefinition)color, (LineStyle)LineStyle.DASHED_LITERAL, (int)1));
        Label l = line.getLabel();
        Text caption = l.getCaption();
        caption.setValue(label);
        caption.setColor(manager.getColor(IColorDefinitionsManager.ChartColor.AXIS));
        JavaNumberFormatSpecifier format = JavaNumberFormatSpecifierImpl.create((String)"####0");
        line.setFormatSpecifier((FormatSpecifier)format);
        FontDefinition font = caption.getFont();
        font.setRotation(0.0);
        font.setSize((float)(this.getSystemFontHeight() + -2));
        l.setInsets(InsetsImpl.create((double)0.0, (double)0.0, (double)(-this.getSystemFontHeight()), (double)0.0));
    }

    protected PieSeries createPieSeries(ViperChartSeries series, IColorDefinitionsManager manager) {
        PieSeries pie = (PieSeries)PieSeriesImpl.create();
        Double[] values = series.getValues();
        NumberDataSet orthoValues1 = NumberDataSetImpl.create((Object)values);
        pie.setDataSet((DataSet)orthoValues1);
        Label label = pie.getLabel();
        Text caption = label.getCaption();
        caption.getFont().setSize((float)(this.getSystemFontHeight() - 2));
        pie.setLeaderLineStyle(LeaderLineStyle.FIXED_LENGTH_LITERAL);
        DataPoint dp = pie.getDataPoint();
        dp.getComponents().clear();
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.BASE_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0")));
        return pie;
    }

    protected ScatterSeries createScatterSeries(ViperChartSeries series) {
        ScatterSeries ss = (ScatterSeries)ScatterSeriesImpl.create();
        ss.setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.SOLID_LITERAL, (int)3));
        ss.setTranslucent(true);
        int i = 0;
        while (i < ss.getMarkers().size()) {
            Marker marker = (Marker)ss.getMarkers().get(i);
            marker.setType(MarkerType.CIRCLE_LITERAL);
            marker.setSize(2);
            ++i;
        }
        DataPoint dp = ss.getDataPoint();
        dp.getComponents().clear();
        dp.setSeparator(" @ ");
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0")));
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.BASE_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0")));
        ss.getLabel().getCaption().setColor(ColorDefinitionImpl.BLACK());
        ss.getLabel().getCaption().getFont().setSize((float)(this.getSystemFontHeight() - 3));
        ss.getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.CREAM(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        ss.getLabel().setVisible(true);
        ss.setLabelPosition(Position.BELOW_LITERAL);
        ss.setDataSet((DataSet)NumberDataSetImpl.create((Object)series.getValues()));
        return ss;
    }

    protected Series createSeries(ViperChartSeries series, IColorDefinitionsManager colorManager) {
        switch (series.getType()) {
            case LINE: {
                return this.createLineSeries(series);
            }
            case SCATTER: {
                return this.createScatterSeries(series);
            }
            case PIE: {
                return this.createPieSeries(series, colorManager);
            }
            case STACKED_BAR: {
                return this.createStackedBarSeries(series);
            }
        }
        throw new IllegalArgumentException(series.getType().toString());
    }

    protected SeriesDefinition createSeriesDefinition(IViperChart chart, IColorDefinitionsManager colorManager) {
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(4);
        ViperChartSeries[] viperChartSeriesArray = chart.getSeries();
        int n = viperChartSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViperChartSeries series = viperChartSeriesArray[n2];
            Series ls1 = this.createSeries(series, colorManager);
            sdY.getSeries().add((Object)ls1);
            ++n2;
        }
        return sdY;
    }

    protected BarSeries createStackedBarSeries(ViperChartSeries series) {
        BarSeries barSeries = (BarSeries)BarSeriesImpl.create();
        String title = series.getTitle();
        if (title != null) {
            barSeries.setSeriesIdentifier((Object)title);
        }
        barSeries.setStacked(true);
        barSeries.setDataSet((DataSet)NumberDataSetImpl.create((Object)series.getValues()));
        return barSeries;
    }

    protected int getSystemFontHeight() {
        return Display.getDefault().getSystemFont().getFontData()[0].getHeight();
    }

    protected String packStringArray(String[] labels) {
        StringBuilder builder = new StringBuilder("||");
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            builder.append(label == null ? "" : label).append("||");
            ++n2;
        }
        return builder.toString();
    }

    protected void setAxisLabel(Axis axis, String label) {
        if (label != null) {
            Label axisLabel = LabelImpl.create();
            Text caption = TextImpl.create((String)label);
            FontDefinition font = caption.getFont();
            font.setSize((float)this.getSystemFontHeight());
            axisLabel.setCaption(caption);
            axisLabel.setVisible(true);
            axis.setTitle(axisLabel);
            boolean isHorizontal = axis.getOrientation() == Orientation.HORIZONTAL_LITERAL;
            axisLabel.setInsets(InsetsImpl.create((double)(isHorizontal ? 15 : 0), (double)0.0, (double)(isHorizontal ? 0 : 15), (double)0.0));
        }
    }

    protected void setChartCaption(Chart chart, IViperChart viperChart) {
        String title = viperChart.getTitle();
        Text caption = chart.getTitle().getLabel().getCaption();
        caption.setValue(title == null ? "" : title);
        caption.getFont().setSize((float)(this.getSystemFontHeight() + 2));
    }

    protected void setupAlteratingBackground(AxesConfiguration chart, Axis axis, ColorDefinition color) {
        Integer step = chart.yGuidesStep;
        if (step != null) {
            int i = 0;
            while (i < chart.yMax) {
                MarkerRange markerRange = MarkerRangeImpl.create((Axis)axis, (DataElement)NumberDataElementImpl.create((double)(chart.yMax - i - step)), (DataElement)NumberDataElementImpl.create((double)(chart.yMax - i)), (Fill)color.copyInstance(), (ColorDefinition)ColorDefinitionImpl.TRANSPARENT());
                markerRange.getLabel().setVisible(false);
                i += step * 2;
            }
        }
    }

    protected void setupAxes(ChartWithAxes axisChart, IViperChart chart, AxesConfiguration axisConfiguration, IColorDefinitionsManager manager) {
        SeriesDefinition sd = this.createSeriesDefinition(chart, manager);
        Axis xaxis = axisChart.getPrimaryBaseAxes()[0];
        this.setupXAxis(axisConfiguration, xaxis, manager, chart.getLabels());
        this.setupYAxis(axisChart.getPrimaryOrthogonalAxis(xaxis), axisConfiguration, manager, sd);
    }

    protected void setupNoAxesChart(ChartWithoutAxesImpl chartWithoutAxes, IViperChart chart, IColorDefinitionsManager manager) {
        SeriesDefinition seriesDefinition = this.createSeriesDefinition(chart, manager);
        TextDataSet ds = TextDataSetImpl.create((Object)chart.getLabels());
        Series series = this.createLabelSeriesWithData((DataSet)ds);
        SeriesDefinition sd = SeriesDefinitionImpl.create();
        sd.getSeries().add((Object)series);
        sd.getSeriesDefinitions().add((Object)seriesDefinition);
        chartWithoutAxes.getSeriesDefinitions().add((Object)sd);
    }

    protected void setupXAxis(AxesConfiguration chart, Axis axis, IColorDefinitionsManager manager, String[] labels) {
        axis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.setAxisLabel(axis, chart.xTitle);
        String[] seriesPoints = labels;
        StockDataSet categoryValues = StockDataSetImpl.create((Object)seriesPoints);
        Series seCategory = this.createLabelSeriesWithData((DataSet)categoryValues);
        seCategory.setLabelPosition(Position.ABOVE_LITERAL);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.getSeries().add((Object)seCategory);
        axis.getSeriesDefinitions().add((Object)sdX);
        this.configureAxisStyle(axis, null, null, manager);
        axis.getLabel().setVisible(chart.showXAxisLabels);
        axis.getMajorGrid().setTickAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.TRANSPARENT(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        Integer verticalLineStep = chart.xGuidesStep;
        if (verticalLineStep != null && verticalLineStep > 0) {
            int firstLineOffset = chart.isZeroBased ? 0 : -1;
            int i = verticalLineStep + firstLineOffset;
            while (i < seriesPoints.length - 1) {
                this.createMarkerLine(axis, i, seriesPoints[i], manager);
                i += verticalLineStep.intValue();
            }
            this.createMarkerLine(axis, seriesPoints.length + firstLineOffset, seriesPoints[seriesPoints.length - 1], manager);
        }
    }

    protected void setupYAxis(Axis axis, AxesConfiguration axisConfiguration, IColorDefinitionsManager manager, SeriesDefinition sdY) {
        axis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.setAxisLabel(axis, axisConfiguration.yTitle);
        this.configureAxisStyle(axis, axisConfiguration.yMax, axisConfiguration.yStep, manager);
        Grid majorGrid = axis.getMajorGrid();
        if (axisConfiguration.showYAxisTicks) {
            majorGrid.setTickStyle(TickStyle.ACROSS_LITERAL);
            majorGrid.setTickAttributes(LineAttributesImpl.create((ColorDefinition)manager.getColor(IColorDefinitionsManager.ChartColor.AXIS), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            majorGrid.setTickSize(0.0);
            axis.getScale().setMinorGridsPerUnit(4);
            Grid minorGrid = axis.getMinorGrid();
            minorGrid.setTickAttributes(LineAttributesImpl.create((ColorDefinition)manager.getColor(IColorDefinitionsManager.ChartColor.MINOR_GRID_TICKS), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            minorGrid.setTickStyle(TickStyle.LEFT_LITERAL);
        } else {
            majorGrid.setTickAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.TRANSPARENT(), (LineStyle)LineStyle.SOLID_LITERAL, (int)0));
        }
        axis.getSeriesDefinitions().add((Object)sdY);
        if (axisConfiguration.yMax != null) {
            this.setupAlteratingBackground(axisConfiguration, axis, manager.getColor(IColorDefinitionsManager.ChartColor.H_GUIDES));
        }
    }
}

