/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard.samples;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.samples.ImportCUDASample;
import com.nvidia.cuda.ide.util.BasicUtil;
import com.nvidia.cuda.ide.wizard.samples.PlatformSpecificValue;
import com.nvidia.cuda.ide.wizard.samples.SamplesCategory;
import com.nvidia.cuda.ide.wizard.samples.SamplesModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ProjectSample
implements Comparable<ProjectSample> {
    private static final String[] NO_KEYWORDS = new String[0];
    private static final String[] SAMPLE_DIRS = new String[]{"data", "boost"};
    private static final Pattern SM_VERSION_PATTERN = Pattern.compile("^sm(\\d)(\\d)$");
    private final SamplesCategory category;
    private final Architecture cudaSpecs;
    private final String description;
    private final File file;
    private final Map<IPath, File> files;
    private final PlatformSpecificValue<String>[] frameworks;
    private final PlatformSpecificValue<String>[] includePaths;
    private final String[] keywords;
    private final PlatformSpecificValue<String>[] libraries;
    private final PlatformSpecificValue<String>[] libraryPaths;
    private final String name;
    private final boolean nsightCompatible;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Boolean sepCompilation;
    private final PlatformSpecificValue<?>[] supportedEnvironments;
    private final File whitepaper;
    private boolean needsOpenMP;

    private static void addAllFiles(HashMap<IPath, File> map, IPath baseName, File dir) {
        File[] listFiles;
        File[] fileArray = listFiles = dir.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IPath child = baseName.append(file.getName());
            if (file.isDirectory()) {
                ProjectSample.addAllFiles(map, child, file);
            } else if (file.isFile()) {
                map.put(child.makeRelative(), file);
            }
            ++n2;
        }
    }

    private static void addFilesFromManifest(File infofile, Document document, Map<IPath, File> result) throws IOException {
        NodeList files = document.getElementsByTagName("files");
        File sampleRoot = infofile.getParentFile().getCanonicalFile();
        int i = 0;
        while (i < files.getLength()) {
            Node fs = files.item(i);
            NodeList childNodes = fs.getChildNodes();
            int j = 0;
            while (j < childNodes.getLength()) {
                Node child = childNodes.item(j);
                if (child.getNodeType() == 1 && "file".equals(child.getNodeName())) {
                    String path = child.getTextContent();
                    ProjectSample.addIfExists(result, path, sampleRoot);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void addIfExists(Map<IPath, File> result, String path, File sampleRoot) throws IOException {
        IPath filePath;
        File f;
        if (!BasicUtil.isNullOrEmpty(path) && (f = new File(sampleRoot, (filePath = new Path(path.replace("\\", "/")).makeRelative()).toOSString())).isFile()) {
            Path dataFilePath;
            Path samplePath = new Path(sampleRoot.getCanonicalPath());
            if (samplePath.isPrefixOf((IPath)(dataFilePath = new Path(f.getCanonicalPath())))) {
                result.put(dataFilePath.removeFirstSegments(samplePath.segmentCount()).makeRelative(), f);
            } else {
                result.put((IPath)new Path(f.getName()), f);
            }
        }
    }

    private static String[] filter(PlatformSpecificValue<String>[] vals, String os, String arch) {
        if (BasicUtil.isNullOrEmpty(vals)) {
            return new String[0];
        }
        TreeSet<String> paths = new TreeSet<String>();
        PlatformSpecificValue<String>[] platformSpecificValueArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            PlatformSpecificValue<String> value = platformSpecificValueArray[n2];
            if (value.compatible(os, arch)) {
                paths.add((String)value.payload);
            }
            ++n2;
        }
        return paths.toArray(new String[paths.size()]);
    }

    private static Architecture getArch(String string) throws IOException {
        Matcher matcher = SM_VERSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IOException(String.format("Illegal sample SM version specification: %s", string));
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        return Architecture.get(Integer.valueOf(major), Integer.valueOf(minor));
    }

    private static Architecture getCudaSpecs(Document document) throws IOException {
        Object[] strings = BasicUtil.getXMLStrings(document, "sm-arch");
        if (BasicUtil.isNullOrEmpty(strings)) {
            return Architecture.get(1, 0);
        }
        return ProjectSample.getArch((String)strings[0]);
    }

    private static Map<IPath, File> getFiles(File infofile, Document document) {
        HashMap<IPath, File> result = new HashMap<IPath, File>();
        String[] stringArray = SAMPLE_DIRS;
        int n = SAMPLE_DIRS.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            result.putAll(ProjectSample.getFiles(infofile, dir));
            ++n2;
        }
        try {
            ProjectSample.addFilesFromManifest(infofile, document, result);
        }
        catch (IOException e) {
            Activator.log(e);
        }
        return result;
    }

    private static Map<IPath, File> getFiles(File infofile, String dir) {
        File dataDir = new File(infofile.getParentFile(), dir);
        if (dataDir.isDirectory()) {
            HashMap<IPath, File> files = new HashMap<IPath, File>();
            ProjectSample.addAllFiles(files, (IPath)new Path(dataDir.getName()), dataDir);
            return files;
        }
        return Collections.emptyMap();
    }

    private static PlatformSpecificValue<String>[] getPaths(Document document, File infofile, String elementName) throws DOMException, IOException {
        HashSet<PlatformSpecificValue<String>> values = new HashSet<PlatformSpecificValue<String>>();
        NodeList elements = document.getElementsByTagName(elementName);
        int i = 0;
        while (i < elements.getLength()) {
            Element element = (Element)elements.item(i);
            String path = ProjectSample.resolvePath(infofile.getParentFile(), element.getTextContent());
            if (path != null) {
                values.add(new PlatformSpecificValue<String>(element.getAttribute("os"), element.getAttribute("arch"), path));
            }
            ++i;
        }
        return values.toArray(new PlatformSpecificValue[values.size()]);
    }

    private static File getWhitepaper(File infofile, String path) {
        if (BasicUtil.isNullOrEmpty(path)) {
            return null;
        }
        File file = new File(infofile.getParentFile(), path.trim().replace('\\', '/'));
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    private static boolean isNsightCompatible(Document document) {
        return document.getElementsByTagName("no-nsight-eclipse").getLength() == 0;
    }

    private static boolean usesOpenMP(Document document) {
        String[] stringArray = ProjectSample.getKeywords(document);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if ("openmp".equalsIgnoreCase(keyword)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSm35OrNewer(Architecture cudaSpecs) {
        return cudaSpecs.compareTo(Architecture.get(3, 5)) >= 0;
    }

    private static PlatformSpecificValue<?>[] readEnvironments(String string) {
        HashSet<PlatformSpecificValue<Object>> env = new HashSet<PlatformSpecificValue<Object>>();
        if (BasicUtil.isNullOrEmpty(string)) {
            env.add(new PlatformSpecificValue<Object>(null, null, null));
        } else {
            String[] split;
            String[] stringArray = split = string.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!BasicUtil.isNullOrEmpty(s)) {
                    env.add(PlatformSpecificValue.fromString(s, null));
                }
                ++n2;
            }
        }
        return env.toArray(new PlatformSpecificValue[env.size()]);
    }

    private static PlatformSpecificValue<String>[] readLibraries(Document document, boolean gatherFrameworks) throws IOException {
        HashSet<PlatformSpecificValue<String>> values = new HashSet<PlatformSpecificValue<String>>();
        NodeList elements = document.getElementsByTagName("library");
        int i = 0;
        while (i < elements.getLength()) {
            Element element = (Element)elements.item(i);
            String path = BasicUtil.nullIfEmpty(element.getTextContent());
            String framework = BasicUtil.nullIfEmpty(element.getAttribute("framework"));
            if (path != null && gatherFrameworks == "true".equalsIgnoreCase(framework)) {
                values.add(new PlatformSpecificValue<String>(element.getAttribute("os"), element.getAttribute("arch"), path));
            }
            ++i;
        }
        return values.toArray(new PlatformSpecificValue[values.size()]);
    }

    private static String resolvePath(File parentFile, String path) throws IOException {
        if (BasicUtil.isNullOrEmpty(path)) {
            return null;
        }
        File loc = new File(parentFile, path.trim());
        if (loc.exists() && !loc.getCanonicalFile().equals(parentFile.getCanonicalFile())) {
            return loc.getCanonicalPath();
        }
        return null;
    }

    public ProjectSample(File infofile) throws CoreException {
        this(null, infofile);
    }

    public ProjectSample(SamplesModel model, File infofile) throws CoreException {
        this.file = infofile;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = builder.parse(this.file.toURI().toASCIIString());
            this.name = BasicUtil.getXmlText(document, "name");
            this.description = BasicUtil.getXmlText(document, "description");
            this.cudaSpecs = ProjectSample.getCudaSpecs(document);
            this.category = model == null ? null : this.parseCategories(model, infofile);
            this.whitepaper = ProjectSample.getWhitepaper(infofile, BasicUtil.getXmlText(document, "whitepaper"));
            this.keywords = ProjectSample.getKeywords(document);
            this.supportedEnvironments = ProjectSample.readEnvironments(BasicUtil.getXmlText(document, "supported-env"));
            this.includePaths = ProjectSample.getPaths(document, infofile, "include-path");
            this.libraryPaths = ProjectSample.getPaths(document, infofile, "library-path");
            this.libraries = ProjectSample.readLibraries(document, false);
            this.frameworks = ProjectSample.readLibraries(document, true);
            this.needsOpenMP = ProjectSample.usesOpenMP(document);
            String linker = BasicUtil.getXmlText(document, "devicecompilation");
            this.sepCompilation = "separate".equals(linker) ? Boolean.TRUE : ("whole".equals(linker) ? Boolean.FALSE : ProjectSample.isSm35OrNewer(this.cudaSpecs));
            this.files = ProjectSample.getFiles(infofile, document);
            this.nsightCompatible = ProjectSample.isNsightCompatible(document);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.build", String.format("Unable to parse %s", this.file), (Throwable)e));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public int compareTo(ProjectSample o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean compatible(String os, String arch) {
        PlatformSpecificValue<?>[] vals;
        PlatformSpecificValue<?>[] platformSpecificValueArray = vals = this.supportedEnvironments;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            PlatformSpecificValue<?> psv = platformSpecificValueArray[n2];
            if (psv.compatible(os, arch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectSample)) {
            return false;
        }
        ProjectSample other = (ProjectSample)obj;
        return BasicUtil.sameObject(this.file, other.file);
    }

    public int[] getDefaultArchitectures(int ideDefaultSass, int ideDefaultPtx) {
        int ptx;
        int sass = this.filterUnsupported(ideDefaultSass);
        if (sass + (ptx = this.filterUnsupported(ideDefaultPtx)) == 0) {
            int[] nArray = new int[2];
            nArray[0] = this.getCudaSpecs().getBit();
            return nArray;
        }
        return new int[]{ptx, sass};
    }

    public int filterUnsupported(int architectures) {
        Architecture required = this.getCudaSpecs();
        if (required == null) {
            return architectures;
        }
        int filtered = 0;
        Architecture[] architectureArray = Architecture.all();
        int n = architectureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture arch = architectureArray[n2];
            if (arch.compareTo(required) >= 0) {
                filtered |= arch.getBit();
            }
            ++n2;
        }
        return filtered & architectures;
    }

    public SamplesCategory getCategory() {
        return this.category;
    }

    public Architecture getCudaSpecs() {
        return this.cudaSpecs;
    }

    public String getDescription() {
        return this.description;
    }

    private String getFile(File dir) {
        String[] list = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cu") || name.endsWith(".cpp") || name.endsWith(".c");
            }
        });
        if (list.length == 0) {
            return null;
        }
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.startsWith(String.valueOf(dir.getName()) + ".c")) {
                return string;
            }
            ++n2;
        }
        return list[0];
    }

    public Map<IPath, File> getFiles() {
        return this.files;
    }

    public String[] getFrameworks(String os, String arch) {
        return ProjectSample.filter(this.frameworks, os, arch);
    }

    private String[] addPathesFromEnvVar(String[] paths, String envVarName) {
        String envVarValue = System.getProperty(envVarName, null);
        if (CoreUtil.isNullOrEmpty((String)envVarValue)) {
            return paths;
        }
        return (String[])CoreUtil.append((Object[])paths, (Object[])envVarValue.split(":"));
    }

    public String[] getIncludePaths(String os, String arch) {
        String[] paths = ProjectSample.filter(this.includePaths, os, arch);
        if (ImportCUDASample.isTestingSamplesImport()) {
            return this.addPathesFromEnvVar(paths, "includePaths");
        }
        return paths;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public boolean usesOpenMP() {
        return this.needsOpenMP;
    }

    private static String[] getKeywords(Document document) {
        String attribute = BasicUtil.getXmlText(document, "keywords");
        if (attribute == null || attribute.trim().length() == 0) {
            return NO_KEYWORDS;
        }
        return attribute.split(" *, *");
    }

    public String[] getLibraries(String os, String arch) {
        return ProjectSample.filter(this.libraries, os, arch);
    }

    public String[] getLibraryPaths(String os, String arch) {
        String[] paths = ProjectSample.filter(this.libraryPaths, os, arch);
        if (ImportCUDASample.isTestingSamplesImport()) {
            return this.addPathesFromEnvVar(paths, "libraryPaths");
        }
        return paths;
    }

    public File getManifestFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryFileRelativePath() {
        File dir = this.file.getParentFile();
        String file = this.getFile(dir);
        if (file == null) {
            File srcDir = new File(dir, "src");
            if (srcDir.isDirectory()) {
                String f2 = this.getFile(srcDir);
                if (f2 != null) {
                    return f2;
                }
                return "";
            }
            return "";
        }
        return file;
    }

    public String getShortName() {
        return this.file.getParentFile().getName();
    }

    public File getWhitepaper() {
        return this.whitepaper;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean isNsightCompatible() {
        return this.nsightCompatible && new File(this.file.getParentFile(), "Makefile").isFile();
    }

    private SamplesCategory parseCategories(SamplesModel model, File infofile) {
        File parentFile = infofile.getParentFile();
        if (parentFile.getParent() != null) {
            return new SamplesCategory(model, parentFile.getParentFile().getName());
        }
        return new SamplesCategory(model);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public Boolean supportedLinkMode() {
        return this.sepCompilation;
    }

    public String toString() {
        return String.format("[%s]", this.getName());
    }
}

