/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard;

import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.wizard.CudaProjectSetupWizardPage;
import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import com.nvidia.cuda.ide.wizard.samples.SamplesModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class SampleProjectSetupWizardPage
extends CudaProjectSetupWizardPage
implements PropertyChangeListener {
    private final SamplesModel model;

    public SampleProjectSetupWizardPage(SamplesModel model) {
        this.model = model;
        model.addPropertyChangeListener("selectedSample", this);
        this.shownAtLeastOnce = true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setSample(this.model.getSelectedSample());
        }
        super.setVisible(visible);
    }

    @Override
    protected final int filterArchitectures(int architectures, boolean isVirtual) {
        ProjectSample sample = this.model.getSelectedSample();
        if (sample != null) {
            int[] archs = sample.getDefaultArchitectures(architectures, architectures);
            return isVirtual ? archs[0] : archs[1];
        }
        return architectures;
    }

    @Override
    public Boolean isDeviceLinking() {
        ProjectSample sample = this.model.getSelectedSample();
        if (sample == null || sample.supportedLinkMode() == null) {
            return super.isDeviceLinking();
        }
        return sample.supportedLinkMode();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setSample((ProjectSample)evt.getNewValue());
    }

    private void setSample(ProjectSample sample) {
        if (this.linkerToggle != null && this.architectures != null) {
            if (sample != null) {
                Architecture requiredHardware = sample.getCudaSpecs();
                this.linkerToggle.setAllowedModes(sample.supportedLinkMode());
                this.architectures.setMinArchitecture(requiredHardware);
            } else {
                this.linkerToggle.setAllowedModes(null);
                this.architectures.setMinArchitecture(null);
                this.setDeviceLinkingEnabled(this.linkerToggle.isEnabled());
            }
            this.architectures.setModule(this);
            this.validate();
        }
    }
}

