/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard;

import com.nvidia.cuda.ide.build.project.IArchitectureObject;
import com.nvidia.cuda.ide.util.UiUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public final class LinkerToggle {
    private boolean enabled = true;
    private Boolean mode;
    private IArchitectureObject module;
    private final Button separateCompile;
    private final Button wholeCompile;

    public LinkerToggle(Composite parent, int columns, boolean dense) {
        IWorkbenchHelpSystem system = PlatformUI.getWorkbench().getHelpSystem();
        if (!dense) {
            Label label = new Label(parent, 0);
            label.setText("Device linker mode:");
            system.setHelp((Control)label, "com.nvidia.cuda.ide.build.device-linker");
        }
        Composite radios = new Composite(parent, 0);
        system.setHelp((Control)radios, "com.nvidia.cuda.ide.build.device-linker");
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        radios.setLayout((Layout)gridLayout);
        radios.setLayoutData((Object)UiUtil.createLayoutData(columns - (dense ? 0 : 1)));
        this.wholeCompile = new Button(radios, 16);
        this.separateCompile = new Button(radios, 16);
        this.wholeCompile.setText("Whole program compilation");
        this.separateCompile.setText("Separate compilation");
        this.separateCompile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = LinkerToggle.this.separateCompile.getSelection();
                if (LinkerToggle.this.module != null) {
                    LinkerToggle.this.module.setDeviceLinkingEnabled(selection);
                }
            }
        });
    }

    public boolean isUserSelectable() {
        return this.mode == null;
    }

    public void setAllowedModes(Boolean mode) {
        this.mode = mode;
        this.updateChecks();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateChecks();
    }

    public void setModule(IArchitectureObject module) {
        this.module = module;
        this.updateChecks();
    }

    private void updateChecks() {
        Boolean deviceLinking = this.module == null ? null : this.module.isDeviceLinking();
        this.separateCompile.setSelection(Boolean.TRUE.equals(this.mode) || this.mode == null && Boolean.TRUE.equals(deviceLinking));
        this.wholeCompile.setSelection(Boolean.FALSE.equals(this.mode) || this.mode == null && Boolean.FALSE.equals(deviceLinking));
        this.separateCompile.setEnabled(this.enabled && this.mode == null);
        this.wholeCompile.setEnabled(this.enabled && this.mode == null);
    }

    public boolean isEnabled() {
        return this.separateCompile.getSelection();
    }

    public boolean isDeviceLinking() {
        return this.separateCompile.getSelection();
    }
}

