/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.core.Messages;
import com.nvidia.cuda.ide.build.project.DeclareCudaModulesProcess;
import com.nvidia.cuda.ide.build.project.IArchitectureObject;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.ui.ArchitecturesSelector;
import com.nvidia.cuda.ide.util.UiUtil;
import com.nvidia.cuda.ide.wizard.CudaMainWizardPage;
import com.nvidia.cuda.ide.wizard.LinkerToggle;
import com.nvidia.cuda.ide.wizard.NewCudaCProjectWizard;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.templateengine.AbstractWizardDataPage;
import org.eclipse.cdt.ui.wizards.CDTMainWizardPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CudaProjectSetupWizardPage
extends AbstractWizardDataPage
implements IArchitectureObject {
    public static final String PREFERENCE_DEFAULT_SOURCE_LOCATION = "newproject.source.location";
    protected final ArchitecturesSelector architectures = new ArchitecturesSelector();
    private final String defaultSourceLocation;
    private CudaMainWizardPage delegate;
    private boolean linker;
    protected LinkerToggle linkerToggle;
    private int physical;
    private LocationWithLabel primaryLocation;
    protected boolean shownAtLeastOnce = false;
    private final boolean showSourceLocations;
    private int virtual;

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private static boolean hasSM20(int physical) {
        Architecture[] architectureArray = Architecture.decode(physical);
        int n = architectureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            if (architecture.major >= 2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected CudaProjectSetupWizardPage() {
        this(true);
    }

    protected CudaProjectSetupWizardPage(boolean showSourceLocations) {
        super(Messages.CudaProjectSetupWizardPage_CUDA, Messages.CudaProjectSetupWizardPage_title, null);
        this.showSourceLocations = showSourceLocations;
        this.setDescription(Messages.CudaProjectSetupWizardPage_description);
        this.physical = DeclareCudaModulesProcess.getDefaultSassArchitectures();
        this.virtual = DeclareCudaModulesProcess.getDefaultPtxArchitectures();
        this.linker = DeclareCudaModulesProcess.getDeviceLinkerDefault();
        this.defaultSourceLocation = CudaProjectSetupWizardPage.getPreferenceStore().getString(PREFERENCE_DEFAULT_SOURCE_LOCATION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int columns = Architecture.all().length + 1;
        composite.setLayout((Layout)new GridLayout(columns, false));
        if (this.showSourceLocations) {
            this.createSourceLocationEntries(composite, columns - 1);
            new Label(composite, 0).setLayoutData((Object)UiUtil.createLayoutData(columns));
        }
        this.linkerToggle = new LinkerToggle(composite, columns, false);
        this.architectures.createControls(composite, columns, true);
        new Label(composite, 0).setLayoutData((Object)GridDataFactory.fillDefaults().span(columns, 1).create());
        UiUtil.createDevicesInformationLabel(composite);
        this.linkerToggle.setModule(this);
        this.architectures.setModule(this);
        this.initializeLocations();
        this.validate();
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    protected void createSourceLocationEntries(Composite composite, int columns) {
        this.primaryLocation = new LocationWithLabel(composite, Messages.CudaProjectSetupWizardPage_label_source_folder, columns);
    }

    @Override
    public void disableArchitecture(Architecture architecture, boolean isPhysical) {
        if (isPhysical) {
            this.physical &= ~architecture.getBit();
        } else {
            this.virtual &= ~architecture.getBit();
        }
        this.validate();
    }

    @Override
    public void enableArchitecture(Architecture architecture, boolean isPhysical) {
        if (isPhysical) {
            this.physical |= architecture.getBit();
        } else {
            this.virtual |= architecture.getBit();
        }
        this.validate();
    }

    protected int filterArchitectures(int architectures, boolean isVirtual) {
        return architectures;
    }

    public final IWizardPage getNextPage() {
        IWizard w = this.getWizard();
        if (w instanceof NewCudaCProjectWizard) {
            return ((NewCudaCProjectWizard)w).getWizardExtensionPage();
        }
        return super.getNextPage();
    }

    public Map<String, String> getPageData() {
        String path;
        int vfiltered = this.filterArchitectures(this.virtual, true);
        int pfiltered = this.filterArchitectures(this.physical, false);
        if (this.primaryLocation != null) {
            DeclareCudaModulesProcess.savePreferences(this.nullIfEquals(vfiltered, this.filterArchitectures(DeclareCudaModulesProcess.getDefaultPtxArchitectures(), true)), this.nullIfEquals(pfiltered, this.filterArchitectures(DeclareCudaModulesProcess.getDefaultSassArchitectures(), false)), this.linkerToggle.isUserSelectable() ? Boolean.valueOf(this.linker) : null);
            if (this.showSourceLocations) {
                path = this.primaryLocation.getText();
                CudaProjectSetupWizardPage.getPreferenceStore().setValue(PREFERENCE_DEFAULT_SOURCE_LOCATION, path);
            } else {
                path = null;
            }
        } else {
            path = this.showSourceLocations ? this.defaultSourceLocation : null;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sourceDir", path);
        IWizard wizard = this.getWizard();
        boolean isOverwritingFiles = wizard instanceof NewCudaCProjectWizard ? ((NewCudaCProjectWizard)wizard).overwritingProject() : false;
        data.put("overwritingExistingFiles", Boolean.toString(isOverwritingFiles));
        DeclareCudaModulesProcess.initializeTemplateParams(data, vfiltered, pfiltered, this.isDeviceLinking());
        return data;
    }

    private Integer nullIfEquals(int actual, int def) {
        return actual == def ? null : Integer.valueOf(actual);
    }

    @Override
    public int getPhysicalArchitecturesForAllConfigurations() {
        return this.filterArchitectures(this.physical, false);
    }

    @Override
    public int getPhysicalArchitecturesForSomeConfigurations() {
        return 0;
    }

    public IWizardPage getPreviousPage() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return super.getPreviousPage();
    }

    private IPath getProjectLocation() {
        CDTMainWizardPage page = (CDTMainWizardPage)this.getWizard().getStartingPage();
        URI locationURI = page.getLocationURI();
        Object path = locationURI == null ? page.getLocationPath().append(page.getProjectName()) : new Path(locationURI.getPath());
        return path;
    }

    @Override
    public int getVirtualArchitecturesForAllConfigurations() {
        return this.filterArchitectures(this.virtual, true);
    }

    @Override
    public int getVirtualArchitecturesForSomeConfigurations() {
        return 0;
    }

    protected void initializeLocations() {
        if (this.showSourceLocations) {
            this.primaryLocation.setText(this.defaultSourceLocation);
        }
    }

    @Override
    public Boolean isDeviceLinking() {
        return this.linker;
    }

    public boolean isPageComplete() {
        return (this.shownAtLeastOnce || this.isSkipped()) && super.isPageComplete();
    }

    public boolean isSkipped() {
        if (this.delegate != null) {
            return this.delegate.getNextPage() != this;
        }
        return false;
    }

    public void setDelegate(CudaMainWizardPage delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setDeviceLinkingEnabled(boolean link) {
        this.linker = link;
        this.architectures.setModule(this);
        this.validate();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.shownAtLeastOnce = true;
        }
        if (this.primaryLocation != null) {
            this.primaryLocation.updateLocation();
        }
        super.setVisible(visible);
    }

    protected final void validate() {
        IStatus status = this.validatePage();
        this.setMessage(null);
        String error = null;
        switch (status.getSeverity()) {
            case 4: {
                error = status.getMessage();
                break;
            }
            case 0: {
                this.setMessage(null);
                break;
            }
            default: {
                this.setMessage(status.getMessage(), status.getSeverity() != 2 ? 1 : 2);
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
        if (this.shownAtLeastOnce) {
            this.getContainer().updateButtons();
        }
    }

    private IStatus validatePage() {
        IStatus status = this.validatePaths();
        if (!status.isOK()) {
            return status;
        }
        int v = this.filterArchitectures(this.virtual, true);
        int p = this.filterArchitectures(this.physical, false);
        if (this.isDeviceLinking().booleanValue() && !CudaProjectSetupWizardPage.hasSM20(p | v)) {
            return new Status(4, "com.nvidia.cuda.ide.build", Messages.CudaProjectSetupWizardPage_error_separate_compilation_requires_sm20);
        }
        if (p == 0 && v == 0) {
            return new Status(2, "com.nvidia.cuda.ide.build", Messages.CudaProjectSetupWizardPage_info_default_versions);
        }
        return UiUtil.validateCompatibility(ICudaModule.Type.executable, p, v, this.linker);
    }

    protected IStatus validatePaths() {
        return this.showSourceLocations ? this.primaryLocation.validatePath() : Status.OK_STATUS;
    }

    public void setNextPage(IWizardPage next) {
        IWizard w = this.getWizard();
        if (w instanceof NewCudaCProjectWizard) {
            ((NewCudaCProjectWizard)w).setConfigsPage(next);
        }
        super.setNextPage(next);
    }

    protected final class LocationWithLabel {
        private final CLabel localPath;
        private final Text location;

        public LocationWithLabel(Composite composite, String label, int columns) {
            new Label(composite, 0).setText(label);
            this.location = new Text(composite, 2048);
            this.location.setLayoutData((Object)UiUtil.createLayoutData(columns));
            this.location.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LocationWithLabel.this.updateLocation();
                    CudaProjectSetupWizardPage.this.validate();
                }
            });
            new Label(composite, 0).setText("");
            this.localPath = new CLabel(composite, 2048);
            this.localPath.setLayoutData((Object)UiUtil.createLayoutData(columns));
        }

        public CLabel getLocalPath() {
            return this.localPath;
        }

        public Text getLocation() {
            return this.location;
        }

        public String getText() {
            return this.location.getText();
        }

        public void setText(String string) {
            this.location.setText(string);
            this.updateLocation();
        }

        public void updateLocation() {
            String path = CudaProjectSetupWizardPage.this.getProjectLocation().append((IPath)new Path(this.location.getText())).toOSString();
            this.localPath.setText(path);
            this.localPath.setToolTipText(path);
        }

        protected IStatus validatePath() {
            String text = this.getText();
            Path path = new Path(text);
            if (!path.isValidPath(text)) {
                return new Status(4, "com.nvidia.cuda.ide.build", String.format(Messages.CudaProjectSetupWizardPage_error_path_invalid, text));
            }
            return Status.OK_STATUS;
        }
    }
}

