/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.util;

import com.nvidia.cuda.ide.build.core.Activator;
import java.io.File;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class BasicUtil {
    private static final int PRIME = 31;

    public static String[] getXMLStrings(Document document, String tagName) {
        TreeSet<String> strings = new TreeSet<String>();
        NodeList elements = document.getElementsByTagName(tagName);
        int i = 0;
        while (i < elements.getLength()) {
            String s = BasicUtil.nullIfEmpty(elements.item(i).getTextContent());
            if (s != null) {
                strings.add(s);
            }
            ++i;
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String getXmlText(Document document, String attribute) {
        NodeList list = document.getElementsByTagName(attribute);
        if (list.getLength() > 0) {
            return BasicUtil.nullIfEmpty(list.item(0).getTextContent());
        }
        return null;
    }

    public static int hash(Object object) {
        return BasicUtil.hash(object, 31, 1);
    }

    public static int hash(Object object, int base) {
        return BasicUtil.hash(object, 31, base);
    }

    public static int hash(Object object, int prime, int base) {
        return prime * base + (object == null ? 0 : object.hashCode());
    }

    public static String intern(String s) {
        return s == null ? null : s.intern();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String nullIfEmpty(String string) {
        if (!BasicUtil.isNullOrEmpty(string)) {
            return string.trim();
        }
        return null;
    }

    public static boolean sameObject(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 != null && o1.equals(o2);
    }

    private BasicUtil() {
    }

    public static boolean isNullOrEmpty(Object[] strings) {
        return strings == null || strings.length == 0;
    }

    public static String notNull(String string) {
        return string == null ? "" : string.trim();
    }

    public static String[] join(String[] paths, String ... value) {
        if (BasicUtil.isNullOrEmpty(paths)) {
            return value;
        }
        if (BasicUtil.isNullOrEmpty(value)) {
            return paths;
        }
        String[] newValue = new String[value.length + paths.length];
        System.arraycopy(paths, 0, newValue, 0, paths.length);
        System.arraycopy(value, 0, newValue, paths.length, value.length);
        return newValue;
    }

    public static boolean isStringQuoted(String string) {
        if (string == null) {
            return false;
        }
        String trimmedString = string.trim();
        if (trimmedString.length() < 2) {
            return false;
        }
        return trimmedString.startsWith("\"") && trimmedString.endsWith("\"");
    }

    public static String quote(String string) {
        return string != null && !BasicUtil.isStringQuoted(string) ? String.format("\"%s\"", string) : string;
    }

    public static String[] quote(String ... strings) {
        if (BasicUtil.isNullOrEmpty(strings)) {
            return strings;
        }
        String[] quoted = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            quoted[i] = BasicUtil.quote(strings[i]);
            ++i;
        }
        return quoted;
    }

    public static boolean isFile(File file) {
        if (file == null) {
            return false;
        }
        return file.isFile();
    }

    public static boolean isDirectory(File file) {
        if (file == null) {
            return false;
        }
        return file.isDirectory();
    }

    public static boolean isFile(IPath path) {
        File file = path != null ? path.toFile() : null;
        return BasicUtil.isFile(file);
    }

    public static boolean isDirectory(IPath path) {
        File file = path != null ? path.toFile() : null;
        return BasicUtil.isDirectory(file);
    }

    public static String performStringSubstitution(String string) {
        IStringVariableManager ssm = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return ssm.performStringSubstitution(string);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }
}

