/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.samples;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.util.BasicUtil;
import com.nvidia.cuda.ide.util.UiUtil;
import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public final class UnpackCudaSampleProcess
extends ProcessRunner {
    public static final String ATTR_PROJECT_NAME = "projectName";
    public static final String ATTR_SAMPLE_MANIFEST = "sample";
    public static final String ATTR_SRC_DIR = "sourceDir";
    public static final String ATTR_OVERWRITING_EXISTING_FILES = "overwritingExistingFiles";
    private static final int MAX_DEPTH = 15;

    private static void addConfigurationPaths(IConfiguration configuration, ProjectSample sample) throws BuildException, IOException {
        UnpackCudaSampleProcess.setBits(configuration);
        UnpackCudaSampleProcess.addIncludePaths(configuration, sample);
        UnpackCudaSampleProcess.addLibraryPaths(configuration, sample);
        UnpackCudaSampleProcess.addLibraries(configuration, sample);
        UnpackCudaSampleProcess.addFrameworks(configuration, sample);
        UnpackCudaSampleProcess.addOtherObjects(configuration, sample);
    }

    private static void addFrameworks(IConfiguration configuration, ProjectSample sample) {
        Object[] frameworks = sample.getFrameworks(UnpackCudaSampleProcess.getProjectTargetOS(), Platform.getOSArch());
        if (!BasicUtil.isNullOrEmpty(frameworks)) {
            String[] values = new String[frameworks.length * 2];
            int i = 0;
            Object[] objectArray = frameworks;
            int n = frameworks.length;
            int n2 = 0;
            while (n2 < n) {
                Object framework = objectArray[n2];
                values[i++] = "-framework";
                values[i++] = framework;
                ++n2;
            }
            UnpackCudaSampleProcess.appendStringOptionValues(configuration, "nvcc.linker", "nvcc.linker.option.other", values);
        }
    }

    private static String getProjectName(IConfiguration configuration) {
        return configuration.getManagedProject().getOwner().getProject().getName();
    }

    private static String generateVariable(IConfiguration configuration, String name) {
        return String.format("${%s:/%s}", name, UnpackCudaSampleProcess.getProjectName(configuration));
    }

    private static String generateCudaSamplesDirVariable(IConfiguration configuration) {
        return UnpackCudaSampleProcess.generateVariable(configuration, "cuda_samples_dir");
    }

    private static String getCudaSamplesDir(IConfiguration configuration) {
        String samplesDirVar = UnpackCudaSampleProcess.generateCudaSamplesDirVariable(configuration);
        return BasicUtil.performStringSubstitution(samplesDirVar);
    }

    private static String[] parametrizeIncludes(IConfiguration configuration, String[] input) {
        String csdVar = UnpackCudaSampleProcess.generateCudaSamplesDirVariable(configuration);
        String csdPath = UnpackCudaSampleProcess.getCudaSamplesDir(configuration);
        if (csdPath == null) {
            return input;
        }
        ArrayList<String> copy = new ArrayList<String>();
        String[] stringArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            copy.add(path.startsWith(csdPath) ? path.replace(csdPath, csdVar) : path);
            ++n2;
        }
        return copy.toArray(new String[input.length]);
    }

    private static void addIncludePaths(IConfiguration configuration, ProjectSample sample) throws BuildException {
        String projectRoot = UnpackCudaSampleProcess.generateVariable(configuration, "workspace_loc");
        String[] samplePaths = sample.getIncludePaths(UnpackCudaSampleProcess.getProjectTargetOS(), Platform.getOSArch());
        String[] parametrizedIncludes = UnpackCudaSampleProcess.parametrizeIncludes(configuration, samplePaths);
        String[] paths = BasicUtil.quote(BasicUtil.join(parametrizedIncludes, projectRoot));
        UnpackCudaSampleProcess.appendStringOptionValues(configuration, "nvcc.compiler", "gnu.cpp.compiler.option.include.paths", paths);
    }

    private static void addLibraries(IConfiguration configuration, ProjectSample sample) throws BuildException {
        Object[] sampleLibs = sample.getLibraries(UnpackCudaSampleProcess.getProjectTargetOS(), Platform.getOSArch());
        if (!BasicUtil.isNullOrEmpty(sampleLibs)) {
            UnpackCudaSampleProcess.appendStringOptionValues(configuration, "nvcc.linker", "gnu.c.link.option.libs", (String[])sampleLibs);
        }
    }

    private static void addLibraryPaths(IConfiguration configuration, ProjectSample sample) throws BuildException {
        String[] paths = sample.getLibraryPaths(UnpackCudaSampleProcess.getProjectTargetOS(), Platform.getOSArch());
        UnpackCudaSampleProcess.appendStringOptionValues(configuration, "nvcc.linker", "gnu.c.link.option.paths", BasicUtil.quote(BasicUtil.join(paths, UnpackCudaSampleProcess.getHardcodedLibraryPaths(sample))));
    }

    private static void addOtherObjects(IConfiguration configuration, ProjectSample sample) {
        if (UnpackCudaSampleProcess.isMac() && UnpackCudaSampleProcess.isOpenGLSample(sample)) {
            File glew = new File(sample.getManifestFile().getParentFile(), "../../common/lib/darwin/libGLEW.a");
            try {
                if (glew.exists()) {
                    UnpackCudaSampleProcess.appendStringOptionValues(configuration, "nvcc.linker", "nvcc.linker.option.userobjs", BasicUtil.quote(glew.getCanonicalPath()));
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        if (sample.usesOpenMP()) {
            UnpackCudaSampleProcess.appendStringOptionValues(configuration, "nvcc.compiler", "nvcc.compiler.compileroptions", "-fopenmp");
            UnpackCudaSampleProcess.appendStringOptionValues(configuration, "nvcc.linker", "nvcc.linker.option.libs", "gomp");
        }
    }

    private static void appendStringOptionValues(IConfiguration configuration, String toolId, String optionId, String ... values) {
        Object[] tools = configuration.getToolsBySuperClassId(toolId);
        if (!BasicUtil.isNullOrEmpty(tools)) {
            Object[] objectArray = tools;
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                Object tool = objectArray[n2];
                IOption option = tool.getOptionBySuperClassId(optionId);
                if (option != null) {
                    try {
                        ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)tool, (IOption)option, (String[])BasicUtil.join(UnpackCudaSampleProcess.getOptionValue(option), values));
                    }
                    catch (BuildException e) {
                        Activator.log((Exception)((Object)e));
                    }
                }
                ++n2;
            }
        }
    }

    private static void carefullySetOptionValue(ITool tool, String optionId, String value) {
        IOption option = tool.getOptionBySuperClassId(optionId);
        if (option != null) {
            ManagedBuildManager.setOption((IConfiguration)tool.getParentResourceInfo().getParent(), (IHoldsOptions)tool, (IOption)option, (String)value);
        }
    }

    private static void copyDataFiles(IProject project, Map<IPath, File> dataFiles, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (String)"Copying data files to project", (int)(dataFiles.size() * 100));
        try {
            for (Map.Entry<IPath, File> file : dataFiles.entrySet()) {
                IPath path = file.getKey();
                IFile f = project.getFile(path);
                if (f.exists()) {
                    throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.build", String.format("File %s already exists", f.getLocation())));
                }
                UiUtil.createPath((IResource)f.getParent());
                FileInputStream is = new FileInputStream(file.getValue());
                try {
                    f.create((InputStream)is, overwrite ? 1 : 0, (IProgressMonitor)convert.newChild(100));
                }
                finally {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.build", "File copy failed", (Throwable)e));
        }
    }

    private static void copyFile(File file, IContainer target, boolean overwrite, IProgressMonitor monitor) throws CoreException, IOException {
        IFile f = target.getFile((IPath)new Path(file.getName()));
        if (f.exists()) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.build", String.format("File %s already exists", f.getFullPath())));
        }
        f.create((InputStream)new FileInputStream(file), overwrite ? 1 : 0, monitor);
    }

    private static String[] getHardcodedLibraryPaths(ProjectSample sample) {
        if (UnpackCudaSampleProcess.isMac() && UnpackCudaSampleProcess.isOpenGLSample(sample)) {
            return new String[]{"/System/Library/Frameworks/OpenGL.framework/Libraries"};
        }
        return null;
    }

    private static String[] getOptionValue(IOption option) throws BuildException {
        switch (option.getValueType()) {
            case 4: {
                return option.getIncludePaths();
            }
            case 6: {
                return option.getLibraries();
            }
            case 9: {
                return option.getLibraryPaths();
            }
            case 7: {
                return option.getUserObjects();
            }
        }
        return option.getStringListValue();
    }

    private static String getProjectTargetOS() {
        return Platform.getOS();
    }

    private static File[] getSourceFiles(File root) {
        File[] files = root.listFiles(new SourceFilesFilter());
        return UnpackCudaSampleProcess.mergeFileList(UnpackCudaSampleProcess.mergeFileList(files, new File(root, "src")), new File(root, "inc"));
    }

    private static boolean hasGLLibrary(String[] libraries) {
        String[] stringArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            String library = stringArray[n2];
            if ("GL".equals(library)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isMac() {
        return "macosx".equals(UnpackCudaSampleProcess.getProjectTargetOS());
    }

    private static boolean isOpenGLSample(ProjectSample sample) {
        return UnpackCudaSampleProcess.hasGLLibrary(sample.getLibraries(UnpackCudaSampleProcess.getProjectTargetOS(), Platform.getOSArch())) || UnpackCudaSampleProcess.hasGLLibrary(sample.getFrameworks(UnpackCudaSampleProcess.getProjectTargetOS(), Platform.getOSArch()));
    }

    private static File[] mergeFileList(File[] files, File srcDir) {
        if (srcDir.isDirectory()) {
            File[] srcFiles = srcDir.listFiles(new SourceFilesFilter());
            if (files.length == 0) {
                return srcFiles;
            }
            if (srcFiles.length == 0) {
                return files;
            }
            File[] f = new File[files.length + srcFiles.length];
            System.arraycopy(files, 0, f, 0, files.length);
            System.arraycopy(srcFiles, 0, f, files.length, srcFiles.length);
            return f;
        }
        return files;
    }

    private static void setBits(IConfiguration configuration) {
        String linkerOption;
        String compilerOption;
        String osArch = Platform.getOSArch();
        if ("x86_64".equals(osArch)) {
            compilerOption = "nvcc.compiler.machine64";
            linkerOption = "nvcc.linker.machine64";
        } else if ("x86_64".equals(osArch)) {
            compilerOption = "nvcc.compiler.machine32";
            linkerOption = "nvcc.linker.machine32";
        } else {
            compilerOption = "nvcc.compiler.machineDefault";
            linkerOption = "nvcc.linker.machineDefault";
        }
        ITool[] iToolArray = configuration.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            UnpackCudaSampleProcess.carefullySetOptionValue(tool, "nvcc.compiler.machine", compilerOption);
            UnpackCudaSampleProcess.carefullySetOptionValue(tool, "nvcc.linker.option.machine", linkerOption);
            ++n2;
        }
    }

    private static void setPaths(IProject project, ProjectSample sample, SubMonitor newChild) throws BuildException {
        IConfiguration[] configurations;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] iConfigurationArray = configurations = info.getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            try {
                UnpackCudaSampleProcess.addConfigurationPaths(configuration, sample);
            }
            catch (IOException e) {
                Activator.log(e);
            }
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
    }

    private void copyAdditionalHeaders(File sampleInstall, IContainer target, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Copying header files", 1);
        File inc = new File(sampleInstall, "inc");
        try {
            this.copySubTree(inc, target, overwrite, 0);
        }
        catch (IOException e) {
            Activator.log(e);
        }
        monitor.worked(1);
        monitor.done();
    }

    private void copySourcesAndHeaders(File[] listFiles, IContainer target, boolean overwrite, SubMonitor monitor) throws CoreException {
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                UnpackCudaSampleProcess.copyFile(file, target, overwrite, (IProgressMonitor)monitor.newChild(100));
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.build", String.format("File %s was not found", file.getAbsolutePath())));
            }
            ++n2;
        }
        monitor.done();
    }

    private void copySubTree(File src, IContainer dest, boolean overwrite, int depth) throws CoreException, IOException {
        if (depth > 15) {
            return;
        }
        if (src.isDirectory()) {
            File[] files;
            IFolder folder = dest.getFolder((IPath)new Path(src.getName()));
            folder.create(false, true, null);
            File[] fileArray = files = src.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.copySubTree(file, (IContainer)folder, overwrite, depth + 1);
                } else if (file.isFile()) {
                    UnpackCudaSampleProcess.copyFile(file, (IContainer)folder, overwrite, null);
                }
                ++n2;
            }
        }
    }

    private void installSample(IProject project, IContainer target, ProjectSample projectSample, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        Map<IPath, File> dataFiles = projectSample.getFiles();
        File sampleInstallRoot = projectSample.getManifestFile().getParentFile();
        File[] files = UnpackCudaSampleProcess.getSourceFiles(sampleInstallRoot);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format("Creating project %s from CUDA SDK sample \"%s\"", project.getName(), projectSample.getName()), (int)((files.length + dataFiles.size() + 2) * 100));
        try {
            this.copySourcesAndHeaders(files, target, overwrite, subMonitor.newChild(files.length * 100));
            this.copyAdditionalHeaders(sampleInstallRoot, (IContainer)project, overwrite, (IProgressMonitor)subMonitor.newChild(100));
            UnpackCudaSampleProcess.setPaths(project, projectSample, subMonitor.newChild(100));
            UnpackCudaSampleProcess.copyDataFiles(project, dataFiles, overwrite, (IProgressMonitor)subMonitor.newChild(dataFiles.size() * 100));
        }
        catch (BuildException e) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.build", "Unable to configure project description", (Throwable)e));
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        IProject target;
        String projectName = null;
        String templatePath = null;
        String sourceFolder = null;
        boolean overwritingExistingFiles = false;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument argument = processArgumentArray[n2];
            String name = argument.getName();
            String value = argument.getSimpleValue();
            if (ATTR_PROJECT_NAME.equals(name)) {
                projectName = value;
            } else if (ATTR_SAMPLE_MANIFEST.equals(name)) {
                templatePath = value;
            } else if (ATTR_SRC_DIR.equalsIgnoreCase(name)) {
                sourceFolder = value;
            } else if (ATTR_OVERWRITING_EXISTING_FILES.equalsIgnoreCase(name)) {
                overwritingExistingFiles = Boolean.valueOf(value);
            }
            ++n2;
        }
        if (projectName == null) {
            throw new ProcessFailureException("Missing project name");
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName.trim());
        if (project == null || !project.isAccessible()) {
            throw new ProcessFailureException(String.format("Project \"%s\" is not available", projectName));
        }
        if (sourceFolder == null || sourceFolder.trim().length() == 0) {
            target = project;
        } else {
            target = project.getFolder(sourceFolder.trim());
            if (target == null || !target.isAccessible()) {
                throw new ProcessFailureException(String.format("Folder \"%s\" in project \"%s\" is not accessible", sourceFolder, project.getName()));
            }
        }
        if (templatePath == null) {
            throw new ProcessFailureException("Sample path is missing");
        }
        File file = new File(templatePath);
        try {
            boolean overwrite = overwritingExistingFiles;
            workspace.run(new IWorkspaceRunnable((IContainer)target, file, overwrite){
                private final /* synthetic */ IContainer val$target;
                private final /* synthetic */ File val$file;
                private final /* synthetic */ boolean val$overwrite;
                {
                    this.val$target = iContainer;
                    this.val$file = file;
                    this.val$overwrite = bl;
                }

                public void run(IProgressMonitor monitor) throws CoreException {
                    UnpackCudaSampleProcess.this.installSample(project, this.val$target, new ProjectSample(this.val$file), this.val$overwrite, monitor);
                }
            }, (ISchedulingRule)project, 1, monitor);
        }
        catch (CoreException e) {
            throw new ProcessFailureException((Throwable)e);
        }
    }

    private static final class SourceFilesFilter
    implements FilenameFilter {
        private SourceFilesFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".cu") || name.endsWith(".h") || name.endsWith(".cuh") || name.endsWith(".cpp") || name.endsWith(".c") || name.endsWith(".hpp");
        }
    }
}

