/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.samples;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.DeclareCudaModulesProcess;
import com.nvidia.cuda.ide.samples.ImportCUDASample;
import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public final class InstantiateCudaSampleRunnable
implements IRunnableWithProgress {
    public static final String ATTR_SAMPLE_MAIN_FILE = "primaryfile";
    private final ProjectSample sample;
    private final String name;
    private final URI location;
    private final String sourceFolder;
    private final int ptx;
    private final int sass;
    private final boolean deviceLinker;
    private final boolean build;
    private final boolean shutdownOnSampleImport;
    private static final AtomicInteger numSamplesProcessedTotal = new AtomicInteger(0);
    private final IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

        public void run(IProgressMonitor monitor) throws CoreException {
            InstantiateCudaSampleRunnable.this.createProject(monitor);
        }
    };
    private static final String PROPERTY = "org.eclipse.cdt.build.core.buildType";
    private static final String PROP_VAL = "org.eclipse.cdt.build.core.buildType.debug";

    public InstantiateCudaSampleRunnable(ProjectSample sample, String name, URI location, String sourceFolder, int ptx, int sass, boolean deviceLinker, boolean build, boolean shutdownOnSampleImport) {
        this.sample = sample;
        this.name = name;
        this.location = location;
        this.sourceFolder = sourceFolder;
        this.ptx = ptx;
        this.sass = InstantiateCudaSampleRunnable.filterSass(sass, deviceLinker);
        this.deviceLinker = sample.supportedLinkMode() == null ? deviceLinker : sample.supportedLinkMode();
        this.build = build;
        this.shutdownOnSampleImport = shutdownOnSampleImport;
    }

    private static int filterSass(int sass, boolean deviceLinker) {
        int result = 0;
        Architecture[] architectureArray = Architecture.decode(sass);
        int n = architectureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            if (!deviceLinker || architecture.supportSeparateCompile()) {
                result |= architecture.getBit();
            }
            ++n2;
        }
        return result;
    }

    public void run(IProgressMonitor monitor) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            workspace.run(this.workspaceRunnable, (ISchedulingRule)workspace.getRoot(), 1, monitor);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.cuda.ide.build", String.format("Unable to import %s", this.sample.getName()), (Throwable)e), 3);
            monitor.done();
        }
    }

    protected void createProject(IProgressMonitor monitor) {
        Object fMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        fMonitor.beginTask(CUIPlugin.getResourceString((String)"CProjectWizard.op_description"), 120);
        fMonitor.worked(10);
        try {
            try {
                numSamplesProcessedTotal.incrementAndGet();
                IProject newProject = this.createIProject(this.name, this.location, (IProgressMonitor)new SubProgressMonitor(fMonitor, 40));
                if (newProject != null) {
                    this.createProject(newProject, (IProgressMonitor)new SubProgressMonitor(fMonitor, 40));
                }
                fMonitor.worked(10);
                if (this.build) {
                    boolean testImport = ImportCUDASample.isTestingSamplesImport();
                    if (testImport) {
                        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)newProject);
                        IManagedProject project = info.getManagedProject();
                        IConfiguration[] configs = project.getConfigurations();
                        IConfiguration newConfiguration = null;
                        IConfiguration[] iConfigurationArray = configs;
                        int n = configs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfiguration configuration = iConfigurationArray[n2];
                            if (!"Debug".equals(configuration.getName())) {
                                newConfiguration = configuration;
                                break;
                            }
                            ++n2;
                        }
                        ManagedBuildManager.setDefaultConfiguration((IProject)newProject, newConfiguration);
                    }
                    newProject.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    if (testImport) {
                        IMarker[] markers = newProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
                        int errors = this.countErrors(markers);
                        if (errors > 0) {
                            System.out.printf("%s import failed - project has %d build problems:\n", this.sample.getManifestFile(), errors);
                            IMarker[] iMarkerArray = markers;
                            int n = markers.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IMarker marker = iMarkerArray[n3];
                                if (marker.getAttribute("severity", 2) == 2) {
                                    System.out.printf("%s:%d : %s\n", marker.getResource().getProjectRelativePath(), marker.getAttribute("lineNumber", -99), marker.getAttribute("message"));
                                }
                                ++n3;
                            }
                            System.out.println();
                        } else if (!this.shutdownOnSampleImport) {
                            if (!this.canRun(newProject)) {
                                System.out.printf("%s import failed - executable run failed\n", this.sample.getManifestFile());
                            } else {
                                newProject.delete(false, (IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                    }
                }
                if (this.shutdownOnSampleImport && numSamplesProcessedTotal.decrementAndGet() == 0) {
                    final IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                    window.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!PlatformUI.getWorkbench().close()) {
                                System.out.println("Workbench shutdown failed");
                                window.close();
                            }
                        }
                    });
                }
            }
            catch (CoreException e) {
                CUIPlugin.log((Throwable)e);
                fMonitor.done();
            }
        }
        finally {
            fMonitor.done();
        }
    }

    private boolean canRun(IProject newProject) {
        IFile file = newProject.getFolder("Release").getFile(newProject.getName());
        if (!file.exists()) {
            return false;
        }
        IPath exe = file.getLocation();
        try {
            Process exec = Runtime.getRuntime().exec(new String[]{exe.toString(), "noprompt"});
            return exec.waitFor() == 0;
        }
        catch (IOException e) {
            Activator.log(e);
            return false;
        }
        catch (InterruptedException e) {
            Activator.log(e);
            return false;
        }
    }

    private int countErrors(IMarker[] markers) {
        int i = 0;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.getAttribute("severity", 2) == 2) {
                ++i;
            }
            ++n2;
        }
        return i;
    }

    public void createProject(final IProject project, IProgressMonitor monitor) throws CoreException {
        final CoreException[] exception = new CoreException[1];
        try {
            monitor.beginTask("", 100);
            final CfgHolder[] cfgs = this.setProjectDescription(project, monitor);
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        InstantiateCudaSampleRunnable.this.doTemplatesPostProcess(project, cfgs);
                    }
                    catch (CoreException e) {
                        exception[0] = e;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
            monitor.worked(30);
        }
        finally {
            monitor.done();
        }
    }

    protected void doTemplatesPostProcess(IProject prj, CfgHolder[] cfgs) throws CoreException {
        Template template = TemplateEngineUI.getDefault().getTemplateById("sdksampleProject");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", this.name);
        valueStore.put("sourceDir", this.sourceFolder);
        DeclareCudaModulesProcess.initializeTemplateParams(valueStore, this.ptx, this.sass, this.deviceLinker);
        valueStore.put("sample", this.sample.getManifestFile().getAbsolutePath());
        valueStore.put(ATTR_SAMPLE_MAIN_FILE, this.sample.getPrimaryFileRelativePath());
        valueStore.put("overwritingExistingFiles", Boolean.toString(false));
        ArrayList<IConfiguration> configs = new ArrayList<IConfiguration>();
        CfgHolder[] cfgHolderArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            CfgHolder cfg = cfgHolderArray[n2];
            configs.add(cfg.getConfiguration());
            ++n2;
        }
        template.getTemplateInfo().setConfigurations(configs);
        IStatus[] statuses = template.executeTemplateProcesses(null, false);
        if (statuses.length == 1 && statuses[0].getException() instanceof ProcessFailureException) {
            throw new CoreException(statuses[0]);
        }
    }

    public static CfgHolder[] getDefaultCfgs() {
        IToolChain tc = ManagedBuildManager.getExtensionToolChain((String)"com.nvidia.cuda.ide.toolchain.exe.release");
        return CfgHolder.cfgs2items((IConfiguration[])ManagedBuildManager.getExtensionConfigurations((IToolChain)tc, (String)"org.eclipse.cdt.build.core.buildArtefactType", (String)"org.eclipse.cdt.build.core.buildArtefactType.exe"));
    }

    private CfgHolder[] setProjectDescription(IProject project, IProgressMonitor monitor) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.createProjectDescription(project, false, false);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        monitor.worked(10);
        CfgHolder[] cfgs = InstantiateCudaSampleRunnable.getDefaultCfgs();
        if (cfgs == null || cfgs.length == 0 || cfgs[0].getConfiguration() == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), "Cannot create managed project with NULL configuration"));
        }
        Configuration cf = (Configuration)cfgs[0].getConfiguration();
        ManagedProject mProj = new ManagedProject((IResource)project, cf.getProjectType());
        info.setManagedProject((IManagedProject)mProj);
        monitor.worked(10);
        cfgs = CfgHolder.unique((CfgHolder[])cfgs);
        cfgs = CfgHolder.reorder((CfgHolder[])cfgs);
        ICConfigurationDescription cfgDebug = null;
        ICConfigurationDescription cfgFirst = null;
        int work = 50 / cfgs.length;
        CfgHolder[] cfgHolderArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            CfgHolder cfg = cfgHolderArray[n2];
            cf = (Configuration)cfg.getConfiguration();
            String id = ManagedBuildManager.calculateChildId((String)cf.getId(), null);
            Configuration config = new Configuration(mProj, cf, id, false, true);
            CConfigurationData data = config.getConfigurationData();
            ICConfigurationDescription cfgDes = des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
            config.setConfigurationDescription(cfgDes);
            config.exportArtifactInfo();
            IBuilder bld = config.getEditableBuilder();
            if (bld != null) {
                bld.setManagedBuildOn(true);
            }
            config.setName(cfg.getName());
            config.setArtifactName(mProj.getDefaultArtifactName());
            IBuildProperty b = config.getBuildProperties().getProperty(PROPERTY);
            if (cfgDebug == null && b != null && b.getValue() != null && PROP_VAL.equals(b.getValue().getId())) {
                cfgDebug = cfgDes;
            }
            if (cfgFirst == null) {
                cfgFirst = cfgDes;
            }
            monitor.worked(work);
            ++n2;
        }
        mngr.setProjectDescription(project, des);
        return cfgs;
    }

    public IProject createIProject(String name, URI location, IProgressMonitor monitor) throws CoreException {
        IProject newProject;
        monitor.beginTask(Messages.CDTCommonProjectWizard_creatingProject, 100);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject newProjectHandle = root.getProject(name);
        if (!newProjectHandle.exists()) {
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            if (location != null) {
                description.setLocationURI(location);
            }
            newProject = CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
        } else {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            newProject = newProjectHandle;
        }
        if (!newProject.isOpen()) {
            newProject.open((IProgressMonitor)new SubProgressMonitor(monitor, 25));
        }
        IProject proj = this.continueCreation(newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
        monitor.done();
        return proj;
    }

    protected IProject continueCreation(IProject prj, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Add Project Nature", 2);
            CProjectNature.addCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CCProjectNature.addCCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
        return prj;
    }
}

