/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.MultiConfiguration;
import com.nvidia.cuda.ide.build.project.MultiExecutable;
import com.nvidia.cuda.ide.build.ui.ArchitecturesSelector;
import com.nvidia.cuda.ide.build.ui.MultiModuleView;
import com.nvidia.cuda.ide.util.UiUtil;
import com.nvidia.cuda.ide.wizard.LinkerToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class BasicModuleView
extends Composite
implements ICudaProjectConfiguration.IModuleListener {
    private final CLabel compatabilityLabel;
    private final MultiConfiguration configuration;
    private final LinkerToggle linker;
    private final ArchitecturesSelector selector;

    public BasicModuleView(Composite parent, MultiConfiguration projectConfiguration, boolean dense) {
        super(parent, 0);
        this.configuration = projectConfiguration;
        int columns = Architecture.all().length + 1;
        this.setLayout((Layout)UiUtil.createNoMarginGrid(columns));
        this.linker = new LinkerToggle(this, columns, dense);
        if (!dense) {
            new Label((Composite)this, 0).setLayoutData((Object)UiUtil.createLayoutData(columns));
        }
        this.selector = new ArchitecturesSelector();
        this.selector.createControls(this, columns, !dense);
        projectConfiguration.addModuleListener(this);
        this.compatabilityLabel = new CLabel((Composite)this, 0);
        this.compatabilityLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(columns, 1).hint(50, -1).create());
        MultiExecutable executable = projectConfiguration.getExecutable();
        this.selector.setModule(executable);
        this.linker.setModule(executable);
        this.updateLabel();
    }

    @Override
    public void configurationReloaded() {
        MultiExecutable executable = this.configuration.getExecutable();
        this.selector.setModule(executable);
        this.linker.setModule(executable);
    }

    @Override
    public void moduleAdded() {
    }

    @Override
    public void modulePropertyChanged() {
        if (!this.isDisposed()) {
            MultiExecutable executable = this.configuration.getExecutable();
            this.selector.setModule(executable);
            this.linker.setModule(executable);
            this.updateLabel();
        }
    }

    @Override
    public void moduleRemoved() {
    }

    private void updateLabel() {
        MultiModuleView.findCompatibleDevices(this.compatabilityLabel, this.configuration.getExecutable(), ICudaModule.Type.fatbin);
    }
}

