/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.IArchitectureObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public final class ArchitecturesSelector {
    private Architecture minArch;
    private IArchitectureObject module;
    private Button[] physical;
    private Button[] virtual;
    private final Label[] ptxFiller = new Label[1];
    private Label ptxLabel;
    private final Collection<Architecture> rememberedP = new HashSet<Architecture>();
    private final Collection<Architecture> rememberedV = new HashSet<Architecture>();

    private static Architecture getArchitecture(Button button) {
        return (Architecture)button.getData();
    }

    private static Control setHelp(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "com.nvidia.cuda.ide.build.compute-capability");
        return control;
    }

    private boolean archIsNewer(Button button, boolean virtual) {
        Architecture ar;
        Architecture architecture = this.minArch == null ? null : (ar = virtual ? this.minArch.getVirtual() : this.minArch);
        return ar == null || ArchitecturesSelector.getArchitecture(button).compareTo(ar) >= 0;
    }

    private Button[] createCheckboxes(Composite panel, final boolean physical, int columns, Label[] fillerLabel) {
        LinkedList<Button> checkboxes = new LinkedList<Button>();
        Architecture[] architectureArray = Architecture.all();
        int n = architectureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            if (physical || !architecture.isPhysicalOnly()) {
                final Button button = new Button(panel, 32);
                ArchitecturesSelector.setHelp((Control)button);
                button.setData((Object)architecture);
                checkboxes.add(button);
                button.setText(architecture.getLabel());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ArchitecturesSelector.this.toggle(button, physical);
                    }
                });
            }
            ++n2;
        }
        if (checkboxes.size() % columns > 0) {
            Label filler = new Label(panel, 0);
            filler.setLayoutData((Object)GridDataFactory.defaultsFor((Control)filler).span(columns - checkboxes.size() % columns, 1).create());
            fillerLabel[0] = filler;
        }
        return checkboxes.toArray(new Button[checkboxes.size()]);
    }

    public void createControls(Composite parent, int columns, boolean inlineLabel) {
        this.ptxLabel = new Label(parent, 0);
        this.ptxLabel.setText("Generate PTX code:");
        ArchitecturesSelector.setHelp((Control)this.ptxLabel);
        if (!inlineLabel) {
            this.ptxLabel.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.ptxLabel).span(columns, 1).create());
        } else {
            this.ptxLabel.setLayoutData((Object)new GridData());
        }
        this.virtual = this.createCheckboxes(parent, false, columns - (inlineLabel ? 1 : 0), this.ptxFiller);
        Label label = new Label(parent, 0);
        ArchitecturesSelector.setHelp((Control)label);
        label.setText("Generate GPU code:");
        if (!inlineLabel) {
            label.setLayoutData((Object)GridDataFactory.defaultsFor((Control)label).span(columns, 1).create());
        }
        this.physical = this.createCheckboxes(parent, true, columns - (inlineLabel ? 1 : 0), new Label[1]);
        if (this.module != null) {
            this.setModule(this.module);
        }
    }

    private boolean isArchitectureEnabled(Architecture architecture, boolean separateCompile, Architecture min, boolean virtual) {
        boolean sc;
        boolean bl = sc = !separateCompile || architecture.supportSeparateCompile();
        return sc && (min == null || architecture.compareTo(min) >= 0);
    }

    public void performDefaults() {
        Button button;
        Button[] buttonArray = this.virtual;
        int n = this.virtual.length;
        int n2 = 0;
        while (n2 < n) {
            button.setSelection((button = buttonArray[n2]) == this.virtual[0]);
            ++n2;
        }
        buttonArray = this.physical;
        n = this.physical.length;
        n2 = 0;
        while (n2 < n) {
            button.setSelection((button = buttonArray[n2]) == this.physical[0]);
            ++n2;
        }
    }

    public void setMinArchitecture(Architecture arch) {
        this.minArch = arch;
        this.updateCheckBoxes();
    }

    public void setModule(IArchitectureObject module) {
        this.module = module;
        if (this.virtual != null) {
            Architecture architecture;
            Button button;
            Boolean linking = module.isDeviceLinking();
            boolean separateCompilation = linking != null ? linking : false;
            Button[] buttonArray = this.virtual;
            int n = this.virtual.length;
            int n2 = 0;
            while (n2 < n) {
                button = buttonArray[n2];
                architecture = ArchitecturesSelector.getArchitecture(button);
                button.setEnabled((!separateCompilation || architecture.supportSeparateCompile()) && this.archIsNewer(button, false));
                ++n2;
            }
            buttonArray = this.physical;
            n = this.physical.length;
            n2 = 0;
            while (n2 < n) {
                button = buttonArray[n2];
                architecture = ArchitecturesSelector.getArchitecture(button);
                button.setEnabled((!separateCompilation || architecture.supportSeparateCompile()) && this.archIsNewer(button, false));
                ++n2;
            }
            this.toggleButtons(module.getPhysicalArchitecturesForAllConfigurations(), module.getPhysicalArchitecturesForSomeConfigurations(), module.isDeviceLinking(), this.physical);
            this.toggleButtons(module.getVirtualArchitecturesForAllConfigurations(), module.getVirtualArchitecturesForSomeConfigurations(), module.isDeviceLinking(), this.virtual);
        }
    }

    protected void toggle(Button button, boolean isPhysical) {
        Architecture architecture = ArchitecturesSelector.getArchitecture(button);
        if (button.getSelection()) {
            this.module.enableArchitecture(architecture, isPhysical);
        } else {
            this.module.disableArchitecture(architecture, isPhysical);
        }
    }

    private void toggleButtons(int allConfigs, int someConfigs, Boolean linkerMode, Button[] buttons) {
        boolean separateCompile = linkerMode != null && linkerMode != false;
        Button[] buttonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            Object data = button.getData();
            Architecture arch = (Architecture)data;
            boolean inSome = (someConfigs & arch.getBit()) != 0;
            boolean inAll = (allConfigs & arch.getBit()) != 0;
            button.setSelection(!(!inAll && !inSome || this.minArch != null && this.minArch.compareTo(arch) > 0 || separateCompile && !arch.supportSeparateCompile()));
            button.setGrayed(inSome);
            ++n2;
        }
    }

    private void updateButtons(Button[] vb, Architecture min, Collection<Architecture> remembered, boolean isVirtual) {
        boolean separateCompilation = this.module != null ? (this.module.isDeviceLinking() != null ? this.module.isDeviceLinking() : false) : false;
        Button[] buttonArray = vb;
        int n = vb.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            Architecture arch = ArchitecturesSelector.getArchitecture(button);
            boolean enabled = this.isArchitectureEnabled(arch, separateCompilation, min, isVirtual);
            if (button.isEnabled()) {
                if (!enabled) {
                    button.setEnabled(false);
                    if (button.getSelection()) {
                        remembered.add(arch);
                        button.setSelection(false);
                        this.toggle(button, false);
                    }
                }
            } else if (enabled) {
                button.setSelection(remembered.remove(arch));
                button.setEnabled(true);
                this.toggle(button, false);
            }
            ++n2;
        }
    }

    private void updateCheckBoxes() {
        Architecture v = this.minArch != null ? this.minArch.getVirtual() : null;
        this.updateButtons(this.virtual, v, this.rememberedV, true);
        this.updateButtons(this.physical, this.minArch, this.rememberedP, false);
    }
}

