/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.nvccsupport;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector3;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollectorCleaner;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredScannerInfoStore;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SafeRunner;
import org.w3c.dom.Element;

public final class SICollector
implements IScannerInfoCollector3 {
    public static final String COLLECTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".PerProjectSICollector";
    private IProject project;
    private InfoContext context;
    private boolean isBuiltinConfig = false;
    private final Map<ScannerInfoTypes, List<String>> discoveredSI = new HashMap<ScannerInfoTypes, List<String>>();
    private final List<String> sumDiscoveredIncludes = new ArrayList<String>();
    private boolean scPersisted = false;

    public void setProject(IProject project) {
        this.project = project;
        this.context = new InfoContext(project);
    }

    public synchronized void contributeToScannerConfig(Object resource, Map scannerInfo, boolean isBuiltinConfig) {
        this.isBuiltinConfig = isBuiltinConfig;
        try {
            this.contributeToScannerConfig(resource, scannerInfo);
        }
        finally {
            this.isBuiltinConfig = false;
        }
    }

    public synchronized void contributeToScannerConfig(Object resource, Map scannerInfo) {
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (!(resource instanceof IResource)) {
            errorMessage = "resource is not an IResource";
        } else if (((IResource)resource).getProject() == null) {
            errorMessage = "project is null";
        } else if (!((IResource)resource).getProject().equals((Object)this.project)) {
            errorMessage = "wrong project";
        }
        if (errorMessage != null) {
            return;
        }
        if (this.scPersisted) {
            this.discoveredSI.clear();
            this.scPersisted = false;
        }
        try {
            if (this.project.hasNature("org.eclipse.cdt.core.cnature") || this.project.hasNature("org.eclipse.cdt.core.ccnature")) {
                for (Object name : scannerInfo.keySet()) {
                    ScannerInfoTypes siType = (ScannerInfoTypes)name;
                    List delta = (List)scannerInfo.get(siType);
                    this.filterNonExistingIncludeFolders(delta, siType);
                    List<String> discovered = this.discoveredSI.get(siType);
                    if (discovered == null) {
                        discovered = new ArrayList<String>(delta);
                        this.discoveredSI.put(siType, discovered);
                        continue;
                    }
                    boolean addSorted = !this.isBuiltinConfig && siType.equals(ScannerInfoTypes.INCLUDE_PATHS);
                    this.contribute(this.filterNonExistingIncludeFolders(discovered, siType), delta, addSorted);
                }
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log((Throwable)e);
        }
    }

    private List<String> filterNonExistingIncludeFolders(List<String> discovered, ScannerInfoTypes siType) {
        if (siType == ScannerInfoTypes.INCLUDE_PATHS && discovered != null) {
            Iterator<String> i = discovered.iterator();
            while (i.hasNext()) {
                String path = i.next();
                if (new File(path).isDirectory()) continue;
                i.remove();
            }
        }
        return discovered;
    }

    private boolean contribute(List<String> discovered, List<String> delta, boolean ordered) {
        if (delta == null || delta.isEmpty()) {
            return false;
        }
        return this.addItemsWithOrder(discovered, delta, ordered);
    }

    private boolean addItemsWithOrder(List<String> sumIncludes, List<String> includes, boolean ordered) {
        if (includes.isEmpty()) {
            return false;
        }
        boolean addedIncludes = false;
        int insertionPoint = ordered ? 0 : sumIncludes.size();
        for (String item : includes) {
            int pos = sumIncludes.indexOf(item);
            if (pos >= 0) {
                if (!ordered) continue;
                insertionPoint = pos + 1;
                continue;
            }
            sumIncludes.add(insertionPoint++, item);
            addedIncludes = true;
        }
        return addedIncludes;
    }

    public synchronized void updateScannerConfiguration(IProgressMonitor monitor) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo pathInfo;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.project, this.context)) instanceof IDiscoveredPathManager.IPerProjectDiscoveredPathInfo) {
            IDiscoveredPathManager.IPerProjectDiscoveredPathInfo projectPathInfo = (IDiscoveredPathManager.IPerProjectDiscoveredPathInfo)pathInfo;
            monitor.beginTask(MakeMessages.getString((String)"ScannerInfoCollector.Processing"), 100);
            monitor.subTask(MakeMessages.getString((String)"ScannerInfoCollector.Processing"));
            if (this.scannerConfigNeedsUpdate(projectPathInfo)) {
                monitor.worked(50);
                monitor.subTask(String.valueOf(MakeMessages.getString((String)"ScannerInfoCollector.Updating")) + this.project.getName());
                try {
                    ArrayList<IProject> resourceDelta = new ArrayList<IProject>(1);
                    resourceDelta.add(this.project);
                    MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(this.context, pathInfo, this.context.isDefaultContext(), resourceDelta);
                    monitor.worked(50);
                }
                catch (CoreException e) {
                    MakeCorePlugin.log((Throwable)e);
                }
            }
            monitor.done();
            this.scPersisted = true;
        }
    }

    private boolean scannerConfigNeedsUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedIncludes = this.includePathsNeedUpdate(discPathInfo);
        boolean addedSymbols = this.definedSymbolsNeedUpdate(discPathInfo);
        return addedIncludes | addedSymbols;
    }

    private boolean includePathsNeedUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedIncludes = false;
        List<String> discoveredIncludes = this.discoveredSI.get(ScannerInfoTypes.INCLUDE_PATHS);
        if (discoveredIncludes != null) {
            LinkedHashMap<String, Boolean> newPersistedIncludes;
            addedIncludes = this.addItemsWithOrder(this.sumDiscoveredIncludes, discoveredIncludes, true);
            List<String> finalSumIncludes = this.sumDiscoveredIncludes;
            LinkedHashMap<String, Boolean> persistedIncludes = discPathInfo.getIncludeMap();
            ArrayList<String> persistedKeyList = new ArrayList<String>(persistedIncludes.keySet());
            addedIncludes = this.addItemsWithOrder(persistedKeyList, finalSumIncludes, true);
            if (addedIncludes) {
                newPersistedIncludes = new LinkedHashMap<String, Boolean>(persistedKeyList.size());
                for (String include : persistedKeyList) {
                    if (persistedIncludes.containsKey(include)) {
                        newPersistedIncludes.put(include, (Boolean)persistedIncludes.get(include));
                        continue;
                    }
                    newPersistedIncludes.put(include, false);
                }
            } else {
                newPersistedIncludes = persistedIncludes;
            }
            discPathInfo.setIncludeMap((LinkedHashMap)newPersistedIncludes);
        }
        return addedIncludes;
    }

    private boolean definedSymbolsNeedUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        List<String> discoveredSymbols = this.discoveredSI.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
        if (discoveredSymbols != null) {
            LinkedHashMap symbols = new LinkedHashMap();
            ScannerConfigUtil.scAddSymbolsList2SymbolEntryMap(symbols, discoveredSymbols, (boolean)true);
            discPathInfo.setSymbolMap(symbols);
            return true;
        }
        return false;
    }

    public List<String> getCollectedScannerInfo(Object resource, ScannerInfoTypes type) {
        List<String> rv = null;
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (!(resource instanceof IResource)) {
            errorMessage = "resource is not an IResource";
        } else if (((IResource)resource).getProject() == null) {
            errorMessage = "project is null";
        } else if (((IResource)resource).getProject() != this.project) {
            errorMessage = "wrong project";
        }
        if (errorMessage == null && resource != null && this.project.equals((Object)((IResource)resource).getProject())) {
            rv = this.discoveredSI.get(type);
        }
        return rv;
    }

    public List<String> getIncludePaths() {
        return this.sumDiscoveredIncludes;
    }

    public void serialize(Element root) {
    }

    public void deserialize(Element root) {
    }

    public void deleteAllPaths(IResource resource) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            this.sumDiscoveredIncludes.clear();
        }
    }

    public void deletePath(IResource resource, String path) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            this.sumDiscoveredIncludes.remove(path);
        }
    }

    public IDiscoveredPathManager.IDiscoveredPathInfo createPathInfoObject() {
        DiscoveredPathInfo pathInfo = new DiscoveredPathInfo(this.project);
        try {
            DiscoveredScannerInfoStore.getInstance().loadDiscoveredScannerInfoFromState(this.project, this.context, (IDiscoveredPathManager.IDiscoveredScannerInfoSerializable)pathInfo);
        }
        catch (CoreException e) {
            MakeCorePlugin.log((Throwable)e);
        }
        return pathInfo;
    }

    public static void calculateCompilerBuiltins(final IProject project) throws CModelException {
        SICollector.createDiscoveredPathContainer(project, (IProgressMonitor)new NullProgressMonitor());
        String scdProfileId = ScannerConfigProfileManager.PER_PROJECT_PROFILE_ID;
        SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, scdProfileId);
        final IScannerConfigBuilderInfo2 buildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2((Preferences)MakeCorePlugin.getDefault().getPluginPreferences(), (String)scdProfileId, (boolean)true);
        final IScannerInfoCollector collector = profileInstance.getScannerInfoCollector();
        if (collector instanceof IScannerInfoCollectorCleaner) {
            ((IScannerInfoCollectorCleaner)collector).deleteAll((IResource)project);
        }
        final IExternalScannerInfoProvider esiProvider = profileInstance.createExternalScannerInfoProvider("specsFile");
        ISafeRunnable runnable = new ISafeRunnable(){

            public void run() throws CoreException {
                NullProgressMonitor monitor = new NullProgressMonitor();
                esiProvider.invokeProvider((IProgressMonitor)monitor, (IResource)project, "specsFile", buildInfo, collector);
                if (collector instanceof IScannerInfoCollector2) {
                    IScannerInfoCollector2 collector2 = (IScannerInfoCollector2)collector;
                    collector2.updateScannerConfiguration((IProgressMonitor)monitor);
                }
            }

            public void handleException(Throwable exception) {
                if (exception instanceof OperationCanceledException) {
                    throw (OperationCanceledException)exception;
                }
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    private static void createDiscoveredPathContainer(IProject project, IProgressMonitor monitor) throws CModelException {
        IPathEntry[] entries;
        ArrayList<IPathEntry> newEntries;
        IContainerEntry container = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
        ICProject cProject = CoreModel.getDefault().create(project);
        if (cProject != null && !(newEntries = new ArrayList<IPathEntry>(Arrays.asList(entries = cProject.getRawPathEntries()))).contains(container)) {
            newEntries.add((IPathEntry)container);
            cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), monitor);
        }
        MakeCorePlugin.getDefault().getDiscoveryManager().removeDiscoveredInfo(project);
    }

    public void setInfoContext(InfoContext context) {
        this.context = context;
        this.project = context.getProject();
    }

    public InfoContext getContext() {
        return this.context;
    }
}

