/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.nvccsupport;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.util.CudaProjectUtil;
import java.io.IOException;
import java.net.URL;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.make.internal.core.scannerconfig2.DefaultRunSIProvider;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.osgi.framework.Bundle;

public class NvccSpecsRunSIProvider
extends DefaultRunSIProvider {
    protected String[] prepareArguments(boolean isDefaultCommand) {
        String filename = this.getFileName();
        String[] args = super.prepareArguments(isDefaultCommand);
        String[] projectConfigArgs = this.getConfigurationArguments(filename);
        String[] result = new String[args.length + 1 + projectConfigArgs.length];
        System.arraycopy(args, 0, result, 0, args.length);
        if (projectConfigArgs.length > 0) {
            System.arraycopy(projectConfigArgs, 0, result, args.length, projectConfigArgs.length);
        }
        try {
            result[result.length - 1] = this.getFilePath(filename);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    private String getFileName() {
        ILanguage language = this.buildInfo.getContext().getLanguage();
        if (language == null || "com.nvidia.cuda.ide.editor.cudac".equals(language.getId())) {
            return "sample.cu";
        }
        if ("org.eclipse.cdt.core.gcc".equals(language.getId())) {
            return "sample.c";
        }
        if ("org.eclipse.cdt.core.g++".equals(language.getId())) {
            return "sample.cpp";
        }
        throw new IllegalStateException(language.getId());
    }

    private String[] getConfigurationArguments(String filename) {
        Path input;
        ITool tool;
        IManagedBuildInfo info;
        if (this.resource != null && (info = ManagedBuildManager.getBuildInfo((IResource)this.resource)) != null && (tool = info.getToolFromInputExtension((input = new Path(filename)).getFileExtension())) != null) {
            IConfiguration configuration = info.getDefaultConfiguration();
            ICConfigurationDescription description = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)configuration);
            try {
                String archs = CudaProjectUtil.getArchitectureOptions(description);
                String flags = String.valueOf(tool.getToolCommandFlagsString((IPath)input, (IPath)new Path("a.o"))) + " " + archs + " -c";
                return flags.split(" +");
            }
            catch (BuildException e) {
                Activator.log((Exception)((Object)e));
            }
            catch (CoreException e1) {
                Activator.log((Exception)((Object)e1));
            }
        }
        return new String[0];
    }

    private String getFilePath(String filename) throws IOException {
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("compiler-res").append(filename), null);
        URL fileURL = FileLocator.toFileURL((URL)url);
        return fileURL.getPath();
    }

    protected IPath getCommandToLaunch() {
        IPath commandToLaunch = super.getCommandToLaunch();
        try {
            return Path.fromOSString((String)VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(commandToLaunch.toOSString(), true));
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return commandToLaunch;
        }
    }
}

