/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.core;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.OS;
import com.nvidia.common.util.YesNoMaybe;
import com.nvidia.cuda.ide.build.core.Activator;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;

public enum Cpu {
    Native(new String[0]),
    ARM("--target-cpu-architecture", "ARM", "-m32"),
    x86("--target-cpu-architecture", "x86", "-m32"),
    x86_64("--target-cpu-architecture", "x86", "-m64");

    private static final String ATTR_CPU = "cpu";
    private static final Map<String, Cpu> COMPILER_OPTIONS_LOOKUP;
    private static final Map<String, Cpu> LINKER_OPTIONS_LOOKUP;
    private static final String STORAGE_LOCAL_TARGET = "nsight.localTarget";
    private final String[] compilerFlags;
    private YesNoMaybe supported = null;

    static {
        COMPILER_OPTIONS_LOOKUP = new TreeMap<String, Cpu>();
        LINKER_OPTIONS_LOOKUP = new TreeMap<String, Cpu>();
        COMPILER_OPTIONS_LOOKUP.put("nvcc.compiler.machine32", x86);
        COMPILER_OPTIONS_LOOKUP.put("nvcc.compiler.machine64", x86_64);
        LINKER_OPTIONS_LOOKUP.put("nvcc.linker.machine32", x86);
        LINKER_OPTIONS_LOOKUP.put("nvcc.linker.machine64", x86_64);
    }

    public static Cpu fromName(String cpu) {
        if (CoreUtil.isNullOrEmpty((String)cpu)) {
            return Native;
        }
        return Cpu.valueOf(cpu.trim());
    }

    private static Cpu getCpu(ICConfigurationDescription configuration) {
        IConfiguration c = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configuration);
        if (c != null) {
            Cpu compilerCpu = Cpu.getCpuFromToolOption(c, "nvcc.compiler", "nvcc.compiler.machine", COMPILER_OPTIONS_LOOKUP);
            if (compilerCpu == null) {
                return Cpu.getCpuFromToolOption(c, "nvcc.linker", "nvcc.linker.option.machine", LINKER_OPTIONS_LOOKUP);
            }
            return compilerCpu;
        }
        return null;
    }

    private static Cpu getCpu(ICProjectDescription description) throws CoreException {
        ICStorageElement element = description.getStorage(STORAGE_LOCAL_TARGET, false);
        if (element == null) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = description.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription configuration = iCConfigurationDescriptionArray[n2];
                Cpu cpu = Cpu.getCpu(configuration);
                if (cpu != null) {
                    return cpu;
                }
                ++n2;
            }
            return Native;
        }
        return Cpu.fromName(element.getAttribute(ATTR_CPU));
    }

    private static Cpu getCpuFromToolOption(IConfiguration configuration, String toolId, String optionId, Map<String, Cpu> lookup) {
        Object value = Cpu.getToolOption(configuration, toolId, optionId);
        if (value != null) {
            return lookup.get(value.toString());
        }
        return null;
    }

    public static Cpu getLocalTargetCpu(IProject project) {
        ICConfigurationDescription[] configurations;
        ICProjectDescription description;
        if (project != null && (description = CoreModel.getDefault().getProjectDescription(project, false)) != null && (configurations = description.getConfigurations()) != null && configurations.length > 0) {
            try {
                return Cpu.getCpu(Cpu.getProjectDescription(project, false));
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
        return Native;
    }

    private static ICProjectDescription getProjectDescription(IProject project, boolean writeable) {
        return CoreModel.getDefault().getProjectDescription(project, writeable);
    }

    public static Cpu getRemoteTargetCpu(SyncConfig config) {
        if (SyncConfigManager.isLocal((SyncConfig)config)) {
            return Cpu.getLocalTargetCpu(config.getProject());
        }
        return Cpu.fromName(config.getProperty(Cpu.class.getName()));
    }

    private static Object getToolOption(IConfiguration configuration, String toolId, String optionId) {
        IOption option;
        ITool[] tool = configuration.getToolsBySuperClassId(toolId);
        if (tool != null && tool.length == 1 && (option = tool[0].getOptionBySuperClassId(optionId)) != null) {
            return option.getValue();
        }
        return null;
    }

    protected static boolean hasArmTarget(ICudaToolkit toolkit) {
        if (toolkit != null) {
            File file = new Path(toolkit.getBinDirectory()).append("../targets/armv7-linux-gnueabihf").toFile();
            return file.isDirectory();
        }
        return false;
    }

    private static boolean isRunningOnArm() {
        return "arm".equalsIgnoreCase(Platform.getOSArch());
    }

    private Cpu(String ... compilerFlags) {
        this.compilerFlags = compilerFlags;
    }

    private Boolean checkSupported() {
        if (Cpu.isRunningOnArm()) {
            if (this != ARM && this != Native) {
                return false;
            }
            return true;
        }
        switch (this) {
            case ARM: {
                if (OS.local() == OS.Linux) {
                    return this.hasArmLibs() ? Boolean.valueOf(true) : null;
                }
                return false;
            }
            case x86_64: {
                return this.is64BitSystem();
            }
            case Native: 
            case x86: {
                return true;
            }
        }
        throw new IllegalArgumentException(this.name());
    }

    private boolean is64BitSystem() {
        return "x86_64".equals(Platform.getOSArch());
    }

    public String getCompilerBinaryName() {
        switch (this) {
            case ARM: {
                return "arm-linux-gnueabihf-g++-4.6";
            }
            case Native: 
            case x86: 
            case x86_64: {
                return null;
            }
        }
        throw new IllegalArgumentException(this.name());
    }

    public String[] getNvccFlags() {
        return this.compilerFlags;
    }

    private boolean hasArmLibs() {
        if (Cpu.isRunningOnArm()) {
            return true;
        }
        try {
            return (Boolean)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, Boolean>(){

                public Boolean runWithService(IToolkitManager service) throws CoreException {
                    return Cpu.hasArmTarget(service.getDefaultToolkit());
                }
            });
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return false;
        }
    }

    public YesNoMaybe isSupportedOnLocalSystem() {
        if (this.supported == null) {
            Boolean isSupported = this.checkSupported();
            this.supported = isSupported == null ? YesNoMaybe.Maybe : (isSupported != false ? YesNoMaybe.Yes : YesNoMaybe.No);
        }
        return this.supported;
    }

    public void setCpu(IProject project) {
        try {
            ICProjectDescription projectDescription = Cpu.getProjectDescription(project, true);
            if (!this.equals((Object)Cpu.getCpu(projectDescription))) {
                ICStorageElement element = projectDescription.getStorage(STORAGE_LOCAL_TARGET, true);
                element.setAttribute(ATTR_CPU, this.name());
                CoreModel.getDefault().setProjectDescription(project, projectDescription);
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    public void setCpu(SyncConfig config) {
        config.setProperty(Cpu.class.getName(), this.name());
    }

    public String toString() {
        switch (this) {
            case x86: {
                return "x86 (32-Bit)";
            }
            case x86_64: {
                return "x86 (64-Bit)";
            }
        }
        return super.toString();
    }
}

