/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICDIDebugger;
import org.eclipse.cdt.debug.core.ICDIDebugger2;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;

public class LocalCDILaunchDelegate
extends AbstractCLaunchDelegate {
    @Override
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("run")) {
            this.runLocalApplication(config, launch, monitor);
        }
        if (mode.equals("debug")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    private void runLocalApplication(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.LocalCDILaunchDelegate_0, 10);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        try {
            IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
            File wd = this.getWorkingDirectory(config);
            if (wd == null) {
                wd = new File(System.getProperty("user.home", "."));
            }
            String[] arguments = this.getProgramArgumentsArray(config);
            ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
            command.add(exePath.toOSString());
            command.addAll(Arrays.asList(arguments));
            String[] commandArray = command.toArray(new String[command.size()]);
            boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            monitor.worked(2);
            Process process = this.exec(commandArray, this.getEnvironment(config), wd, usePty);
            monitor.worked(6);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
        }
        finally {
            monitor.done();
        }
    }

    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.LocalCDILaunchDelegate_1, 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("run")) {
                this.launchLocalDebugSession(config, launch, monitor);
            }
            if (debugMode.equals("attach")) {
                this.launchAttachDebugSession(config, launch, monitor);
            }
            if (debugMode.equals("core")) {
                this.launchCoreDebugSession(config, launch, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void launchLocalDebugSession(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(LaunchMessages.LocalCDILaunchDelegate_2);
        ICDISession dsession = null;
        try {
            try {
                IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
                IBinaryParser.IBinaryObject exeFile = null;
                if (exePath != null) {
                    exeFile = this.verifyBinary(project, exePath);
                }
                ICDebugConfiguration debugConfig = this.getDebugConfig(config);
                this.setDefaultSourceLocator(launch, config);
                dsession = this.createCDISession(config, launch, debugConfig, monitor);
                monitor.worked(6);
                this.setRuntimeOptions(config, dsession);
                monitor.worked(1);
                boolean stopInMain = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                String stopSymbol = null;
                if (stopInMain) {
                    stopSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
                }
                ICDITarget[] targets = dsession.getTargets();
                int i = 0;
                while (i < targets.length) {
                    Process process = targets[i].getProcess();
                    IProcess iprocess = null;
                    if (process != null) {
                        iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                    }
                    CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (String)stopSymbol, (boolean)true);
                    ++i;
                }
            }
            catch (CoreException e) {
                try {
                    if (dsession != null) {
                        dsession.terminate();
                    }
                }
                catch (CDIException cDIException) {}
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void launchAttachDebugSession(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath exePath;
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(LaunchMessages.LocalCDILaunchDelegate_3);
        ILaunchConfigurationWorkingCopy wc = null;
        int pid = config.getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
        if (pid == -1) {
            pid = this.promptForProcessID(config);
            if (pid == -1) {
                this.cancel(LaunchMessages.LocalCDILaunchDelegate_4, 107);
            }
            wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", pid);
            try {
                wc.doSave().launch("debug", (IProgressMonitor)new SubProgressMonitor(monitor, 9));
            }
            finally {
                wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", null);
                wc.doSave();
            }
            this.cancel("", -1);
        }
        if ((exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config)) == null) {
            exePath = this.getProgramPathForPid(pid);
        }
        ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
        IBinaryParser.IBinaryObject exeFile = null;
        if (exePath != null) {
            exeFile = this.verifyBinary(project, exePath);
        }
        ICDebugConfiguration debugConfig = this.getDebugConfig(config);
        this.setDefaultSourceLocator(launch, config);
        ICDISession dsession = this.createCDISession(config, launch, debugConfig, monitor);
        monitor.worked(7);
        try {
            try {
                ICDITarget[] targets = dsession.getTargets();
                int i = 0;
                while (i < targets.length) {
                    CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), null, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)true, (boolean)false);
                    ++i;
                }
            }
            catch (CoreException e) {
                try {
                    dsession.terminate();
                }
                catch (CDIException cDIException) {}
                throw e;
            }
        }
        finally {
            if (wc != null) {
                wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", null);
            }
            monitor.done();
        }
    }

    private IPath getProgramPathForPid(int pid) {
        IProcessList processList = null;
        try {
            processList = CCorePlugin.getDefault().getProcessList();
        }
        catch (CoreException coreException) {}
        if (processList != null) {
            IProcessInfo[] pInfos = processList.getProcessList();
            int i = 0;
            while (i < pInfos.length) {
                IProcessInfo processInfo = pInfos[i];
                if (processInfo.getPid() == pid) {
                    String name = processInfo.getName();
                    if (name == null) break;
                    return new Path(name);
                }
                ++i;
            }
        }
        return null;
    }

    private void launchCoreDebugSession(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.beginTask(LaunchMessages.LocalCDILaunchDelegate_5, 10);
        ICDISession dsession = null;
        ILaunchConfigurationWorkingCopy wc = null;
        ICDebugConfiguration debugConfig = this.getDebugConfig(config);
        String path = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null);
        if (path == null || path.length() == 0) {
            File file;
            ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
            IPath corefile = this.promptForCoreFilePath((IProject)project.getResource(), debugConfig);
            if (corefile == null) {
                this.cancel(LaunchMessages.LocalCDILaunchDelegate_6, 108);
            }
            if (!(file = new File(corefile.toString())).exists() || !file.canRead()) {
                this.cancel(LaunchMessages.LocalCDILaunchDelegate_7, 108);
            }
            wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", corefile.toString());
            wc.launch("debug", (IProgressMonitor)new SubProgressMonitor(monitor, 9));
            wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null);
            this.cancel("", -1);
        }
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
        IBinaryParser.IBinaryObject exeFile = null;
        if (exePath != null) {
            exeFile = this.verifyBinary(project, exePath);
        }
        this.setDefaultSourceLocator(launch, config);
        dsession = this.createCDISession(config, launch, debugConfig, monitor);
        monitor.worked(7);
        try {
            try {
                ICDITarget[] targets = dsession.getTargets();
                int i = 0;
                while (i < targets.length) {
                    Process process = targets[i].getProcess();
                    IProcess iprocess = null;
                    if (process != null) {
                        iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                    }
                    CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (boolean)false);
                    ++i;
                }
            }
            catch (CoreException e) {
                try {
                    if (dsession != null) {
                        dsession.terminate();
                    }
                }
                catch (CDIException cDIException) {}
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    private ICDISession launchOldDebugSession(ILaunchConfiguration config, ILaunch launch, ICDIDebugger debugger, IProgressMonitor monitor) throws CoreException {
        IBinaryParser.IBinaryObject exeFile = null;
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
        if (exePath != null) {
            exeFile = this.verifyBinary(project, exePath);
        }
        return debugger.createDebuggerSession(launch, exeFile, monitor);
    }

    private ICDISession launchDebugSession(ILaunchConfiguration config, ILaunch launch, ICDIDebugger2 debugger, IProgressMonitor monitor) throws CoreException {
        IPath path = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        File exeFile = path != null ? path.toFile() : null;
        return debugger.createSession(launch, exeFile, monitor);
    }

    @Override
    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }

    protected Process exec(String[] cmdLine, String[] environ, File workingDirectory, boolean usePty) throws CoreException {
        Process p;
        block4: {
            p = null;
            try {
                p = workingDirectory == null ? ProcessFactory.getFactory().exec(cmdLine, environ) : (usePty && PTY.isSupported() ? ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory, new PTY()) : ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory));
            }
            catch (IOException e) {
                if (p != null) {
                    p.destroy();
                }
                this.abort(LaunchMessages.LocalCDILaunchDelegate_8, e, 150);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 100, LaunchMessages.LocalCDILaunchDelegate_9, (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, (Object)this)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block4;
                p = this.exec(cmdLine, environ, null, usePty);
            }
        }
        return p;
    }

    protected int promptForProcessID(ILaunchConfiguration config) throws CoreException {
        Object result;
        Status fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
        Status processPrompt = new Status(1, "org.eclipse.cdt.launch", 100, "", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)fPromptStatus);
        if (prompter != null && (result = prompter.handleStatus((IStatus)processPrompt, (Object)config)) instanceof Integer) {
            return (Integer)result;
        }
        return -1;
    }

    protected IPath promptForCoreFilePath(IProject project, ICDebugConfiguration debugConfig) throws CoreException {
        Object result;
        Status fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
        Status processPrompt = new Status(1, "org.eclipse.cdt.launch", 1001, "", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)fPromptStatus);
        if (prompter != null && (result = prompter.handleStatus((IStatus)processPrompt, (Object)new Object[]{project, debugConfig})) instanceof IPath) {
            return (IPath)result;
        }
        return null;
    }

    @Override
    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug") && "core".equals(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run"))) {
            return true;
        }
        return super.preLaunchCheck(config, mode, monitor);
    }

    private void setRuntimeOptions(ILaunchConfiguration config, ICDISession session) throws CoreException {
        String[] arguments = this.getProgramArgumentsArray(config);
        try {
            ICDITarget[] dtargets = session.getTargets();
            int i = 0;
            while (i < dtargets.length) {
                ICDIRuntimeOptions opt = dtargets[i].getRuntimeOptions();
                opt.setArguments(arguments);
                File wd = this.getWorkingDirectory(config);
                if (wd != null) {
                    opt.setWorkingDirectory(wd.getAbsolutePath());
                }
                opt.setEnvironment(this.getEnvironmentAsProperty(config));
                ++i;
            }
        }
        catch (CDIException e) {
            this.abort(LaunchMessages.LocalCDILaunchDelegate_10, e, 150);
        }
    }

    private ICDISession createCDISession(ILaunchConfiguration config, ILaunch launch, ICDebugConfiguration debugConfig, IProgressMonitor monitor) throws CoreException {
        ICDISession session = null;
        ICDIDebugger debugger = debugConfig.createDebugger();
        session = debugger instanceof ICDIDebugger2 ? this.launchDebugSession(config, launch, (ICDIDebugger2)debugger, monitor) : this.launchOldDebugSession(config, launch, debugger, monitor);
        return session;
    }

    @Override
    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String debugMode = configuration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if (debugMode.equals("attach")) {
            return false;
        }
        return super.buildForLaunch(configuration, mode, monitor);
    }
}

