/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.gdb.launching.IProcessExtendedInfo;

@Immutable
class ProcessInfo
implements IProcessExtendedInfo,
Comparable<ProcessInfo> {
    private final int pid;
    private final String name;
    private final String[] cores;
    private final String ownerId;

    public ProcessInfo(int pid, String name) {
        this(pid, name, null, null);
    }

    public ProcessInfo(int pid, String name, String[] cores, String owner) {
        this.pid = pid;
        this.name = name;
        this.cores = cores;
        this.ownerId = owner;
    }

    public String getName() {
        return this.name;
    }

    public int getPid() {
        return this.pid;
    }

    public String[] getCores() {
        return this.cores;
    }

    public String getOwner() {
        return this.ownerId;
    }

    @Override
    public int compareTo(ProcessInfo other) {
        int nameCompare = this.getName().compareTo(other.getName());
        if (nameCompare != 0) {
            return nameCompare;
        }
        return this.getPid() < other.getPid() ? -1 : 1;
    }
}

