/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitObjectMapping;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GitContainerMapping
extends GitObjectMapping {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();

    public GitContainerMapping(GitModelObjectContainer gitCommit) {
        super(gitCommit);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        GitModelObject[] children = ((GitModelObjectContainer)((Object)this.getModelObject())).getChildren();
        ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
        GitModelObject[] gitModelObjectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            GitModelObject child = gitModelObjectArray[n2];
            if (child.isContainer()) {
                result.addAll(this.createTraversalForContainer(child));
            } else {
                result.add(this.createTraversalForFile(child));
            }
            ++n2;
        }
        result.removeAll(Collections.singleton(null));
        return result.toArray(new ResourceTraversal[result.size()]);
    }

    private List<ResourceTraversal> createTraversalForContainer(GitModelObject child) {
        GitModelObject[] containerChildren = child.getChildren();
        ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
        GitModelObject[] gitModelObjectArray = containerChildren;
        int n = containerChildren.length;
        int n2 = 0;
        while (n2 < n) {
            GitModelObject aChild = gitModelObjectArray[n2];
            if (aChild.isContainer()) {
                result.addAll(this.createTraversalForContainer(aChild));
            } else {
                result.add(this.createTraversalForFile(aChild));
            }
            ++n2;
        }
        return result;
    }

    private ResourceTraversal createTraversalForFile(GitModelObject aChild) {
        IPath childLocation = aChild.getLocation();
        IFile file = ROOT.getFileForLocation(childLocation);
        if (file == null) {
            file = ROOT.getFile(childLocation);
        }
        ResourceTraversal traversal = new ResourceTraversal(new IResource[]{file}, 1, 16);
        return traversal;
    }
}

