/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import org.eclipse.egit.ui.internal.commit.DiffStyleRangeFormatter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class DiffViewer
extends SourceViewer {
    private DiffStyleRangeFormatter formatter;
    private DeviceResourceManager colors = new DeviceResourceManager((Device)PlatformUI.getWorkbench().getDisplay());
    private LineNumberRulerColumn lineNumberRuler;
    private Color hunkBackgroundColor;
    private Color hunkForegroundColor;
    private Color addBackgroundColor;
    private Color addForegroundColor;
    private Color removeBackgroundColor;
    private Color removeForegroundColor;
    private Color headlineBackgroundColor;
    private Color headlineForegroundColor;
    private Font headlineFont;
    private IPropertyChangeListener themeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("CHANGE_CURRENT_THEME".equals(property) || "org.eclipse.egit.ui.DiffAddBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffAddForegroundColor".equals(property) || "org.eclipse.egit.ui.DiffHunkBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffHunkForegroundColor".equals(property) || "org.eclipse.egit.ui.DiffHeadlineBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffHeadlineForegroundColor".equals(property) || "org.eclipse.egit.ui.DiffHeadlineFont".equals(property) || "org.eclipse.egit.ui.DiffRemoveBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffRemoveForegroundColor".equals(property)) {
                DiffViewer.this.refreshDiffColors();
                DiffViewer.this.refreshDiffFonts();
                DiffViewer.this.refreshStyleRanges();
            }
        }
    };
    private IPropertyChangeListener editorPrefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            DiffViewer.this.styleViewer();
        }
    };

    public DiffViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
        this.setDocument((IDocument)new Document());
        SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this, null, null, EditorsUI.getSharedTextColors());
        support.setCursorLinePainterPreferenceKeys("currentLine", "currentLineColor");
        support.install(EditorsUI.getPreferenceStore());
        if (ruler instanceof CompositeRuler) {
            this.lineNumberRuler = new LineNumberRulerColumn();
            ((CompositeRuler)ruler).addDecorator(0, (IVerticalRulerColumn)this.lineNumberRuler);
        }
        this.initListeners();
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EditorsUI.getPreferenceStore().removePropertyChangeListener(DiffViewer.this.editorPrefListener);
                PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(DiffViewer.this.themeListener);
                DiffViewer.this.colors.dispose();
            }
        });
        this.refreshDiffColors();
        this.refreshDiffFonts();
        this.styleViewer();
    }

    private void refreshDiffFonts() {
        FontRegistry reg = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        this.headlineFont = reg.get("org.eclipse.egit.ui.DiffHeadlineFont");
    }

    private void refreshDiffColors() {
        ColorRegistry reg = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.addBackgroundColor = reg.get("org.eclipse.egit.ui.DiffAddBackgroundColor");
        this.addForegroundColor = reg.get("org.eclipse.egit.ui.DiffAddForegroundColor");
        this.removeBackgroundColor = reg.get("org.eclipse.egit.ui.DiffRemoveBackgroundColor");
        this.removeForegroundColor = reg.get("org.eclipse.egit.ui.DiffRemoveForegroundColor");
        this.hunkBackgroundColor = reg.get("org.eclipse.egit.ui.DiffHunkBackgroundColor");
        this.hunkForegroundColor = reg.get("org.eclipse.egit.ui.DiffHunkForegroundColor");
        this.headlineBackgroundColor = reg.get("org.eclipse.egit.ui.DiffHeadlineBackgroundColor");
        this.headlineForegroundColor = reg.get("org.eclipse.egit.ui.DiffHeadlineForegroundColor");
    }

    private void initListeners() {
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        EditorsUI.getPreferenceStore().addPropertyChangeListener(this.editorPrefListener);
        this.getTextWidget().addLineBackgroundListener(new LineBackgroundListener(){

            public void lineGetBackground(LineBackgroundEvent event) {
                StyleRange style;
                StyledText text = DiffViewer.this.getTextWidget();
                if (event.lineOffset < text.getCharCount() && (style = text.getStyleRangeAtOffset(event.lineOffset)) instanceof DiffStyleRangeFormatter.DiffStyleRange) {
                    event.lineBackground = ((DiffStyleRangeFormatter.DiffStyleRange)style).lineBackground;
                }
            }
        });
    }

    private ColorDescriptor createEditorColorDescriptor(String key) {
        return ColorDescriptor.createFrom((RGB)PreferenceConverter.getColor((IPreferenceStore)EditorsUI.getPreferenceStore(), (String)key));
    }

    private Color getEditorColor(String key) {
        return (Color)this.colors.get((DeviceResourceDescriptor)this.createEditorColorDescriptor(key));
    }

    private void styleViewer() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        Color foreground = null;
        if (!store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault")) {
            foreground = this.getEditorColor("AbstractTextEditor.Color.Foreground");
        }
        Color background = null;
        if (!store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault")) {
            background = this.getEditorColor("AbstractTextEditor.Color.Background");
        }
        Color selectionForeground = null;
        if (!store.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault")) {
            selectionForeground = this.getEditorColor("AbstractTextEditor.Color.SelectionForeground");
        }
        Color selectionBackground = null;
        if (!store.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault")) {
            selectionBackground = this.getEditorColor("AbstractTextEditor.Color.SelectionBackground");
        }
        StyledText text = this.getTextWidget();
        text.setForeground(foreground);
        text.setBackground(background);
        text.setSelectionForeground(selectionForeground);
        text.setSelectionBackground(selectionBackground);
        text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        if (this.lineNumberRuler != null) {
            this.lineNumberRuler.setFont(text.getFont());
            this.lineNumberRuler.setForeground(foreground);
            this.lineNumberRuler.setBackground(background);
        }
    }

    public void refreshStyleRanges() {
        StyleRange[] ranges;
        StyleRange[] styleRangeArray = ranges = this.formatter != null ? this.formatter.getRanges() : new DiffStyleRangeFormatter.DiffStyleRange[]{};
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            DiffStyleRangeFormatter.DiffStyleRange range = styleRangeArray[n2];
            switch (range.diffType) {
                case ADD: {
                    range.foreground = this.addForegroundColor;
                    range.lineBackground = this.addBackgroundColor;
                    break;
                }
                case REMOVE: {
                    range.foreground = this.removeForegroundColor;
                    range.lineBackground = this.removeBackgroundColor;
                    break;
                }
                case HUNK: {
                    range.foreground = this.hunkForegroundColor;
                    range.lineBackground = this.hunkBackgroundColor;
                    break;
                }
                case HEADLINE: {
                    range.font = this.headlineFont;
                    range.foreground = this.headlineForegroundColor;
                    range.lineBackground = this.headlineBackgroundColor;
                    break;
                }
            }
            ++n2;
        }
        this.getTextWidget().setStyleRanges(ranges);
    }

    public void setFormatter(DiffStyleRangeFormatter formatter) {
        this.formatter = formatter;
        this.refreshStyleRanges();
    }
}

