/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api.script;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.script.DummyParameterAttribute;
import org.eclipse.birt.report.data.adapter.api.script.ReportContextObject;
import org.eclipse.birt.report.data.adapter.api.script.ReportParameters;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class DataAdapterTopLevelScope
extends ImporterTopLevel {
    private static final long serialVersionUID = 4230948829384L;
    private static final String PROP_PARAMS = "params";
    private static final String PROP_REPORTCONTEXT = "reportContext";
    private ModuleHandle designModule;
    private Scriptable paramsProp;
    private Object reportContextProp;
    private Context cx;

    public DataAdapterTopLevelScope(Context cx, ModuleHandle module) {
        super(cx);
        new CoreJavaScriptInitializer().initialize(cx, (Scriptable)this);
        this.cx = cx;
        this.designModule = module;
    }

    public boolean has(String name, Scriptable start) {
        if (super.has(name, start)) {
            return true;
        }
        if (this.designModule != null && PROP_PARAMS.equals(name)) {
            return true;
        }
        return PROP_REPORTCONTEXT.equals(name);
    }

    public Object get(String name, Scriptable start) {
        Object result = super.get(name, start);
        if (result != NOT_FOUND) {
            return result;
        }
        if (this.designModule != null && PROP_PARAMS.equals(name)) {
            return this.getParamsScriptable();
        }
        if (PROP_REPORTCONTEXT.equals(name)) {
            return this.getReportContext();
        }
        return NOT_FOUND;
    }

    private Object getReportContext() {
        if (this.reportContextProp != null) {
            return this.reportContextProp;
        }
        assert (this.designModule != null);
        this.reportContextProp = new ReportContextObject(this.designModule);
        return this.reportContextProp;
    }

    private Scriptable getParamsScriptable() {
        if (this.paramsProp != null) {
            return this.paramsProp;
        }
        assert (this.designModule != null);
        HashMap<String, DummyParameterAttribute> parameters = new HashMap<String, DummyParameterAttribute>();
        List paramsList = this.designModule.getAllParameters();
        int i = 0;
        while (i < paramsList.size()) {
            Object parameterObject = paramsList.get(i);
            if (parameterObject instanceof ScalarParameterHandle) {
                ScalarParameterHandle parameterHandle = (ScalarParameterHandle)parameterObject;
                Object value = DataAdapterUtil.getParamValueFromConfigFile(parameterHandle);
                if (value == null) {
                    Object values = this.getParamDefaultValue(parameterHandle);
                    if (values != null) {
                        Object[] obj = (Object[])values;
                        if (obj.length == 1) {
                            parameters.put(((ScalarParameterHandle)parameterObject).getQualifiedName(), new DummyParameterAttribute(obj[0], ""));
                        } else {
                            parameters.put(((ScalarParameterHandle)parameterObject).getQualifiedName(), new DummyParameterAttribute(obj, ""));
                        }
                    }
                } else {
                    parameters.put(((ScalarParameterHandle)parameterObject).getQualifiedName(), new DummyParameterAttribute(value, ""));
                }
            } else if (parameterObject instanceof DynamicFilterParameterHandle) {
                List defaultValue = ((DynamicFilterParameterHandle)parameterObject).getDefaultValueList();
                if (defaultValue != null && defaultValue.size() > 0) {
                    Expression expression = (Expression)defaultValue.get(0);
                    String defaultValueString = expression.getStringExpression();
                    parameters.put(((DynamicFilterParameterHandle)parameterObject).getQualifiedName(), new DummyParameterAttribute(defaultValueString, ""));
                } else {
                    parameters.put(((DynamicFilterParameterHandle)parameterObject).getQualifiedName(), new DummyParameterAttribute("true", ""));
                }
            }
            ++i;
        }
        this.paramsProp = new ReportParameters(parameters, (Scriptable)this);
        return this.paramsProp;
    }

    private Object getParamDefaultValue(Object params) {
        if (!(params instanceof ScalarParameterHandle)) {
            return null;
        }
        ScalarParameterHandle sp = (ScalarParameterHandle)params;
        Object[] defaultValues = null;
        List defaultValueList = sp.getDefaultValueList();
        if (defaultValueList != null && defaultValueList.size() > 0) {
            defaultValues = new Object[defaultValueList.size()];
            int i = 0;
            while (i < defaultValueList.size()) {
                Expression expression = (Expression)defaultValueList.get(i);
                String defaultValue = expression.getStringExpression();
                String expressionType = expression.getType();
                if ("javascript".equals(expressionType)) {
                    try {
                        Object evaluatedResult = JavascriptEvalUtil.evaluateScript((Context)this.cx, (Scriptable)this, (String)expression.getStringExpression(), (String)ScriptExpression.defaultID, (int)0);
                        if (evaluatedResult != null) {
                            defaultValue = evaluatedResult.toString();
                        }
                    }
                    catch (BirtException e) {
                        e.printStackTrace();
                    }
                }
                String type = sp.getDataType();
                if (defaultValue == null) {
                    if (sp.allowNull()) {
                        defaultValues[i] = null;
                    }
                    if ("string".equals(type)) {
                        defaultValues[i] = "";
                    }
                    if ("float".equals(type)) {
                        defaultValues[i] = new Double(0.0);
                    }
                    if ("decimal".equals(type)) {
                        defaultValues[i] = new BigDecimal(0.0);
                    }
                    if ("dateTime".equals(type)) {
                        defaultValues[i] = new java.util.Date(0L);
                    }
                    if ("date".equals(type)) {
                        defaultValues[i] = new Date(0L);
                    }
                    if ("time".equals(type)) {
                        defaultValues[i] = new Time(0L);
                    }
                    if ("boolean".equals(type)) {
                        defaultValues[i] = Boolean.FALSE;
                    }
                    if ("integer".equals(type)) {
                        defaultValues[i] = 0;
                    }
                    assert (false);
                    defaultValues[i] = null;
                }
                try {
                    defaultValues[i] = DataTypeUtil.convert((Object)defaultValue, (int)DataAdapterUtil.modelDataTypeToCoreDataType(type));
                }
                catch (BirtException birtException) {
                    defaultValues[i] = null;
                }
                ++i;
            }
        }
        return defaultValues;
    }

    private static boolean isToBeConverted(String type) {
        return type.equals("string") || type.equals("dateTime") || type.equals("time") || type.equals("date");
    }
}

