/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCapture;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;

public abstract class IndexerASTVisitor
extends ASTVisitor {
    private IASTName fDefinitionName;
    private IASTNode fDefinitionNode;
    private ArrayList<Definition> fStack = new ArrayList();
    private ArrayList<IASTProblem> fProblems = new ArrayList();

    public IndexerASTVisitor(boolean visitImplicitNames) {
        this.shouldVisitNames = true;
        this.shouldVisitImplicitNames = visitImplicitNames;
        this.shouldVisitDeclarations = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitProblems = true;
        this.shouldVisitExpressions = true;
    }

    public List<IASTProblem> getProblems() {
        return this.fProblems;
    }

    public abstract void visit(IASTName var1, IASTName var2);

    @Override
    public final int visit(IASTName name) {
        if (!(name instanceof ICPPASTQualifiedName) && name != this.fDefinitionName) {
            this.visit(name, this.fDefinitionName);
        }
        return 3;
    }

    private void push(IASTName name, IASTNode node) {
        if (this.fDefinitionName != null) {
            this.fStack.add(new Definition(this.fDefinitionName, this.fDefinitionNode));
        }
        this.fDefinitionName = name = this.getLastInQualified(name);
        this.fDefinitionNode = node;
    }

    private IASTName getLastInQualified(IASTName name) {
        if (name instanceof ICPPASTQualifiedName) {
            name = ((ICPPASTQualifiedName)name).getLastName();
        }
        return name;
    }

    private void pop(IASTNode node) {
        if (node == this.fDefinitionNode) {
            if (this.fStack.isEmpty()) {
                this.fDefinitionName = null;
                this.fDefinitionNode = null;
            } else {
                Definition old = this.fStack.remove(this.fStack.size() - 1);
                this.fDefinitionName = old.fName;
                this.fDefinitionNode = old.fNode;
            }
        }
    }

    @Override
    public int visit(IASTDeclaration decl) {
        IASTSimpleDeclaration sdecl;
        if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDeclarator declarator;
            IASTFunctionDefinition fdef = (IASTFunctionDefinition)decl;
            IASTDeclarator nestedDeclarator = declarator = fdef.getDeclarator();
            while (nestedDeclarator.getNestedDeclarator() != null) {
                nestedDeclarator = nestedDeclarator.getNestedDeclarator();
            }
            IASTName name = this.getLastInQualified(nestedDeclarator.getName());
            this.visit(name, this.fDefinitionName);
            this.push(name, decl);
        } else if (decl instanceof IASTSimpleDeclaration && (sdecl = (IASTSimpleDeclaration)decl).getDeclSpecifier().getStorageClass() == 1) {
            IASTDeclarator[] declarators;
            IASTDeclarator[] iASTDeclaratorArray = declarators = sdecl.getDeclarators();
            int n = declarators.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator declarator = iASTDeclaratorArray[n2];
                if (declarator.getPointerOperators().length == 0 && declarator.getNestedDeclarator() == null) {
                    IASTName name = this.getLastInQualified(declarator.getName());
                    this.visit(name, this.fDefinitionName);
                    this.push(name, decl);
                }
                ++n2;
            }
        }
        return 3;
    }

    @Override
    public int leave(IASTDeclaration decl) {
        this.pop(decl);
        return 3;
    }

    @Override
    public int visit(IASTDeclSpecifier declspec) {
        IASTName name;
        IASTCompositeTypeSpecifier cts;
        if (declspec instanceof ICPPASTCompositeTypeSpecifier) {
            cts = (ICPPASTCompositeTypeSpecifier)declspec;
            name = this.getLastInQualified(cts.getName());
            this.visit(name, this.fDefinitionName);
            this.push(name, declspec);
        }
        if (declspec instanceof ICASTCompositeTypeSpecifier) {
            cts = (ICASTCompositeTypeSpecifier)declspec;
            name = cts.getName();
            this.visit(name, this.fDefinitionName);
            this.push(name, declspec);
        }
        return 3;
    }

    @Override
    public int leave(IASTDeclSpecifier declspec) {
        this.pop(declspec);
        return 3;
    }

    @Override
    public int visit(IASTProblem problem) {
        this.fProblems.add(problem);
        return 1;
    }

    @Override
    public int visit(IASTInitializer initializer) {
        IASTNode cand;
        if (!(this.fDefinitionNode instanceof IASTFunctionDefinition) && (cand = initializer.getParent()) instanceof IASTDeclarator) {
            cand = ASTQueries.findInnermostDeclarator((IASTDeclarator)cand);
            this.push(((IASTDeclarator)cand).getName(), initializer);
        }
        return 3;
    }

    @Override
    public int leave(IASTInitializer initializer) {
        this.pop(initializer);
        return 3;
    }

    @Override
    public int visit(IASTExpression expr) {
        if (expr instanceof ICPPASTLambdaExpression) {
            return this.visit((ICPPASTLambdaExpression)expr);
        }
        return 3;
    }

    private int visit(ICPPASTLambdaExpression lambdaExpr) {
        ICPPASTCapture[] iCPPASTCaptureArray = lambdaExpr.getCaptures();
        int n = iCPPASTCaptureArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTCapture cap = iCPPASTCaptureArray[n2];
            if (!cap.accept(this)) {
                return 2;
            }
            ++n2;
        }
        IASTImplicitName closureName = lambdaExpr.getClosureTypeName();
        this.visit(closureName, this.fDefinitionName);
        IASTImplicitName callOp = lambdaExpr.getFunctionCallOperatorName();
        this.visit(callOp, closureName);
        this.push(callOp, lambdaExpr);
        ICPPASTFunctionDeclarator dtor = lambdaExpr.getDeclarator();
        if (dtor != null && !dtor.accept(this)) {
            return 2;
        }
        IASTCompoundStatement body = lambdaExpr.getBody();
        if (body != null && !body.accept(this)) {
            return 2;
        }
        this.pop(lambdaExpr);
        return 1;
    }

    private static class Definition {
        IASTName fName;
        IASTNode fNode;

        Definition(IASTName name, IASTNode node) {
            this.fName = name;
            this.fNode = node;
        }
    }
}

