/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTBinaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.core.runtime.CoreException;

public class EvalBinaryTypeId
extends CPPEvaluation {
    private final IASTBinaryTypeIdExpression.Operator fOperator;
    private final IType fType1;
    private final IType fType2;
    private boolean fCheckedValueDependent;
    private boolean fIsValueDependent;

    public EvalBinaryTypeId(IASTBinaryTypeIdExpression.Operator kind, IType type1, IType type2) {
        this.fOperator = kind;
        this.fType1 = type1;
        this.fType2 = type2;
    }

    public IASTBinaryTypeIdExpression.Operator getOperator() {
        return this.fOperator;
    }

    public IType getType1() {
        return this.fType1;
    }

    public IType getType2() {
        return this.fType2;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        switch (this.fOperator) {
            case __is_base_of: {
                return CPPBasicType.BOOLEAN;
            }
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        return Value.evaluateBinaryTypeIdExpression(this.fOperator, this.fType1, this.fType2, point);
    }

    @Override
    public boolean isTypeDependent() {
        return false;
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedValueDependent) {
            this.fIsValueDependent = CPPTemplates.isDependentType(this.fType1) || CPPTemplates.isDependentType(this.fType2);
            this.fCheckedValueDependent = true;
        }
        return this.fIsValueDependent;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putByte((byte)2);
        buffer.putByte((byte)this.fOperator.ordinal());
        buffer.marshalType(this.fType1);
        buffer.marshalType(this.fType2);
    }

    public static ISerializableEvaluation unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        IType arg1 = buffer.unmarshalType();
        IType arg2 = buffer.unmarshalType();
        return new EvalBinaryTypeId(IASTBinaryTypeIdExpression.Operator.values()[op], arg1, arg2);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        IType type1 = CPPTemplates.instantiateType(this.fType1, tpMap, packOffset, within, point);
        IType type2 = CPPTemplates.instantiateType(this.fType2, tpMap, packOffset, within, point);
        if (type1 == this.fType1 && type2 == this.fType2) {
            return this;
        }
        return new EvalBinaryTypeId(this.fOperator, type1, type2);
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, int maxdepth, IASTNode point) {
        return this;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.combinePackSize(CPPTemplates.determinePackSize(this.fType1, tpMap), CPPTemplates.determinePackSize(this.fType2, tpMap));
    }

    @Override
    public boolean referencesTemplateParameter() {
        return false;
    }
}

