/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.core.runtime.CoreException;

public class CPPBasicType
implements ICPPBasicType,
ISerializableType {
    private static final int FROM_STRING_LITERAL = Integer.MIN_VALUE;
    public static final CPPBasicType BOOLEAN = new CPPBasicType(IBasicType.Kind.eBoolean, 0, null);
    public static final CPPBasicType NULL_PTR = new CPPBasicType(IBasicType.Kind.eNullPtr, 0, null);
    private final IBasicType.Kind fKind;
    private final int fModifiers;
    private Long fAssociatedValue;

    public CPPBasicType(IBasicType.Kind kind, int qualifiers, IASTExpression expression) {
        this.fKind = kind == IBasicType.Kind.eUnspecified ? ((qualifiers & 0x30) != 0 ? IBasicType.Kind.eFloat : ((qualifiers & 0x4F) != 0 ? IBasicType.Kind.eInt : IBasicType.Kind.eUnspecified)) : kind;
        if (expression instanceof IASTLiteralExpression && ((IASTLiteralExpression)expression).getKind() == 3) {
            qualifiers |= Integer.MIN_VALUE;
        }
        this.fModifiers = qualifiers;
        if (expression instanceof ICPPASTInitializerClause) {
            this.fAssociatedValue = Value.create(expression, 25).numericalValue();
        }
    }

    public CPPBasicType(IBasicType.Kind kind, int qualifiers) {
        this(kind, qualifiers, null);
    }

    public CPPBasicType(ICPPASTSimpleDeclSpecifier sds) {
        this(CPPBasicType.getKind(sds), CPPBasicType.getModifiers(sds), null);
    }

    private static int getModifiers(ICPPASTSimpleDeclSpecifier sds) {
        return (sds.isLong() ? 1 : 0) | (sds.isShort() ? 2 : 0) | (sds.isSigned() ? 4 : 0) | (sds.isUnsigned() ? 8 : 0) | (sds.isLongLong() ? 64 : 0) | (sds.isComplex() ? 16 : 0) | (sds.isImaginary() ? 32 : 0);
    }

    private static IBasicType.Kind getKind(ICPPASTSimpleDeclSpecifier sds) {
        return CPPBasicType.getKind(sds.getType());
    }

    static IBasicType.Kind getKind(int simpleDeclSpecType) {
        switch (simpleDeclSpecType) {
            case 6: {
                return IBasicType.Kind.eBoolean;
            }
            case 2: {
                return IBasicType.Kind.eChar;
            }
            case 7: {
                return IBasicType.Kind.eWChar;
            }
            case 11: {
                return IBasicType.Kind.eChar16;
            }
            case 12: {
                return IBasicType.Kind.eChar32;
            }
            case 5: {
                return IBasicType.Kind.eDouble;
            }
            case 4: {
                return IBasicType.Kind.eFloat;
            }
            case 14: {
                return IBasicType.Kind.eFloat128;
            }
            case 3: {
                return IBasicType.Kind.eInt;
            }
            case 13: {
                return IBasicType.Kind.eInt128;
            }
            case 1: {
                return IBasicType.Kind.eVoid;
            }
        }
        return IBasicType.Kind.eUnspecified;
    }

    @Override
    public boolean isSameType(IType object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ITypedef) {
            return object.isSameType(this);
        }
        if (!(object instanceof ICPPBasicType)) {
            return false;
        }
        ICPPBasicType other = (ICPPBasicType)object;
        if (this.fKind != other.getKind()) {
            return false;
        }
        int modifiers = this.getModifiers();
        int otherModifiers = other.getModifiers();
        if (this.fKind == IBasicType.Kind.eInt) {
            return (modifiers & 0xFFFFFFFB) == (otherModifiers & 0xFFFFFFFB);
        }
        return modifiers == otherModifiers;
    }

    @Override
    public IBasicType.Kind getKind() {
        return this.fKind;
    }

    @Override
    public boolean isSigned() {
        return (this.fModifiers & 4) != 0;
    }

    @Override
    public boolean isUnsigned() {
        return (this.fModifiers & 8) != 0;
    }

    @Override
    public boolean isShort() {
        return (this.fModifiers & 2) != 0;
    }

    @Override
    public boolean isLong() {
        return (this.fModifiers & 1) != 0;
    }

    @Override
    public boolean isLongLong() {
        return (this.fModifiers & 0x40) != 0;
    }

    @Override
    public boolean isComplex() {
        return (this.fModifiers & 0x10) != 0;
    }

    @Override
    public boolean isImaginary() {
        return (this.fModifiers & 0x20) != 0;
    }

    @Override
    public CPPBasicType clone() {
        CPPBasicType t = null;
        try {
            t = (CPPBasicType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public final void setAssociatedNumericalValue(Long value) {
        this.fAssociatedValue = value;
    }

    public final Long getAssociatedNumericalValue() {
        return this.fAssociatedValue;
    }

    public final boolean isFromStringLiteral() {
        return (this.fModifiers & Integer.MIN_VALUE) != 0;
    }

    @Override
    public final int getModifiers() {
        return this.fModifiers & Integer.MAX_VALUE;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int kind = this.getKind().ordinal();
        int shiftedKind = kind * 16;
        int modifiers = this.getModifiers();
        if (shiftedKind < 128 && modifiers == 0) {
            buffer.putByte((byte)(1 | shiftedKind));
        } else {
            buffer.putByte((byte)-127);
            buffer.putByte((byte)kind);
            buffer.putByte((byte)modifiers);
        }
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        int kind;
        boolean dense = (firstByte & 0x80) == 0;
        int modifiers = 0;
        if (dense) {
            kind = (firstByte & 0x7F) / 16;
        } else {
            kind = buffer.getByte();
            modifiers = buffer.getByte();
        }
        return new CPPBasicType(IBasicType.Kind.values()[kind], modifiers);
    }

    @Override
    @Deprecated
    public int getQualifierBits() {
        return this.getModifiers();
    }

    @Override
    @Deprecated
    public int getType() {
        switch (this.fKind) {
            case eBoolean: {
                return 6;
            }
            case eChar: 
            case eChar16: 
            case eChar32: {
                return 2;
            }
            case eWChar: {
                return 7;
            }
            case eDouble: {
                return 5;
            }
            case eFloat: {
                return 4;
            }
            case eInt: {
                return 3;
            }
            case eVoid: {
                return 1;
            }
            case eUnspecified: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    @Deprecated
    public IASTExpression getValue() {
        return null;
    }
}

