/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpansionExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTPackExpansionExpression
extends ASTNode
implements ICPPASTPackExpansionExpression,
IASTAmbiguityParent {
    private IASTExpression fPattern;
    private ICPPEvaluation fEvaluation;

    public CPPASTPackExpansionExpression(IASTExpression pattern) {
        this.setPattern(pattern);
    }

    @Override
    public void setPattern(IASTExpression pattern) {
        this.assertNotFrozen();
        this.fPattern = pattern;
        if (pattern != null) {
            pattern.setParent(this);
            pattern.setPropertyInParent(ICPPASTPackExpansionExpression.PATTERN);
        }
    }

    @Override
    public IASTExpression getPattern() {
        return this.fPattern;
    }

    @Override
    public CPPASTPackExpansionExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTPackExpansionExpression copy(IASTNode.CopyStyle style) {
        CPPASTPackExpansionExpression copy = new CPPASTPackExpansionExpression(this.fPattern.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            IType type = this.fPattern.getExpressionType();
            type = type == null ? ProblemType.UNKNOWN_FOR_EXPRESSION : new CPPParameterPackType(type);
            this.fEvaluation = new EvalFixed(type, IASTExpression.ValueCategory.PRVALUE, Value.create(((ICPPASTExpression)this.fPattern).getEvaluation()));
        }
        return this.fEvaluation;
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public boolean isLValue() {
        return this.fPattern.isLValue();
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.fPattern.getValueCategory();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (visitor.shouldVisitExpressions) {
            switch (visitor.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.fPattern.accept(visitor)) {
            return false;
        }
        return !visitor.shouldVisitExpressions || visitor.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fPattern) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fPattern = (IASTExpression)other;
        }
    }
}

